/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.checker.BitstreamInfo;
import org.dspace.checker.ChecksumHistoryDAO;
import org.dspace.checker.DAOSupport;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;

public final class BitstreamInfoDAO
extends DAOSupport {
    public static final int SENTINEL = -1;
    private static final String FIND_BY_BITSTREAM_ID = "select bitstream.deleted, bitstream.store_number, bitstream.size_bytes, bitstreamformatregistry.short_description, bitstream.bitstream_id,  bitstream.internal_id, bitstream.checksum_algorithm, bitstream.checksum, most_recent_checksum.last_process_end_date,most_recent_checksum.to_be_processed from bitstream left outer join bitstreamformatregistry on bitstream.bitstream_format_id = bitstreamformatregistry.bitstream_format_id, most_recent_checksum where bitstream.bitstream_id = ? and bitstream.bitstream_id = most_recent_checksum.bitstream_id";
    private static final String INSERT_MISSING_CHECKSUM_BITSTREAMS = "insert into most_recent_checksum ( bitstream_id, to_be_processed, expected_checksum, current_checksum, last_process_start_date, last_process_end_date, checksum_algorithm, matched_prev_checksum, result ) select bitstream.bitstream_id, CASE WHEN bitstream.deleted = false THEN true ELSE false END, CASE WHEN bitstream.checksum IS NULL THEN '' ELSE bitstream.checksum END, CASE WHEN bitstream.checksum IS NULL THEN '' ELSE bitstream.checksum END, ?, ?, CASE WHEN bitstream.checksum_algorithm IS NULL THEN 'MD5' ELSE bitstream.checksum_algorithm END, true, CASE WHEN bitstream.deleted = true THEN 'BITSTREAM_MARKED_DELETED' else 'CHECKSUM_MATCH' END from bitstream where not exists( select 'x' from most_recent_checksum where most_recent_checksum.bitstream_id = bitstream.bitstream_id )";
    private static final String INSERT_MISSING_CHECKSUM_BITSTREAMS_ORACLE = "insert into most_recent_checksum ( bitstream_id, to_be_processed, expected_checksum, current_checksum, last_process_start_date, last_process_end_date, checksum_algorithm, matched_prev_checksum, result ) select bitstream.bitstream_id, CASE WHEN bitstream.deleted = 0 THEN 1 ELSE 0 END, CASE WHEN bitstream.checksum IS NULL THEN '' ELSE bitstream.checksum END, CASE WHEN bitstream.checksum IS NULL THEN '' ELSE bitstream.checksum END, ? AS last_process_start_date, ? AS last_process_end_date, CASE WHEN bitstream.checksum_algorithm IS NULL THEN 'MD5' ELSE bitstream.checksum_algorithm END, 1, CASE WHEN bitstream.deleted = 1 THEN 'BITSTREAM_MARKED_DELETED' else 'CHECKSUM_MATCH' END from bitstream where not exists( select 'x' from most_recent_checksum where most_recent_checksum.bitstream_id = bitstream.bitstream_id )";
    private static final String UPDATE_CHECKSUM = "UPDATE  most_recent_checksum SET current_checksum = ?, expected_checksum = ?, matched_prev_checksum = ?, to_be_processed= ?, last_process_start_date=?, last_process_end_date=?, result=? WHERE bitstream_id = ? ";
    private static final String DELETE_BITSTREAM_INFO = "Delete from most_recent_checksum where bitstream_id = ?";
    public static final String GET_OLDEST_BITSTREAM = "select bitstream_id  from most_recent_checksum where to_be_processed = true order by date_trunc('milliseconds', last_process_end_date), bitstream_id ASC LIMIT 1";
    public static final String GET_OLDEST_BITSTREAM_ORACLE = "SELECT bitstream_id FROM (select bitstream_id  from most_recent_checksum where to_be_processed = 1 order by trunc(last_process_end_date, 'mi'), bitstream_id ASC) WHERE rownum=1";
    public static final String GET_OLDEST_BITSTREAM_DATE = "select bitstream_id  from most_recent_checksum where to_be_processed = true and last_process_start_date < ? order by date_trunc('milliseconds', last_process_end_date), bitstream_id ASC LIMIT 1";
    public static final String GET_OLDEST_BITSTREAM_DATE_ORACLE = "SELECT bitstream_id FROM (select bitstream_id  from most_recent_checksum where to_be_processed = 1 and last_process_start_date < ? order by trunc(last_process_end_date, 'mi'), bitstream_id ASC) WHERE rownum=1";
    private static final String ITEM_BITSTREAMS = "SELECT b2b.bitstream_id FROM bundle2bitstream b2b, item2bundle i2b WHERE b2b.bundle_id=i2b.bundle_id AND i2b.item_id=?";
    private static final String COLLECTION_BITSTREAMS = "SELECT b2b.bitstream_id FROM bundle2bitstream b2b, item2bundle i2b, collection2item c2i WHERE b2b.bundle_id=i2b.bundle_id AND c2i.item_id=i2b.item_id AND c2i.collection_id=?";
    private static final String COMMUNITY_BITSTREAMS = "SELECT b2b.bitstream_id FROM bundle2bitstream b2b, item2bundle i2b, collection2item c2i, community2collection c2c WHERE b2b.bundle_id=i2b.bundle_id AND c2i.item_id=i2b.item_id AND c2c.collection_id=c2i.collection_id AND c2c.community_id=?";
    private static final Logger LOG = Logger.getLogger(BitstreamInfoDAO.class);
    private ChecksumHistoryDAO checksumHistoryDAO = new ChecksumHistoryDAO();

    public void update(BitstreamInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("BitstreamInfo parameter may not be null");
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = DatabaseManager.getConnection();
            stmt = conn.prepareStatement(UPDATE_CHECKSUM);
            stmt.setString(1, info.getCalculatedChecksum() != null ? info.getCalculatedChecksum() : "");
            stmt.setString(2, info.getStoredChecksum());
            stmt.setBoolean(3, "CHECKSUM_MATCH".equals(info.getChecksumCheckResult()));
            stmt.setBoolean(4, info.getToBeProcessed());
            stmt.setTimestamp(5, new Timestamp(info.getProcessStartDate().getTime()));
            stmt.setTimestamp(6, new Timestamp(info.getProcessEndDate().getTime()));
            stmt.setString(7, info.getChecksumCheckResult());
            stmt.setInt(8, info.getBitstreamId());
            stmt.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            LOG.error((Object)("Problem updating checksum row. " + e.getMessage()), (Throwable)e);
            throw new IllegalStateException("Problem updating checksum row. " + e.getMessage(), e);
        }
        finally {
            this.cleanup(stmt, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitstreamInfo findByBitstreamId(Context context, int id) {
        Connection conn = null;
        BitstreamInfo info = null;
        PreparedStatement prepStmt = null;
        try {
            conn = DatabaseManager.getConnection();
            prepStmt = conn.prepareStatement(FIND_BY_BITSTREAM_ID);
            prepStmt.setInt(1, id);
            ResultSet rs = prepStmt.executeQuery();
            if (rs.next()) {
                Bitstream bitstream = Bitstream.find(context, rs.getInt("bitstream_id"));
                info = new BitstreamInfo(rs.getBoolean("deleted"), rs.getInt("store_number"), rs.getLong("size_bytes"), rs.getString("short_description"), rs.getInt("bitstream_id"), bitstream.getUserFormatDescription(), rs.getString("internal_id"), bitstream.getSource(), rs.getString("checksum_algorithm"), rs.getString("checksum"), bitstream.getName(), rs.getTimestamp("last_process_end_date"), rs.getBoolean("to_be_processed"), new Date());
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)("Bitstream metadata could not be retrieved. " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.cleanup(prepStmt, conn);
        }
        return info;
    }

    public void updateMissingBitstreams() {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            LOG.debug((Object)"updating missing bitstreams");
            conn = DatabaseManager.getConnection();
            stmt = DatabaseManager.isOracle() ? conn.prepareStatement(INSERT_MISSING_CHECKSUM_BITSTREAMS_ORACLE) : conn.prepareStatement(INSERT_MISSING_CHECKSUM_BITSTREAMS);
            stmt.setTimestamp(1, new Timestamp(new Date().getTime()));
            stmt.setTimestamp(2, new Timestamp(new Date().getTime()));
            stmt.executeUpdate();
            this.checksumHistoryDAO.updateMissingBitstreams(conn);
            conn.commit();
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)("Problem inserting missing bitstreams. " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Problem inserting missing bitstreams. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(stmt, conn);
                throw throwable;
            }
        }
        this.cleanup(stmt, conn);
    }

    protected int deleteBitstreamInfo(int id, Connection conn) {
        PreparedStatement stmt = null;
        int numDeleted = 0;
        try {
            stmt = conn.prepareStatement(DELETE_BITSTREAM_INFO);
            stmt.setInt(1, id);
            numDeleted = stmt.executeUpdate();
            if (numDeleted > 1) {
                conn.rollback();
                throw new IllegalStateException("Too many rows deleted! Number of rows deleted: " + numDeleted + " only one row should be deleted for bitstream id " + id);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("Problem deleting bitstream. " + e.getMessage()), (Throwable)e);
            throw new IllegalStateException("Problem deleting bitstream. " + e.getMessage(), e);
        }
        finally {
            this.cleanup(stmt);
        }
        return numDeleted;
    }

    public int deleteBitstreamInfoWithHistory(int id) {
        Connection conn = null;
        int numDeleted = 0;
        try {
            conn = DatabaseManager.getConnection();
            this.deleteBitstreamInfo(id, conn);
            this.checksumHistoryDAO.deleteHistoryForBitstreamInfo(id, conn);
            conn.commit();
        }
        catch (SQLException e) {
            LOG.error((Object)("Problem deleting bitstream. " + e.getMessage()), (Throwable)e);
            throw new IllegalStateException("Problem deleting bitstream. " + e.getMessage(), e);
        }
        finally {
            this.cleanup(conn);
        }
        return numDeleted;
    }

    public int getOldestBitstream() {
        int n;
        PreparedStatement prepStmt;
        Connection conn;
        block5: {
            conn = null;
            prepStmt = null;
            ResultSet rs = null;
            conn = DatabaseManager.getConnection();
            prepStmt = DatabaseManager.isOracle() ? conn.prepareStatement(GET_OLDEST_BITSTREAM_ORACLE) : conn.prepareStatement(GET_OLDEST_BITSTREAM);
            rs = prepStmt.executeQuery();
            if (!rs.next()) break block5;
            int n2 = rs.getInt(1);
            this.cleanup(prepStmt, conn);
            return n2;
        }
        try {
            n = -1;
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)("Problem with get oldest bitstream " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Oldest bitstream error. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(prepStmt, conn);
                throw throwable;
            }
        }
        this.cleanup(prepStmt, conn);
        return n;
    }

    public int getOldestBitstream(Timestamp lessThanDate) {
        int n;
        PreparedStatement prepStmt;
        Connection conn;
        block5: {
            conn = null;
            prepStmt = null;
            ResultSet rs = null;
            conn = DatabaseManager.getConnection();
            prepStmt = DatabaseManager.isOracle() ? conn.prepareStatement(GET_OLDEST_BITSTREAM_DATE_ORACLE) : conn.prepareStatement(GET_OLDEST_BITSTREAM_DATE);
            prepStmt.setTimestamp(1, lessThanDate);
            rs = prepStmt.executeQuery();
            if (!rs.next()) break block5;
            int n2 = rs.getInt(1);
            this.cleanup(prepStmt, conn);
            return n2;
        }
        try {
            n = -1;
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)("get oldest bitstream less than date " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("get oldest bitstream less than date. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(prepStmt, conn);
                throw throwable;
            }
        }
        this.cleanup(prepStmt, conn);
        return n;
    }

    public List<Integer> getItemBitstreams(int itemId) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DatabaseManager.getConnection();
            ps = conn.prepareStatement(ITEM_BITSTREAMS);
            ps.setInt(1, itemId);
            rs = ps.executeQuery();
            while (rs.next()) {
                ids.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)("get item bitstreams " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("get item bitstreams. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(ps, conn, rs);
                throw throwable;
            }
        }
        this.cleanup(ps, conn, rs);
        return ids;
    }

    public List<Integer> getCollectionBitstreams(int collectionId) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DatabaseManager.getConnection();
            ps = conn.prepareStatement(COLLECTION_BITSTREAMS);
            ps.setInt(1, collectionId);
            rs = ps.executeQuery();
            while (rs.next()) {
                ids.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)("get item bitstreams " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("get item bitstreams. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(ps, conn, rs);
                throw throwable;
            }
        }
        this.cleanup(ps, conn, rs);
        return ids;
    }

    public List<Integer> getCommunityBitstreams(int communityId) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DatabaseManager.getConnection();
            ps = conn.prepareStatement(COMMUNITY_BITSTREAMS);
            ps.setInt(1, communityId);
            rs = ps.executeQuery();
            while (rs.next()) {
                ids.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)("get item bitstreams " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("get item bitstreams. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(ps, conn, rs);
                throw throwable;
            }
        }
        this.cleanup(ps, conn, rs);
        return ids;
    }
}

