/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.checker.BitstreamInfo;
import org.dspace.checker.DAOSupport;
import org.dspace.storage.rdbms.DatabaseManager;

public class ChecksumHistoryDAO
extends DAOSupport {
    private static final String INSERT_MISSING_HISTORY_BITSTREAMS = "insert into checksum_history ( bitstream_id, process_start_date, process_end_date, checksum_expected, checksum_calculated, result ) select most_recent_checksum.bitstream_id, most_recent_checksum.last_process_start_date, most_recent_checksum.last_process_end_date, most_recent_checksum.expected_checksum, most_recent_checksum.expected_checksum, CASE WHEN bitstream.deleted = true THEN 'BITSTREAM_MARKED_DELETED' else 'CHECKSUM_MATCH' END from most_recent_checksum, bitstream where not exists( select 'x' from checksum_history where most_recent_checksum.bitstream_id = checksum_history.bitstream_id ) and most_recent_checksum.bitstream_id = bitstream.bitstream_id";
    private static final String INSERT_MISSING_HISTORY_BITSTREAMS_ORACLE = "insert into checksum_history ( check_id, bitstream_id, process_start_date, process_end_date, checksum_expected, checksum_calculated, result ) select checksum_history_seq.nextval, most_recent_checksum.bitstream_id, most_recent_checksum.last_process_start_date, most_recent_checksum.last_process_end_date, most_recent_checksum.expected_checksum, most_recent_checksum.expected_checksum, CASE WHEN bitstream.deleted = 1 THEN 'BITSTREAM_MARKED_DELETED' else 'CHECKSUM_MATCH' END from most_recent_checksum, bitstream where not exists( select 'x' from checksum_history where most_recent_checksum.bitstream_id = checksum_history.bitstream_id ) and most_recent_checksum.bitstream_id = bitstream.bitstream_id";
    private static final String INSERT_HISTORY = "insert into checksum_history (  bitstream_id, process_start_date,  process_end_date, checksum_expected, checksum_calculated, result )  values ( ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_HISTORY_ORACLE = "insert into checksum_history (  check_id, bitstream_id, process_start_date,  process_end_date, checksum_expected, checksum_calculated, result )  values ( checksum_history_seq.nextval, ?, ?, ?, ?, ?, ?)";
    private static final String DELETE_BITSTREAM_HISTORY = "Delete from checksum_history where bitstream_id = ?";
    private static final Logger LOG = Logger.getLogger(ChecksumHistoryDAO.class);

    public void insertHistory(BitstreamInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("BitstreamInfo parameter may not be null");
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = DatabaseManager.getConnection();
            stmt = DatabaseManager.isOracle() ? conn.prepareStatement(INSERT_HISTORY_ORACLE) : conn.prepareStatement(INSERT_HISTORY);
            stmt.setInt(1, info.getBitstreamId());
            stmt.setTimestamp(2, new Timestamp(info.getProcessStartDate().getTime()));
            stmt.setTimestamp(3, new Timestamp(info.getProcessEndDate().getTime()));
            stmt.setString(4, info.getStoredChecksum());
            stmt.setString(5, info.getCalculatedChecksum());
            stmt.setString(6, info.getChecksumCheckResult());
            stmt.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)("Problem updating checksum row. " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Problem updating checksum row. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(stmt, conn);
                throw throwable;
            }
        }
        this.cleanup(stmt, conn);
    }

    protected int deleteHistoryForBitstreamInfo(int id, Connection conn) {
        PreparedStatement stmt = null;
        int numDeleted = 0;
        try {
            conn = DatabaseManager.getConnection();
            stmt = conn.prepareStatement(DELETE_BITSTREAM_HISTORY);
            stmt.setInt(1, id);
            numDeleted = stmt.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            LOG.error((Object)("Problem with inserting missing bitstream. " + e.getMessage()), (Throwable)e);
            throw new IllegalStateException("Problem inserting missing bitstream. " + e.getMessage(), e);
        }
        finally {
            this.cleanup(stmt, conn);
        }
        return numDeleted;
    }

    protected void updateMissingBitstreams(Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = DatabaseManager.isOracle() ? conn.prepareStatement(INSERT_MISSING_HISTORY_BITSTREAMS_ORACLE) : conn.prepareStatement(INSERT_MISSING_HISTORY_BITSTREAMS);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)("Problem updating missing history. " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Problem updating missing history. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(stmt);
                throw throwable;
            }
        }
        this.cleanup(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deleteHistoryByDateAndCode(Date retentionDate, String result, Connection conn) throws SQLException {
        PreparedStatement update = null;
        try {
            update = conn.prepareStatement("DELETE FROM checksum_history WHERE process_end_date<? AND result=?");
            update.setTimestamp(1, new Timestamp(retentionDate.getTime()));
            update.setString(2, result);
            int n = update.executeUpdate();
            return n;
        }
        finally {
            this.cleanup(update);
        }
    }

    public int prune(Map<String, Long> interests) {
        Connection conn = null;
        try {
            conn = DatabaseManager.getConnection();
            long now = System.currentTimeMillis();
            int count = 0;
            for (Map.Entry<String, Long> interest : interests.entrySet()) {
                count += this.deleteHistoryByDateAndCode(new Date(now - interest.getValue()), interest.getKey(), conn);
                conn.commit();
            }
            int n = count;
            return n;
        }
        catch (SQLException e) {
            LOG.error((Object)("Problem pruning results: " + e.getMessage()), (Throwable)e);
            throw new IllegalStateException("Problem pruning results: " + e.getMessage(), e);
        }
        finally {
            DatabaseManager.freeConnection(conn);
        }
    }
}

