/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.handle.HandleManager;
import org.dspace.services.model.Event;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.usage.UsageWorkflowEvent;
import org.dspace.utils.DSpace;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.WorkflowException;
import org.dspace.xmlworkflow.WorkflowFactory;
import org.dspace.xmlworkflow.WorkflowRequirementsManager;
import org.dspace.xmlworkflow.WorkflowUtils;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.Action;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.UserSelectionActionConfig;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.WorkflowItemRole;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class XmlWorkflowManager {
    private static Map<Integer, Boolean> noEMail = new HashMap<Integer, Boolean>();
    private static Logger log = Logger.getLogger(XmlWorkflowManager.class);

    public static XmlWorkflowItem start(Context context, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException, WorkflowConfigurationException, MessagingException, WorkflowException {
        Item myitem = wsi.getItem();
        Collection collection = wsi.getCollection();
        Workflow wf = WorkflowFactory.getWorkflow(collection);
        XmlWorkflowItem wfi = XmlWorkflowItem.create(context);
        wfi.setItem(myitem);
        wfi.setCollection(wsi.getCollection());
        wfi.setMultipleFiles(wsi.hasMultipleFiles());
        wfi.setMultipleTitles(wsi.hasMultipleTitles());
        wfi.setPublishedBefore(wsi.isPublishedBefore());
        wfi.update();
        XmlWorkflowManager.removeUserItemPolicies(context, myitem, myitem.getSubmitter());
        XmlWorkflowManager.grantSubmitterReadPolicies(context, myitem);
        context.turnOffAuthorisationSystem();
        Step firstStep = wf.getFirstStep();
        if (firstStep.isValidStep(context, wfi)) {
            XmlWorkflowManager.activateFirstStep(context, wf, firstStep, wfi);
        } else if ((firstStep = wf.getNextStep(context, wfi, firstStep, 0)) == null) {
            XmlWorkflowManager.archive(context, wfi);
        } else {
            XmlWorkflowManager.activateFirstStep(context, wf, firstStep, wfi);
        }
        wsi.deleteWrapper();
        context.restoreAuthSystemState();
        return wfi;
    }

    public static XmlWorkflowItem startWithoutNotify(Context c, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException, WorkflowException, WorkflowConfigurationException, MessagingException {
        noEMail.put(wsi.getItem().getID(), Boolean.TRUE);
        return XmlWorkflowManager.start(c, wsi);
    }

    public static void alertUsersOnTaskActivation(Context c, XmlWorkflowItem wfi, String emailTemplate, List<EPerson> epa, String ... arguments) throws IOException, SQLException, MessagingException {
        if (noEMail.containsKey(wfi.getItem().getID())) {
            noEMail.remove(wfi.getItem().getID());
        } else {
            Email mail = Email.getEmail(I18nUtil.getEmailFilename(c.getCurrentLocale(), emailTemplate));
            for (String argument : arguments) {
                mail.addArgument(argument);
            }
            for (EPerson anEpa : epa) {
                mail.addRecipient(anEpa.getEmail());
            }
            mail.send();
        }
    }

    private static void grantSubmitterReadPolicies(Context context, Item item) throws SQLException, AuthorizeException {
        ArrayList<Integer> userHasPolicies = new ArrayList<Integer>();
        List<ResourcePolicy> itempols = AuthorizeManager.getPolicies(context, item);
        EPerson submitter = item.getSubmitter();
        for (ResourcePolicy resourcePolicy : itempols) {
            if (resourcePolicy.getEPersonID() != submitter.getID()) continue;
            userHasPolicies.add(resourcePolicy.getAction());
        }
        if (!userHasPolicies.contains(0)) {
            XmlWorkflowManager.addPolicyToItem(context, item, 0, submitter);
        }
    }

    private static void activateFirstStep(Context context, Workflow wf, Step firstStep, XmlWorkflowItem wfi) throws AuthorizeException, IOException, SQLException, WorkflowException, WorkflowConfigurationException {
        UserSelectionActionConfig firstActionConfig = firstStep.getUserSelectionMethod();
        ((WorkflowActionConfig)firstActionConfig).getProcessingAction().activate(context, wfi);
        log.info((Object)LogManager.getHeader(context, "start_workflow", ((WorkflowActionConfig)firstActionConfig).getProcessingAction() + " workflow_item_id=" + wfi.getID() + "item_id=" + wfi.getItem().getID() + "collection_id=" + wfi.getCollection().getID()));
        XmlWorkflowManager.recordStart(wfi.getItem(), ((WorkflowActionConfig)firstActionConfig).getProcessingAction());
        XmlWorkflowManager.logWorkflowEvent(context, firstStep.getWorkflow().getID(), null, null, wfi, null, firstStep, firstActionConfig);
        if (!firstActionConfig.requiresUI()) {
            ActionResult outcome = ((WorkflowActionConfig)firstActionConfig).getProcessingAction().execute(context, wfi, firstStep, null);
            XmlWorkflowManager.processOutcome(context, null, wf, firstStep, firstActionConfig, outcome, wfi, true);
        }
    }

    public static WorkflowActionConfig doState(Context c, EPerson user, HttpServletRequest request, int workflowItemId, Workflow workflow, WorkflowActionConfig currentActionConfig) throws SQLException, AuthorizeException, IOException, MessagingException, WorkflowConfigurationException, WorkflowException {
        try {
            XmlWorkflowItem wi = XmlWorkflowItem.find(c, workflowItemId);
            Step currentStep = currentActionConfig.getStep();
            if (currentActionConfig.getProcessingAction().isAuthorized(c, request, wi)) {
                ActionResult outcome = currentActionConfig.getProcessingAction().execute(c, wi, currentStep, request);
                return XmlWorkflowManager.processOutcome(c, user, workflow, currentStep, currentActionConfig, outcome, wi, false);
            }
            throw new AuthorizeException("You are not allowed to to perform this task.");
        }
        catch (WorkflowConfigurationException e) {
            log.error((Object)LogManager.getHeader(c, "error while executing state", "workflow:  " + workflow.getID() + " action: " + currentActionConfig.getId() + " workflowItemId: " + workflowItemId), (Throwable)e);
            WorkflowUtils.sendAlert(request, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowActionConfig processOutcome(Context c, EPerson user, Workflow workflow, Step currentStep, WorkflowActionConfig currentActionConfig, ActionResult currentOutcome, XmlWorkflowItem wfi, boolean enteredNewStep) throws IOException, WorkflowConfigurationException, AuthorizeException, SQLException, WorkflowException {
        if (currentOutcome.getType() == ActionResult.TYPE.TYPE_PAGE || currentOutcome.getType() == ActionResult.TYPE.TYPE_ERROR) {
            c.restoreAuthSystemState();
            return currentActionConfig;
        }
        if (currentOutcome.getType() == ActionResult.TYPE.TYPE_CANCEL || currentOutcome.getType() == ActionResult.TYPE.TYPE_SUBMISSION_PAGE) {
            c.restoreAuthSystemState();
            return null;
        }
        if (currentOutcome.getType() == ActionResult.TYPE.TYPE_OUTCOME) {
            Step nextStep = null;
            WorkflowActionConfig nextActionConfig = null;
            try {
                if (currentOutcome.getResult() == 0) {
                    nextActionConfig = currentStep.getNextAction(currentActionConfig);
                }
                if (nextActionConfig != null) {
                    nextStep = currentStep;
                    nextActionConfig.getProcessingAction().activate(c, wfi);
                    if (nextActionConfig.requiresUI() && !enteredNewStep) {
                        XmlWorkflowManager.createOwnedTask(c, wfi, currentStep, nextActionConfig, user);
                        WorkflowActionConfig workflowActionConfig = nextActionConfig;
                        return workflowActionConfig;
                    }
                    if (nextActionConfig.requiresUI() && enteredNewStep) {
                        c.restoreAuthSystemState();
                        WorkflowActionConfig workflowActionConfig = null;
                        return workflowActionConfig;
                    }
                    ActionResult newOutcome = nextActionConfig.getProcessingAction().execute(c, wfi, currentStep, null);
                    WorkflowActionConfig workflowActionConfig = XmlWorkflowManager.processOutcome(c, user, workflow, currentStep, nextActionConfig, newOutcome, wfi, enteredNewStep);
                    return workflowActionConfig;
                }
                if (enteredNewStep) {
                    nextStep = workflow.getNextStep(c, wfi, currentStep, currentOutcome.getResult());
                    c.turnOffAuthorisationSystem();
                    nextActionConfig = XmlWorkflowManager.processNextStep(c, user, workflow, currentOutcome, wfi, nextStep);
                    if (nextActionConfig == null || nextActionConfig.requiresUI()) {
                        WorkflowActionConfig newOutcome = null;
                        return newOutcome;
                    }
                    WorkflowActionConfig newOutcome = nextActionConfig;
                    return newOutcome;
                }
                ClaimedTask task = ClaimedTask.findByWorkflowIdAndEPerson(c, wfi.getID(), user.getID());
                WorkflowRequirementsManager.addFinishedUser(c, wfi, user);
                c.turnOffAuthorisationSystem();
                if (currentStep.isFinished(c, wfi) && currentOutcome.getResult() == 0 || currentOutcome.getResult() != 0) {
                    WorkflowRequirementsManager.clearInProgressUsers(c, wfi);
                    XmlWorkflowManager.deleteAllTasks(c, wfi);
                    nextStep = workflow.getNextStep(c, wfi, currentStep, currentOutcome.getResult());
                    nextActionConfig = XmlWorkflowManager.processNextStep(c, user, workflow, currentOutcome, wfi, nextStep);
                    if (nextActionConfig == null || nextActionConfig.requiresUI()) {
                        WorkflowActionConfig workflowActionConfig = null;
                        return workflowActionConfig;
                    }
                    WorkflowActionConfig workflowActionConfig = nextActionConfig;
                    return workflowActionConfig;
                }
                XmlWorkflowManager.deleteClaimedTask(c, wfi, task);
                c.restoreAuthSystemState();
                nextStep = currentStep;
                nextActionConfig = currentActionConfig;
                WorkflowActionConfig workflowActionConfig = null;
                return workflowActionConfig;
            }
            catch (Exception e) {
                log.error((Object)"error while processing workflow outcome", (Throwable)e);
                e.printStackTrace();
            }
            finally {
                if (nextStep != null && nextActionConfig != null || wfi.getItem().isArchived()) {
                    XmlWorkflowManager.logWorkflowEvent(c, currentStep.getWorkflow().getID(), currentStep.getId(), currentActionConfig.getId(), wfi, user, nextStep, nextActionConfig);
                }
            }
        }
        log.error((Object)LogManager.getHeader(c, "Invalid step outcome", "Workflow item id: " + wfi.getID()));
        throw new WorkflowException("Invalid step outcome");
    }

    protected static void logWorkflowEvent(Context c, String workflowId, String previousStepId, String previousActionConfigId, XmlWorkflowItem wfi, EPerson actor, Step newStep, WorkflowActionConfig newActionConfig) throws SQLException {
        try {
            Item item = wfi.getItem();
            Collection myCollection = wfi.getCollection();
            String workflowStepString = null;
            ArrayList<EPerson> currentEpersonOwners = new ArrayList<EPerson>();
            ArrayList<Group> currentGroupOwners = new ArrayList<Group>();
            if (newStep != null && newActionConfig != null) {
                workflowStepString = workflowId + "." + newStep.getId() + "." + newActionConfig.getId();
                List<ClaimedTask> claimedTasks = ClaimedTask.find(c, wfi.getID(), newStep.getId());
                List<PoolTask> pooledTasks = PoolTask.find(c, wfi);
                for (PoolTask poolTask : pooledTasks) {
                    if (poolTask.getEpersonID() != -1) {
                        currentEpersonOwners.add(EPerson.find(c, poolTask.getEpersonID()));
                        continue;
                    }
                    currentGroupOwners.add(Group.find(c, poolTask.getGroupID()));
                }
                for (ClaimedTask claimedTask : claimedTasks) {
                    currentEpersonOwners.add(EPerson.find(c, claimedTask.getOwnerID()));
                }
            }
            String previousWorkflowStepString = null;
            if (previousStepId != null && previousActionConfigId != null) {
                previousWorkflowStepString = workflowId + "." + previousStepId + "." + previousActionConfigId;
            }
            UsageWorkflowEvent usageWorkflowEvent = new UsageWorkflowEvent(c, item, wfi, workflowStepString, previousWorkflowStepString, myCollection, actor);
            usageWorkflowEvent.setEpersonOwners(currentEpersonOwners.toArray(new EPerson[currentEpersonOwners.size()]));
            usageWorkflowEvent.setGroupOwners(currentGroupOwners.toArray(new Group[currentGroupOwners.size()]));
            new DSpace().getEventService().fireEvent((Event)usageWorkflowEvent);
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(c, "Error while logging workflow event", "Workflow Item: " + wfi.getID()), (Throwable)e);
        }
    }

    private static WorkflowActionConfig processNextStep(Context c, EPerson user, Workflow workflow, ActionResult currentOutcome, XmlWorkflowItem wfi, Step nextStep) throws SQLException, IOException, AuthorizeException, WorkflowException, WorkflowConfigurationException {
        if (nextStep != null) {
            UserSelectionActionConfig nextActionConfig = nextStep.getUserSelectionMethod();
            ((WorkflowActionConfig)nextActionConfig).getProcessingAction().activate(c, wfi);
            if (nextActionConfig.requiresUI()) {
                c.restoreAuthSystemState();
                return nextActionConfig;
            }
            ActionResult newOutcome = ((WorkflowActionConfig)nextActionConfig).getProcessingAction().execute(c, wfi, nextStep, null);
            c.restoreAuthSystemState();
            return XmlWorkflowManager.processOutcome(c, user, workflow, nextStep, nextActionConfig, newOutcome, wfi, true);
        }
        if (currentOutcome.getResult() != 0) {
            c.restoreAuthSystemState();
            throw new WorkflowException("No alternate step was found for outcome: " + currentOutcome.getResult());
        }
        XmlWorkflowManager.archive(c, wfi);
        c.restoreAuthSystemState();
        return null;
    }

    public static Item archive(Context c, XmlWorkflowItem wfi) throws SQLException, IOException, AuthorizeException {
        WorkflowItemRole[] workflowItemRoles;
        Item item = wfi.getItem();
        Collection collection = wfi.getCollection();
        for (WorkflowItemRole workflowItemRole : workflowItemRoles = WorkflowItemRole.findAllForItem(c, wfi.getID())) {
            workflowItemRole.delete();
        }
        log.info((Object)LogManager.getHeader(c, "archive_item", "workflow_item_id=" + wfi.getID() + "item_id=" + item.getID() + "collection_id=" + collection.getID()));
        InstallItem.installItem(c, wfi);
        XmlWorkflowManager.notifyOfArchive(c, item, collection);
        item.clearMetadata("workflow", "*", "*", "*");
        item.update();
        log.info((Object)LogManager.getHeader(c, "install_item", "workflow_item_id=" + wfi.getID() + ", item_id=" + item.getID() + "handle=FIXME"));
        return item;
    }

    private static void notifyOfArchive(Context c, Item i, Collection coll) throws SQLException, IOException {
        try {
            EPerson ep = i.getSubmitter();
            Locale supportedLocale = I18nUtil.getEPersonLocale(ep);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_archive"));
            String handle = HandleManager.findHandle(c, i);
            Metadatum[] titles = i.getMetadata("dc", "title", null, "*");
            String title = "";
            try {
                title = I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled");
            }
            catch (MissingResourceException e) {
                title = "Untitled";
            }
            if (titles.length > 0) {
                title = titles[0].value;
            }
            email.addRecipient(ep.getEmail());
            email.addArgument(title);
            email.addArgument(coll.getMetadata("name"));
            email.addArgument(HandleManager.getCanonicalForm(handle));
            email.send();
        }
        catch (MessagingException e) {
            log.warn((Object)LogManager.getHeader(c, "notifyOfArchive", "cannot email user item_id=" + i.getID()));
        }
    }

    public static void deleteAllTasks(Context c, XmlWorkflowItem wi) throws SQLException, AuthorizeException {
        XmlWorkflowManager.deleteAllPooledTasks(c, wi);
        List<ClaimedTask> allClaimedTasks = ClaimedTask.findByWorkflowId(c, wi.getID());
        for (ClaimedTask task : allClaimedTasks) {
            XmlWorkflowManager.deleteClaimedTask(c, wi, task);
        }
    }

    public static void deleteAllPooledTasks(Context c, XmlWorkflowItem wi) throws SQLException, AuthorizeException {
        List<PoolTask> allPooledTasks = PoolTask.find(c, wi);
        for (PoolTask poolTask : allPooledTasks) {
            XmlWorkflowManager.deletePooledTask(c, wi, poolTask);
        }
    }

    public static void deletePooledTask(Context c, XmlWorkflowItem wi, PoolTask task) throws SQLException, AuthorizeException {
        if (task != null) {
            task.delete();
            if (task.getEpersonID() > 0) {
                XmlWorkflowManager.removeUserItemPolicies(c, wi.getItem(), EPerson.find(c, task.getEpersonID()));
            } else {
                XmlWorkflowManager.removeGroupItemPolicies(c, wi.getItem(), Group.find(c, task.getGroupID()));
            }
        }
    }

    public static void deleteClaimedTask(Context c, XmlWorkflowItem wi, ClaimedTask task) throws SQLException, AuthorizeException {
        if (task != null) {
            task.delete();
            XmlWorkflowManager.removeUserItemPolicies(c, wi.getItem(), EPerson.find(c, task.getOwnerID()));
        }
    }

    public static void createPoolTasks(Context context, XmlWorkflowItem wi, RoleMembers assignees, Step step, WorkflowActionConfig action) throws SQLException, AuthorizeException {
        PoolTask task;
        for (EPerson anEpa : assignees.getEPersons()) {
            task = PoolTask.create(context);
            task.setStepID(step.getId());
            task.setWorkflowID(step.getWorkflow().getID());
            task.setEpersonID(anEpa.getID());
            task.setActionID(action.getId());
            task.setWorkflowItemID(wi.getID());
            task.update();
            XmlWorkflowManager.grantUserAllItemPolicies(context, wi.getItem(), anEpa);
        }
        for (Group group : assignees.getGroups()) {
            task = PoolTask.create(context);
            task.setStepID(step.getId());
            task.setWorkflowID(step.getWorkflow().getID());
            task.setGroupID(group.getID());
            task.setActionID(action.getId());
            task.setWorkflowItemID(wi.getID());
            task.update();
            XmlWorkflowManager.grantGroupAllItemPolicies(context, wi.getItem(), group);
        }
    }

    public static void createOwnedTask(Context c, XmlWorkflowItem wi, Step step, WorkflowActionConfig action, EPerson e) throws SQLException, AuthorizeException {
        ClaimedTask task = ClaimedTask.create(c);
        task.setWorkflowItemID(wi.getID());
        task.setStepID(step.getId());
        task.setActionID(action.getId());
        task.setOwnerID(e.getID());
        task.setWorkflowID(step.getWorkflow().getID());
        task.update();
        XmlWorkflowManager.grantUserAllItemPolicies(c, wi.getItem(), e);
    }

    private static void grantUserAllItemPolicies(Context context, Item item, EPerson epa) throws AuthorizeException, SQLException {
        if (epa != null) {
            ArrayList<Integer> userHasPolicies = new ArrayList<Integer>();
            List<ResourcePolicy> itempols = AuthorizeManager.getPolicies(context, item);
            for (ResourcePolicy resourcePolicy : itempols) {
                if (resourcePolicy.getEPersonID() != epa.getID()) continue;
                userHasPolicies.add(resourcePolicy.getAction());
            }
            if (!userHasPolicies.contains(0)) {
                XmlWorkflowManager.addPolicyToItem(context, item, 0, epa);
            }
            if (!userHasPolicies.contains(1)) {
                XmlWorkflowManager.addPolicyToItem(context, item, 1, epa);
            }
            if (!userHasPolicies.contains(2)) {
                XmlWorkflowManager.addPolicyToItem(context, item, 2, epa);
            }
            if (!userHasPolicies.contains(3)) {
                XmlWorkflowManager.addPolicyToItem(context, item, 3, epa);
            }
            if (!userHasPolicies.contains(4)) {
                XmlWorkflowManager.addPolicyToItem(context, item, 4, epa);
            }
        }
    }

    private static void grantGroupAllItemPolicies(Context context, Item item, Group group) throws AuthorizeException, SQLException {
        if (group != null) {
            ArrayList<Integer> groupHasPolicies = new ArrayList<Integer>();
            List<ResourcePolicy> itempols = AuthorizeManager.getPolicies(context, item);
            for (ResourcePolicy resourcePolicy : itempols) {
                if (resourcePolicy.getGroupID() != group.getID()) continue;
                groupHasPolicies.add(resourcePolicy.getAction());
            }
            if (!groupHasPolicies.contains(0)) {
                XmlWorkflowManager.addGroupPolicyToItem(context, item, 0, group);
            }
            if (!groupHasPolicies.contains(1)) {
                XmlWorkflowManager.addGroupPolicyToItem(context, item, 1, group);
            }
            if (!groupHasPolicies.contains(2)) {
                XmlWorkflowManager.addGroupPolicyToItem(context, item, 2, group);
            }
            if (!groupHasPolicies.contains(3)) {
                XmlWorkflowManager.addGroupPolicyToItem(context, item, 3, group);
            }
            if (!groupHasPolicies.contains(4)) {
                XmlWorkflowManager.addGroupPolicyToItem(context, item, 4, group);
            }
        }
    }

    private static void addPolicyToItem(Context context, Item item, int type, EPerson epa) throws AuthorizeException, SQLException {
        if (epa != null) {
            Bundle[] bundles;
            AuthorizeManager.addPolicy(context, (DSpaceObject)item, type, epa);
            for (Bundle bundle : bundles = item.getBundles()) {
                Bitstream[] bits;
                AuthorizeManager.addPolicy(context, (DSpaceObject)bundle, type, epa);
                for (Bitstream bit : bits = bundle.getBitstreams()) {
                    AuthorizeManager.addPolicy(context, (DSpaceObject)bit, type, epa);
                }
            }
        }
    }

    private static void addGroupPolicyToItem(Context context, Item item, int type, Group group) throws AuthorizeException, SQLException {
        if (group != null) {
            Bundle[] bundles;
            AuthorizeManager.addPolicy(context, (DSpaceObject)item, type, group);
            for (Bundle bundle : bundles = item.getBundles()) {
                Bitstream[] bits;
                AuthorizeManager.addPolicy(context, (DSpaceObject)bundle, type, group);
                for (Bitstream bit : bits = bundle.getBitstreams()) {
                    AuthorizeManager.addPolicy(context, (DSpaceObject)bit, type, group);
                }
            }
        }
    }

    private static void removeUserItemPolicies(Context context, Item item, EPerson e) throws SQLException, AuthorizeException {
        if (e != null) {
            Bundle[] bundles;
            AuthorizeManager.removeEPersonPolicies(context, item, e);
            for (Bundle bundle : bundles = item.getBundles()) {
                Bitstream[] bitstreams;
                AuthorizeManager.removeEPersonPolicies(context, bundle, e);
                for (Bitstream bitstream : bitstreams = bundle.getBitstreams()) {
                    AuthorizeManager.removeEPersonPolicies(context, bitstream, e);
                }
            }
            if (e.getID() == item.getSubmitter().getID()) {
                XmlWorkflowManager.grantSubmitterReadPolicies(context, item);
            }
        }
    }

    private static void removeGroupItemPolicies(Context context, Item item, Group e) throws SQLException, AuthorizeException {
        if (e != null) {
            Bundle[] bundles;
            AuthorizeManager.removeGroupPolicies(context, item, e);
            for (Bundle bundle : bundles = item.getBundles()) {
                Bitstream[] bitstreams;
                AuthorizeManager.removeGroupPolicies(context, bundle, e);
                for (Bitstream bitstream : bitstreams = bundle.getBitstreams()) {
                    AuthorizeManager.removeGroupPolicies(context, bitstream, e);
                }
            }
        }
    }

    public static WorkspaceItem sendWorkflowItemBackSubmission(Context c, XmlWorkflowItem wi, EPerson e, String provenance, String rejection_message) throws SQLException, AuthorizeException, IOException {
        WorkflowItemRole[] workflowItemRoles;
        String workflowID = null;
        String currentStepId = null;
        String currentActionConfigId = null;
        ClaimedTask claimedTask = ClaimedTask.findByWorkflowIdAndEPerson(c, wi.getID(), e.getID());
        if (claimedTask != null) {
            workflowID = claimedTask.getWorkflowID();
            currentStepId = claimedTask.getStepID();
            currentActionConfigId = claimedTask.getActionID();
        }
        XmlWorkflowManager.deleteAllTasks(c, wi);
        c.turnOffAuthorisationSystem();
        WorkflowRequirementsManager.clearInProgressUsers(c, wi);
        for (WorkflowItemRole workflowItemRole : workflowItemRoles = WorkflowItemRole.findAllForItem(c, wi.getID())) {
            workflowItemRole.delete();
        }
        Item myitem = wi.getItem();
        String now = DCDate.getCurrent().toString();
        String usersName = XmlWorkflowManager.getEPersonName(e);
        String provDescription = provenance + " Rejected by " + usersName + ", reason: " + rejection_message + " on " + now + " (GMT) ";
        myitem.addMetadata("dc", "description", "provenance", "en", provDescription);
        myitem.clearMetadata("workflow", "*", "*", "*");
        myitem.update();
        XmlWorkflowManager.grantUserAllItemPolicies(c, myitem, myitem.getSubmitter());
        WorkspaceItem wsi = XmlWorkflowManager.returnToWorkspace(c, wi);
        XmlWorkflowManager.notifyOfReject(c, wi, e, rejection_message);
        log.info((Object)LogManager.getHeader(c, "reject_workflow", "workflow_item_id=" + wi.getID() + "item_id=" + wi.getItem().getID() + "collection_id=" + wi.getCollection().getID() + "eperson_id=" + e.getID()));
        XmlWorkflowManager.logWorkflowEvent(c, workflowID, currentStepId, currentActionConfigId, wi, e, null, null);
        c.restoreAuthSystemState();
        return wsi;
    }

    public static WorkspaceItem abort(Context c, XmlWorkflowItem wi, EPerson e) throws AuthorizeException, SQLException, IOException {
        WorkflowItemRole[] workflowItemRoles;
        if (!AuthorizeManager.isAdmin(c)) {
            throw new AuthorizeException("You must be an admin to abort a workflow");
        }
        XmlWorkflowManager.deleteAllTasks(c, wi);
        c.turnOffAuthorisationSystem();
        WorkflowRequirementsManager.clearInProgressUsers(c, wi);
        for (WorkflowItemRole workflowItemRole : workflowItemRoles = WorkflowItemRole.findAllForItem(c, wi.getID())) {
            workflowItemRole.delete();
        }
        Item item = wi.getItem();
        XmlWorkflowManager.grantUserAllItemPolicies(c, item, item.getSubmitter());
        WorkspaceItem wsi = XmlWorkflowManager.returnToWorkspace(c, wi);
        log.info((Object)LogManager.getHeader(c, "abort_workflow", "workflow_item_id=" + wi.getID() + "item_id=" + item.getID() + "collection_id=" + wi.getCollection().getID() + "eperson_id=" + e.getID()));
        c.restoreAuthSystemState();
        return wsi;
    }

    private static WorkspaceItem returnToWorkspace(Context c, XmlWorkflowItem wfi) throws SQLException, IOException, AuthorizeException {
        Item myitem = wfi.getItem();
        Collection myCollection = wfi.getCollection();
        TableRow row = DatabaseManager.create(c, "workspaceitem");
        row.setColumn("item_id", myitem.getID());
        row.setColumn("collection_id", myCollection.getID());
        DatabaseManager.update(c, row);
        int wsi_id = row.getIntColumn("workspace_item_id");
        WorkspaceItem wi = WorkspaceItem.find(c, wsi_id);
        wi.setMultipleFiles(wfi.hasMultipleFiles());
        wi.setMultipleTitles(wfi.hasMultipleTitles());
        wi.setPublishedBefore(wfi.isPublishedBefore());
        wi.update();
        log.info((Object)LogManager.getHeader(c, "return_to_workspace", "workflow_item_id=" + wfi.getID() + "workspace_item_id=" + wi.getID()));
        DatabaseManager.updateQuery(c, "DELETE FROM cwf_workflowitem WHERE workflowitem_id=" + wfi.getID(), new Object[0]);
        return wi;
    }

    public static String getEPersonName(EPerson e) throws SQLException {
        String submitter = e.getFullName();
        submitter = submitter + "(" + e.getEmail() + ")";
        return submitter;
    }

    private static void recordStart(Item myitem, Action action) throws SQLException, IOException, AuthorizeException {
        DCDate now = DCDate.getCurrent();
        String provmessage = "";
        provmessage = myitem.getSubmitter() != null ? "Submitted by " + myitem.getSubmitter().getFullName() + " (" + myitem.getSubmitter().getEmail() + ") on " + now.toString() + " workflow start=" + action.getProvenanceStartId() + "\n" : "Submitted by unknown (probably automated) on" + now.toString() + " workflow start=" + action.getProvenanceStartId() + "\n";
        provmessage = provmessage + InstallItem.getBitstreamProvenanceMessage(myitem);
        myitem.addMetadata("dc", "description", "provenance", "en", provmessage);
        myitem.update();
    }

    private static void notifyOfReject(Context c, XmlWorkflowItem wi, EPerson e, String reason) {
        try {
            String title = wi.getItem().getName();
            Collection coll = wi.getCollection();
            String rejector = XmlWorkflowManager.getEPersonName(e);
            Locale supportedLocale = I18nUtil.getEPersonLocale(e);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_reject"));
            email.addRecipient(wi.getSubmitter().getEmail());
            email.addArgument(title);
            email.addArgument(coll.getMetadata("name"));
            email.addArgument(rejector);
            email.addArgument(reason);
            email.addArgument(ConfigurationManager.getProperty("dspace.url") + "/mydspace");
            email.send();
        }
        catch (Exception ex) {
            log.warn((Object)LogManager.getHeader(c, "notify_of_reject", "cannot email user eperson_id" + e.getID() + " eperson_email" + e.getEmail() + " workflow_item_id" + wi.getID()));
        }
    }

    public static String getMyDSpaceLink() {
        return ConfigurationManager.getProperty("dspace.url") + "/mydspace";
    }
}

