/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.util.ArrayList;
import java.util.List;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;

public class BulkEditChange {
    private Item item;
    private List<Metadatum> adds;
    private List<Metadatum> removes;
    private List<Metadatum> constant;
    private List<Metadatum> complete;
    private List<Collection> oldMappedCollections;
    private List<Collection> newMappedCollections;
    private Collection oldOwningCollection;
    private Collection newOwningCollection;
    private boolean newItem;
    private boolean deleted;
    private boolean withdrawn;
    private boolean reinstated;
    private boolean empty;

    public BulkEditChange() {
        this.item = null;
        this.newItem = true;
        this.empty = true;
        this.oldOwningCollection = null;
        this.newOwningCollection = null;
        this.adds = new ArrayList<Metadatum>();
        this.removes = new ArrayList<Metadatum>();
        this.constant = new ArrayList<Metadatum>();
        this.complete = new ArrayList<Metadatum>();
        this.oldMappedCollections = new ArrayList<Collection>();
        this.newMappedCollections = new ArrayList<Collection>();
    }

    public BulkEditChange(Item i) {
        this.item = i;
        this.newItem = false;
        this.empty = true;
        this.adds = new ArrayList<Metadatum>();
        this.removes = new ArrayList<Metadatum>();
        this.constant = new ArrayList<Metadatum>();
        this.complete = new ArrayList<Metadatum>();
        this.oldMappedCollections = new ArrayList<Collection>();
        this.newMappedCollections = new ArrayList<Collection>();
    }

    public void setItem(Item i) {
        this.item = i;
    }

    public void registerAdd(Metadatum dcv) {
        this.adds.add(dcv);
        this.complete.add(dcv);
        this.empty = false;
    }

    public void registerRemove(Metadatum dcv) {
        this.removes.add(dcv);
        this.empty = false;
    }

    public void registerConstant(Metadatum dcv) {
        this.constant.add(dcv);
        this.complete.add(dcv);
    }

    public void registerNewMappedCollection(Collection c) {
        this.newMappedCollections.add(c);
        this.empty = false;
    }

    public void registerOldMappedCollection(Collection c) {
        boolean found = false;
        if (this.getOldOwningCollection() != null && this.getOldOwningCollection().getHandle().equals(c.getHandle())) {
            found = true;
        }
        for (Collection collection : this.oldMappedCollections) {
            if (!collection.getHandle().equals(c.getHandle())) continue;
            found = true;
        }
        if (!found) {
            this.oldMappedCollections.add(c);
            this.empty = false;
        }
    }

    public void changeOwningCollection(Collection oldC, Collection newC) {
        this.oldOwningCollection = oldC;
        this.newOwningCollection = newC;
        this.empty = false;
    }

    public void setOwningCollection(Collection newC) {
        this.newOwningCollection = newC;
    }

    public Item getItem() {
        return this.item;
    }

    public List<Metadatum> getAdds() {
        return this.adds;
    }

    public List<Metadatum> getRemoves() {
        return this.removes;
    }

    public List<Metadatum> getConstant() {
        return this.constant;
    }

    public List<Metadatum> getComplete() {
        return this.complete;
    }

    public List<Collection> getNewMappedCollections() {
        return this.newMappedCollections;
    }

    public List<Collection> getOldMappedCollections() {
        return this.oldMappedCollections;
    }

    public Collection getOldOwningCollection() {
        return this.oldOwningCollection;
    }

    public Collection getNewOwningCollection() {
        return this.newOwningCollection;
    }

    public boolean isNewItem() {
        return this.newItem;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted() {
        this.deleted = true;
        this.empty = false;
    }

    public boolean isWithdrawn() {
        return this.withdrawn;
    }

    public void setWithdrawn() {
        this.withdrawn = true;
        this.empty = false;
    }

    public boolean isReinstated() {
        return this.reinstated;
    }

    public void setReinstated() {
        this.reinstated = true;
        this.empty = false;
    }

    public boolean hasChanges() {
        return !this.empty;
    }
}

