/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa;

import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;
import org.dspace.app.sherpa.SHERPAResponse;
import org.dspace.core.ConfigurationManager;

public class SHERPAService {
    private CloseableHttpClient client = null;
    private int maxNumberOfTries;
    private long sleepBetweenTimeouts;
    private int timeout;
    private static final Logger log = Logger.getLogger(SHERPAService.class);

    public SHERPAService() {
        HttpClientBuilder custom = HttpClients.custom();
        this.client = custom.disableAutomaticRetries().setMaxConnTotal(5).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.timeout).build()).build();
    }

    public SHERPAResponse searchByJournalISSN(String query) {
        String endpoint = ConfigurationManager.getProperty("sherpa.romeo.url");
        String apiKey = ConfigurationManager.getProperty("sherpa.romeo.apikey");
        HttpGet method = null;
        SHERPAResponse sherpaResponse = null;
        int numberOfTries = 0;
        while (numberOfTries < this.maxNumberOfTries && sherpaResponse == null) {
            ++numberOfTries;
            try {
                HttpEntity responseBody;
                CloseableHttpResponse response;
                int statusCode;
                Thread.sleep(this.sleepBetweenTimeouts * (long)(numberOfTries - 1));
                URIBuilder uriBuilder = new URIBuilder(endpoint);
                uriBuilder.addParameter("issn", query);
                uriBuilder.addParameter("versions", "all");
                if (StringUtils.isNotBlank((String)apiKey)) {
                    uriBuilder.addParameter("ak", apiKey);
                }
                if ((statusCode = (response = this.client.execute((HttpUriRequest)(method = new HttpGet(uriBuilder.build())))).getStatusLine().getStatusCode()) != 200) {
                    sherpaResponse = new SHERPAResponse("SHERPA/RoMEO return not OK status: " + statusCode);
                }
                if (null != (responseBody = response.getEntity())) {
                    sherpaResponse = new SHERPAResponse(responseBody.getContent());
                    continue;
                }
                sherpaResponse = new SHERPAResponse("SHERPA/RoMEO returned no response");
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (sherpaResponse == null) {
            sherpaResponse = new SHERPAResponse("Error processing the SHERPA/RoMEO answer");
        }
        return sherpaResponse;
    }

    public void setMaxNumberOfTries(int maxNumberOfTries) {
        this.maxNumberOfTries = maxNumberOfTries;
    }

    public void setSleepBetweenTimeouts(long sleepBetweenTimeouts) {
        this.sleepBetweenTimeouts = sleepBetweenTimeouts;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

