/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.orcid;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.SolrAuthorityInterface;
import org.dspace.authority.orcid.Orcidv2AuthorityValue;
import org.dspace.authority.orcid.xml.XMLtoBio;
import org.dspace.authority.rest.RESTConnector;
import org.json.JSONObject;
import org.orcid.jaxb.model.record_v2.Person;

public class Orcidv2
implements SolrAuthorityInterface {
    private static Logger log = Logger.getLogger(Orcidv2.class);
    public RESTConnector restConnector;
    private String OAUTHUrl;
    private String clientId;
    private String clientSecret;
    private String accessToken;

    public void init() throws IOException {
        if (StringUtils.isNotBlank((String)this.accessToken) && StringUtils.isNotBlank((String)this.clientSecret)) {
            String inputStr;
            String authenticationParameters = "?client_id=" + this.clientId + "&client_secret=" + this.clientSecret + "&scope=/read-public&grant_type=client_credentials";
            HttpPost httpPost = new HttpPost(this.OAUTHUrl + authenticationParameters);
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse getResponse = httpClient.execute((HttpUriRequest)httpPost);
            InputStream is = getResponse.getEntity().getContent();
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            JSONObject responseObject = null;
            while ((inputStr = streamReader.readLine()) != null && responseObject == null) {
                if (!inputStr.startsWith("{") || !inputStr.endsWith("}") || !inputStr.contains("access_token")) continue;
                try {
                    responseObject = new JSONObject(inputStr);
                }
                catch (Exception e) {
                    responseObject = null;
                }
            }
            if (responseObject != null && responseObject.has("access_token")) {
                this.accessToken = (String)responseObject.get("access_token");
            }
        }
    }

    private Orcidv2(String url, String OAUTHUrl, String clientId, String clientSecret) {
        this.restConnector = new RESTConnector(url);
        this.OAUTHUrl = OAUTHUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    private Orcidv2(String url) {
        this.restConnector = new RESTConnector(url);
    }

    @Override
    public List<AuthorityValue> queryAuthorities(String text, int max) {
        List<Person> bios = this.queryBio(text, max);
        ArrayList<AuthorityValue> result = new ArrayList<AuthorityValue>();
        for (Person person : bios) {
            Orcidv2AuthorityValue orcidAuthorityValue = Orcidv2AuthorityValue.create(person);
            if (orcidAuthorityValue == null) continue;
            result.add(orcidAuthorityValue);
        }
        return result;
    }

    @Override
    public AuthorityValue queryAuthorityID(String id) {
        Person person = this.getBio(id);
        Orcidv2AuthorityValue valueFromPerson = Orcidv2AuthorityValue.create(person);
        return valueFromPerson;
    }

    public Person getBio(String id) {
        log.debug((Object)("getBio called with ID=" + id));
        if (!this.isValid(id)) {
            return null;
        }
        InputStream bioDocument = this.restConnector.get(id + (id.endsWith("/person") ? "" : "/person"), this.accessToken);
        XMLtoBio converter = new XMLtoBio();
        Person person = converter.convertSinglePerson(bioDocument);
        return person;
    }

    public List<Person> queryBio(String text, int start, int rows) {
        if (rows > 100) {
            throw new IllegalArgumentException("The maximum number of results to retrieve cannot exceed 100.");
        }
        String searchPath = "search?q=" + URLEncoder.encode(text) + "&start=" + start + "&rows=" + rows;
        log.debug((Object)("queryBio searchPath=" + searchPath + " accessToken=" + this.accessToken));
        InputStream bioDocument = this.restConnector.get(searchPath, this.accessToken);
        XMLtoBio converter = new XMLtoBio();
        Object bios = converter.convert(bioDocument);
        return bios;
    }

    public List<Person> queryBio(String text, int max) {
        return this.queryBio(text, 0, max);
    }

    private boolean isValid(String text) {
        return StringUtils.isNotBlank((String)text) && text.matches("\\d{4}-\\d{4}-\\d{4}-(\\d{3}X|\\d{4})");
    }
}

