/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.orcid;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.PersonAuthorityValue;
import org.dspace.authority.orcid.Orcidv2;
import org.dspace.utils.DSpace;
import org.orcid.jaxb.model.common_v2.ExternalId;
import org.orcid.jaxb.model.record_v2.ExternalIdentifiers;
import org.orcid.jaxb.model.record_v2.KeywordType;
import org.orcid.jaxb.model.record_v2.NameType;
import org.orcid.jaxb.model.record_v2.Person;
import org.orcid.jaxb.model.record_v2.ResearcherUrlType;

public class Orcidv2AuthorityValue
extends PersonAuthorityValue {
    private String orcid_id;
    private Map<String, List<String>> otherMetadata = new HashMap<String, List<String>>();
    public static final String ORCID_ID_SYNTAX = "\\d{4}-\\d{4}-\\d{4}-(\\d{3}X|\\d{4})";

    public Orcidv2AuthorityValue() {
    }

    public Orcidv2AuthorityValue(SolrDocument document) {
        super(document);
    }

    public String getOrcid_id() {
        return this.orcid_id;
    }

    public void setOrcid_id(String orcid_id) {
        this.orcid_id = orcid_id;
    }

    public static Orcidv2AuthorityValue create() {
        Orcidv2AuthorityValue orcidAuthorityValue = new Orcidv2AuthorityValue();
        orcidAuthorityValue.setId(UUID.randomUUID().toString());
        orcidAuthorityValue.updateLastModifiedDate();
        orcidAuthorityValue.setCreationDate(new Date());
        return orcidAuthorityValue;
    }

    public static Orcidv2AuthorityValue create(Person person) {
        if (person == null) {
            return null;
        }
        Orcidv2AuthorityValue authority = Orcidv2AuthorityValue.create();
        authority.setValues(person);
        return authority;
    }

    protected void setValues(Person person) {
        ExternalIdentifiers externalIdentifiers;
        NameType name = person.getName();
        if (!StringUtils.equals((String)name.getPath(), (String)this.getOrcid_id())) {
            this.setOrcid_id(name.getPath());
        }
        if (!StringUtils.equals((String)name.getFamilyName().getValue(), (String)this.getLastName())) {
            this.setLastName(name.getFamilyName().getValue());
        }
        if (!StringUtils.equals((String)name.getGivenNames().getValue(), (String)this.getFirstName())) {
            this.setFirstName(name.getGivenNames().getValue());
        }
        if (name.getCreditName() != null && StringUtils.isNotBlank((String)name.getCreditName().getValue()) && !this.getNameVariants().contains(name.getCreditName())) {
            this.addNameVariant(name.getCreditName().getValue());
        }
        if (person.getKeywords() != null) {
            for (KeywordType keyword : person.getKeywords().getKeyword()) {
                if (!this.isNewMetadata("keyword", keyword.getContent())) continue;
                this.addOtherMetadata("keyword", keyword.getContent());
            }
        }
        if ((externalIdentifiers = person.getExternalIdentifiers()) != null) {
            for (ExternalId externalIdentifier : externalIdentifiers.getExternalIdentifier()) {
                if (!this.isNewMetadata("external_identifier", externalIdentifier.getExternalIdValue())) continue;
                this.addOtherMetadata("external_identifier", externalIdentifier.getExternalIdValue());
            }
        }
        if (person.getResearcherUrls() != null) {
            for (ResearcherUrlType researcherUrl : person.getResearcherUrls().getResearcherUrl()) {
                if (!this.isNewMetadata("researcher_url", researcherUrl.getUrl().getValue())) continue;
                this.addOtherMetadata("researcher_url", researcherUrl.getUrl().getValue());
            }
        }
        if (person.getBiography() != null && this.isNewMetadata("biography", person.getBiography().getContent())) {
            this.addOtherMetadata("biography", person.getBiography().getContent());
        }
        this.setValue(this.getName());
    }

    @Override
    public AuthorityValue newInstance(String info) {
        AuthorityValue authorityValue = null;
        if (StringUtils.isNotBlank((String)info)) {
            Orcidv2 orcid = (Orcidv2)new DSpace().getServiceManager().getServiceByName("AuthoritySource", Orcidv2.class);
            authorityValue = orcid.queryAuthorityID(info);
        } else {
            authorityValue = this.create();
        }
        return authorityValue;
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
    }

    public boolean isNewMetadata(String label, String data) {
        List<String> strings = this.getOtherMetadata().get(label);
        boolean update = strings == null ? StringUtils.isNotBlank((String)data) : !strings.contains(data);
        return update;
    }

    public void addOtherMetadata(String label, String data) {
        List<String> strings = this.otherMetadata.get(label);
        if (strings == null) {
            strings = new ArrayList<String>();
        }
        strings.add(data);
        this.otherMetadata.put(label, strings);
    }

    public Map<String, List<String>> getOtherMetadata() {
        return this.otherMetadata;
    }

    @Override
    public SolrInputDocument getSolrInputDocument() {
        SolrInputDocument doc = super.getSolrInputDocument();
        if (StringUtils.isNotBlank((String)this.getOrcid_id())) {
            doc.addField("orcid_id", (Object)this.getOrcid_id());
        }
        for (String t : this.otherMetadata.keySet()) {
            List<String> data = this.otherMetadata.get(t);
            for (String data_entry : data) {
                doc.addField("label_" + t, (Object)data_entry);
            }
        }
        return doc;
    }

    @Override
    public Map<String, String> choiceSelectMap() {
        Map<String, String> map = super.choiceSelectMap();
        String orcid_id = this.getOrcid_id();
        if (StringUtils.isNotBlank((String)orcid_id)) {
            map.put("orcid", orcid_id);
        }
        return map;
    }

    @Override
    public String getAuthorityType() {
        return "orcid";
    }

    @Override
    public String generateString() {
        String generateString = "will be generated::" + this.getAuthorityType() + "::";
        if (StringUtils.isNotBlank((String)this.getOrcid_id())) {
            generateString = generateString + this.getOrcid_id();
        }
        return generateString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Orcidv2AuthorityValue that = (Orcidv2AuthorityValue)o;
        return !(this.orcid_id != null ? !this.orcid_id.equals(that.orcid_id) : that.orcid_id != null);
    }

    public int hashCode() {
        return this.orcid_id != null ? this.orcid_id.hashCode() : 0;
    }

    @Override
    public boolean hasTheSameInformationAs(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.hasTheSameInformationAs(o)) {
            return false;
        }
        Orcidv2AuthorityValue that = (Orcidv2AuthorityValue)o;
        if (this.orcid_id != null ? !this.orcid_id.equals(that.orcid_id) : that.orcid_id != null) {
            return false;
        }
        for (String key : this.otherMetadata.keySet()) {
            if (this.otherMetadata.get(key) != null) {
                List<String> metadata = this.otherMetadata.get(key);
                List<String> otherMetadata = that.otherMetadata.get(key);
                if (otherMetadata == null) {
                    return false;
                }
                HashSet<String> metadataSet = new HashSet<String>(metadata);
                HashSet<String> otherMetadataSet = new HashSet<String>(otherMetadata);
                if (metadataSet.equals(otherMetadataSet)) continue;
                return false;
            }
            if (that.otherMetadata.get(key) == null) continue;
            return false;
        }
        return true;
    }
}

