/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.event.Event;
import org.dspace.storage.bitstore.BitstreamStorageManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Bitstream
extends DSpaceObject {
    private static final Logger log = Logger.getLogger(Bitstream.class);
    private final TableRow bRow;
    private BitstreamFormat bitstreamFormat;
    private boolean modified;

    Bitstream(Context context, TableRow row) throws SQLException {
        super(context);
        if (null == row.getTable()) {
            row.setTable("bitstream");
        }
        this.bRow = row;
        this.bitstreamFormat = BitstreamFormat.find(context, row.getIntColumn("bitstream_format_id"));
        if (this.bitstreamFormat == null) {
            this.bitstreamFormat = BitstreamFormat.findUnknown(context);
            if (this.bitstreamFormat == null) {
                throw new IllegalStateException("No Unknown bitstream format");
            }
        }
        context.cache(this, row.getIntColumn("bitstream_id"));
        this.modified = false;
        this.clearDetails();
    }

    public static Bitstream find(Context context, int id) throws SQLException {
        Bitstream fromCache = (Bitstream)context.fromCache(Bitstream.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "bitstream", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_bitstream", "not_found,bitstream_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_bitstream", "bitstream_id=" + id));
        }
        return new Bitstream(context, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitstream[] findAll(Context context) throws SQLException {
        ArrayList<Bitstream> bitstreams = new ArrayList<Bitstream>();
        try (TableRowIterator tri = DatabaseManager.queryTable(context, "bitstream", "SELECT * FROM bitstream", new Object[0]);){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                Bitstream fromCache = (Bitstream)context.fromCache(Bitstream.class, row.getIntColumn("bitstream_id"));
                if (fromCache != null) {
                    bitstreams.add(fromCache);
                    continue;
                }
                bitstreams.add(new Bitstream(context, row));
            }
        }
        Bitstream[] bitstreamArray = new Bitstream[bitstreams.size()];
        bitstreamArray = bitstreams.toArray(bitstreamArray);
        return bitstreamArray;
    }

    static Bitstream create(Context context, InputStream is) throws IOException, SQLException {
        int bitstreamID = BitstreamStorageManager.store(context, is);
        log.info((Object)LogManager.getHeader(context, "create_bitstream", "bitstream_id=" + bitstreamID));
        Bitstream bitstream = Bitstream.find(context, bitstreamID);
        bitstream.setFormat(null);
        context.addEvent(new Event(1, 0, bitstreamID, null, bitstream.getIdentifiers(context)));
        return bitstream;
    }

    static Bitstream register(Context context, int assetstore, String bitstreamPath) throws IOException, SQLException {
        int bitstreamID = BitstreamStorageManager.register(context, assetstore, bitstreamPath);
        log.info((Object)LogManager.getHeader(context, "create_bitstream", "bitstream_id=" + bitstreamID));
        Bitstream bitstream = Bitstream.find(context, bitstreamID);
        bitstream.setFormat(null);
        context.addEvent(new Event(1, 0, bitstreamID, "REGISTER", bitstream.getIdentifiers(context)));
        return bitstream;
    }

    @Override
    public int getID() {
        return this.bRow.getIntColumn("bitstream_id");
    }

    @Override
    public String getHandle() {
        return null;
    }

    public int getSequenceID() {
        return this.bRow.getIntColumn("sequence_id");
    }

    public void setSequenceID(int sid) {
        this.bRow.setColumn("sequence_id", sid);
        this.modifiedMetadata = true;
        this.addDetails("SequenceID");
    }

    @Override
    public String getName() {
        return this.getMetadataFirstValue("dc", "title", null, "*");
    }

    public void setName(String n) {
        this.setMetadataSingleValue("dc", "title", null, null, n);
    }

    public String getSource() {
        return this.getMetadataFirstValue("dc", "source", null, "*");
    }

    public void setSource(String n) {
        this.setMetadataSingleValue("dc", "source", null, null, n);
    }

    public String getDescription() {
        return this.getMetadataFirstValue("dc", "description", null, "*");
    }

    public void setDescription(String n) {
        this.setMetadataSingleValue("dc", "description", null, null, n);
    }

    public String getChecksum() {
        return this.bRow.getStringColumn("checksum");
    }

    public String getChecksumAlgorithm() {
        return this.bRow.getStringColumn("checksum_algorithm");
    }

    public long getSize() {
        return this.bRow.getLongColumn("size_bytes");
    }

    public void setUserFormatDescription(String desc) throws SQLException {
        this.setFormat(null);
        this.setMetadataSingleValue("dc", "format", null, null, desc);
    }

    public String getUserFormatDescription() {
        return this.getMetadataFirstValue("dc", "format", null, "*");
    }

    public String getFormatDescription() {
        if (this.bitstreamFormat.getShortDescription().equals("Unknown")) {
            String desc = this.getUserFormatDescription();
            if (desc == null) {
                return "Unknown";
            }
            return desc;
        }
        return this.bitstreamFormat.getShortDescription();
    }

    public BitstreamFormat getFormat() {
        return this.bitstreamFormat;
    }

    public void setFormat(BitstreamFormat f) throws SQLException {
        this.bitstreamFormat = f == null ? BitstreamFormat.findUnknown(this.ourContext) : f;
        this.clearMetadata("dc", "format", null, "*");
        this.bRow.setColumn("bitstream_format_id", this.bitstreamFormat.getID());
        this.modified = true;
    }

    @Override
    public void update() throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 1);
        log.info((Object)LogManager.getHeader(this.ourContext, "update_bitstream", "bitstream_id=" + this.getID()));
        DatabaseManager.update(this.ourContext, this.bRow);
        if (this.modified) {
            this.ourContext.addEvent(new Event(2, 0, this.getID(), null, this.getIdentifiers(this.ourContext)));
            this.modified = false;
        }
        if (this.modifiedMetadata) {
            this.updateMetadata();
            this.clearDetails();
        }
    }

    void delete() throws SQLException {
        boolean oracle = DatabaseManager.isOracle();
        log.info((Object)LogManager.getHeader(this.ourContext, "delete_bitstream", "bitstream_id=" + this.getID()));
        this.ourContext.addEvent(new Event(32, 0, this.getID(), String.valueOf(this.getSequenceID()), this.getIdentifiers(this.ourContext)));
        this.ourContext.removeCached(this, this.getID());
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        String query = "update bundle set primary_bitstream_id = ";
        query = query + (oracle ? "''" : "Null") + " where primary_bitstream_id = ? ";
        DatabaseManager.updateQuery(this.ourContext, query, this.bRow.getIntColumn("bitstream_id"));
        BitstreamStorageManager.delete(this.ourContext, this.bRow.getIntColumn("bitstream_id"));
        this.removeMetadataFromDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDeleted() throws SQLException {
        String query = "select count(*) as mycount from Bitstream where deleted = '1' and bitstream_id = ? ";
        long count = 0L;
        try (TableRowIterator tri = DatabaseManager.query(this.ourContext, query, this.bRow.getIntColumn("bitstream_id"));){
            TableRow r = tri.next();
            count = r.getLongColumn("mycount");
        }
        return count == 1L;
    }

    public InputStream retrieve() throws IOException, SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 0);
        return BitstreamStorageManager.retrieve(this.ourContext, this.bRow.getIntColumn("bitstream_id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() throws SQLException {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        try (TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "bundle", "SELECT bundle.* FROM bundle, bundle2bitstream WHERE bundle.bundle_id=bundle2bitstream.bundle_id AND bundle2bitstream.bitstream_id= ? ", this.bRow.getIntColumn("bitstream_id"));){
            while (tri.hasNext()) {
                TableRow r = tri.next();
                Bundle fromCache = (Bundle)this.ourContext.fromCache(Bundle.class, r.getIntColumn("bundle_id"));
                if (fromCache != null) {
                    bundles.add(fromCache);
                    continue;
                }
                bundles.add(new Bundle(this.ourContext, r));
            }
        }
        Bundle[] bundleArray = new Bundle[bundles.size()];
        bundleArray = bundles.toArray(bundleArray);
        return bundleArray;
    }

    @Override
    public int getType() {
        return 0;
    }

    public boolean isRegisteredBitstream() {
        return BitstreamStorageManager.isRegisteredBitstream(this.bRow.getStringColumn("internal_id"));
    }

    public int getStoreNumber() {
        return this.bRow.getIntColumn("store_number");
    }

    @Override
    public DSpaceObject getParentObject() throws SQLException {
        Bundle[] bundles = this.getBundles();
        if (bundles != null && bundles.length > 0 && bundles[0] != null) {
            Item[] items = bundles[0].getItems();
            if (items != null && items.length > 0) {
                return items[0];
            }
            return null;
        }
        TableRow qResult = DatabaseManager.querySingle(this.ourContext, "SELECT collection_id FROM collection WHERE logo_bitstream_id = ?", this.getID());
        if (qResult != null) {
            return Collection.find(this.ourContext, qResult.getIntColumn("collection_id"));
        }
        qResult = DatabaseManager.querySingle(this.ourContext, "SELECT community_id FROM community WHERE logo_bitstream_id = ?", this.getID());
        if (qResult != null) {
            return Community.find(this.ourContext, qResult.getIntColumn("community_id"));
        }
        return null;
    }

    @Override
    public void updateLastModified() {
        this.ourContext.addEvent(new Event(2, 0, this.getID(), null, this.getIdentifiers(this.ourContext)));
    }
}

