/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.Metadatum;
import org.dspace.content.Site;
import org.dspace.content.authority.ChoiceAuthorityManager;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.MetadataAuthorityManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.event.Event;
import org.dspace.handle.HandleManager;
import org.dspace.identifier.IdentifierService;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.utils.DSpace;

public abstract class DSpaceObject {
    protected Context ourContext;
    private static final Logger log = Logger.getLogger(DSpaceObject.class);
    protected boolean modifiedMetadata;
    private StringBuffer eventDetails = null;
    private String[] identifiers = null;
    protected MetadataCache metadataCache = new MetadataCache();
    protected transient MetadataField[] allMetadataFields = null;

    protected DSpaceObject() {
        this.modifiedMetadata = false;
    }

    protected DSpaceObject(Context context) {
        this.ourContext = context;
        this.modifiedMetadata = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetadata() throws SQLException, AuthorizeException {
        HashMap<String, Integer> elementCount = new HashMap<String, Integer>();
        this.modifiedMetadata = false;
        int[] placeNum = new int[this.getMetadata().size()];
        boolean[] storedDC = new boolean[this.getMetadata().size()];
        MetadataField[] dcFields = new MetadataField[this.getMetadata().size()];
        for (int dcIdx = 0; dcIdx < this.getMetadata().size(); ++dcIdx) {
            Metadatum dcv = this.getMetadata().get(dcIdx);
            int current = 0;
            String key = dcv.element + (dcv.qualifier == null ? "" : "." + dcv.qualifier);
            Integer currentInteger = (Integer)elementCount.get(key);
            if (currentInteger != null) {
                current = currentInteger;
            }
            elementCount.put(key, ++current);
            placeNum[dcIdx] = current;
            storedDC[dcIdx] = false;
            dcFields[dcIdx] = this.getMetadataField(dcv);
            if (dcFields[dcIdx] != null) continue;
            log.warn((Object)("Invalid metadata field: [" + dcv.getField() + "] : [" + dcv.value + "]"));
            throw new SQLException("Invalid metadata field: [" + dcv.getField() + "]");
        }
        TableRowIterator tri = this.retrieveMetadata();
        if (tri != null) {
            try {
                while (tri.hasNext()) {
                    TableRow tr = tri.next();
                    boolean removeRow = true;
                    for (int dcIdx = 0; dcIdx < this.getMetadata().size() && removeRow; ++dcIdx) {
                        if (storedDC[dcIdx]) continue;
                        boolean matched = true;
                        Metadatum dcv = this.getMetadata().get(dcIdx);
                        if (matched && dcFields[dcIdx].getFieldID() != tr.getIntColumn("metadata_field_id")) {
                            matched = false;
                        }
                        if (matched && placeNum[dcIdx] != tr.getIntColumn("place")) {
                            matched = false;
                        }
                        if (matched) {
                            String text = tr.getStringColumn("text_value");
                            matched = dcv.value == null && text == null ? true : dcv.value != null && dcv.value.equals(text);
                        }
                        if (matched) {
                            String lang = tr.getStringColumn("text_lang");
                            matched = dcv.language == null && lang == null ? true : dcv.language != null && dcv.language.equals(lang);
                        }
                        if (matched) {
                            String auth = tr.getStringColumn("authority");
                            int conf = tr.getIntColumn("confidence");
                            if (!(dcv.authority == null && auth == null || dcv.authority != null && auth != null && dcv.authority.equals(auth) && dcv.confidence == conf)) {
                                matched = false;
                            }
                        }
                        if (!matched) continue;
                        storedDC[dcIdx] = true;
                        removeRow = false;
                    }
                    if (!removeRow) continue;
                    DatabaseManager.delete(this.ourContext, tr);
                    this.modifiedMetadata = true;
                }
            }
            finally {
                tri.close();
            }
        }
        for (int dcIdx = 0; dcIdx < this.getMetadata().size(); ++dcIdx) {
            if (storedDC[dcIdx]) continue;
            Metadatum dcv = this.getMetadata().get(dcIdx);
            MetadataValue metadata = new MetadataValue();
            metadata.setResourceId(this.getID());
            metadata.setResourceTypeId(this.getType());
            metadata.setFieldId(dcFields[dcIdx].getFieldID());
            metadata.setValue(dcv.value);
            metadata.setLanguage(dcv.language);
            metadata.setPlace(placeNum[dcIdx]);
            metadata.setAuthority(dcv.authority);
            metadata.setConfidence(dcv.confidence);
            metadata.create(this.ourContext);
            this.modifiedMetadata = true;
        }
        if (this.modifiedMetadata) {
            this.ourContext.addEvent(new Event(4, this.getType(), this.getID(), this.getDetails(), this.getIdentifiers(this.ourContext)));
            this.modifiedMetadata = false;
        }
    }

    protected void clearDetails() {
        this.eventDetails = null;
    }

    protected void addDetails(String d) {
        if (this.eventDetails == null) {
            this.eventDetails = new StringBuffer(d);
        } else {
            this.eventDetails.append(", ").append(d);
        }
    }

    protected String getDetails() {
        return this.eventDetails == null ? null : this.eventDetails.toString();
    }

    public abstract int getType();

    public String getTypeText() {
        return Constants.typeText[this.getType()];
    }

    public abstract int getID();

    public abstract String getHandle();

    public abstract String getName();

    public String[] getIdentifiers(Context context) {
        if (this.identifiers == null) {
            log.debug((Object)"This DSO's identifiers cache is empty, looking for identifiers...");
            this.identifiers = new String[0];
            IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
            if (identifierService != null) {
                this.identifiers = identifierService.lookup(context, this);
            } else {
                log.warn((Object)"No IdentifierService found, will return an array containing the Handle only.");
                if (this.getHandle() != null) {
                    this.identifiers = new String[]{HandleManager.getCanonicalForm(this.getHandle())};
                }
            }
        }
        if (this.identifiers == null) {
            this.identifiers = new String[0];
        }
        if (log.isDebugEnabled()) {
            StringBuilder dbgMsg = new StringBuilder();
            for (String id : this.identifiers) {
                if (dbgMsg.capacity() == 0) {
                    dbgMsg.append("This DSO's Identifiers are: ");
                } else {
                    dbgMsg.append(", ");
                }
                dbgMsg.append(id);
            }
            dbgMsg.append(".");
            log.debug((Object)dbgMsg.toString());
        }
        return this.identifiers;
    }

    public void resetIdentifiersCache() {
        this.identifiers = null;
    }

    public static DSpaceObject find(Context context, int type, int id) throws SQLException {
        switch (type) {
            case 0: {
                return Bitstream.find(context, id);
            }
            case 1: {
                return Bundle.find(context, id);
            }
            case 2: {
                return Item.find(context, id);
            }
            case 3: {
                return Collection.find(context, id);
            }
            case 4: {
                return Community.find(context, id);
            }
            case 6: {
                return Group.find(context, id);
            }
            case 7: {
                return EPerson.find(context, id);
            }
            case 5: {
                return Site.find(context, id);
            }
        }
        return null;
    }

    public DSpaceObject getAdminObject(int action) throws SQLException {
        if (action == 11) {
            throw new IllegalArgumentException("Illegal call to the DSpaceObject.getAdminObject method");
        }
        return this;
    }

    public DSpaceObject getParentObject() throws SQLException {
        return null;
    }

    public abstract void update() throws SQLException, AuthorizeException;

    public abstract void updateLastModified();

    private TableRowIterator retrieveMetadata() throws SQLException {
        return DatabaseManager.queryTable(this.ourContext, "MetadataValue", "SELECT * FROM MetadataValue WHERE resource_id= ? and resource_type_id = ? ORDER BY metadata_field_id, place", this.getID(), this.getType());
    }

    @Deprecated
    public Metadatum[] getDC(String element, String qualifier, String lang) {
        return this.getMetadata("dc", element, qualifier, lang);
    }

    public Metadatum[] getMetadata(String schema, String element, String qualifier, String lang) {
        ArrayList<Metadatum> values = new ArrayList<Metadatum>();
        for (Metadatum dcv : this.getMetadata()) {
            if (!this.match(schema, element, qualifier, lang, dcv)) continue;
            Metadatum copy = new Metadatum();
            copy.element = dcv.element;
            copy.qualifier = dcv.qualifier;
            copy.value = dcv.value;
            copy.language = dcv.language;
            copy.schema = dcv.schema;
            copy.authority = dcv.authority;
            copy.confidence = dcv.confidence;
            values.add(copy);
        }
        Metadatum[] valueArray = new Metadatum[values.size()];
        valueArray = values.toArray(valueArray);
        return valueArray;
    }

    public Metadatum[] getMetadataByMetadataString(String mdString) {
        StringTokenizer dcf = new StringTokenizer(mdString, ".");
        String[] tokens = new String[]{"", "", ""};
        int i = 0;
        while (dcf.hasMoreTokens()) {
            tokens[i] = dcf.nextToken().trim();
            ++i;
        }
        String schema = tokens[0];
        String element = tokens[1];
        String qualifier = tokens[2];
        Metadatum[] values = "*".equals(qualifier) ? this.getMetadata(schema, element, "*", "*") : ("".equals(qualifier) ? this.getMetadata(schema, element, null, "*") : this.getMetadata(schema, element, qualifier, "*"));
        return values;
    }

    protected String getMetadataFirstValue(String schema, String element, String qualifier, String language) {
        Metadatum[] dcvalues = this.getMetadata(schema, element, qualifier, "*");
        if (dcvalues.length > 0) {
            return dcvalues[0].value;
        }
        return null;
    }

    protected void setMetadataSingleValue(String schema, String element, String qualifier, String language, String value) {
        if (value != null) {
            this.clearMetadata(schema, element, qualifier, language);
            this.addMetadata(schema, element, qualifier, language, value);
            this.modifiedMetadata = true;
        }
    }

    protected List<Metadatum> getMetadata() {
        try {
            return this.metadataCache.get(this.ourContext, this.getID(), this.getType(), log);
        }
        catch (SQLException e) {
            log.error((Object)"Loading item - cannot load metadata");
            return new ArrayList<Metadatum>();
        }
    }

    public String getMetadata(String value) {
        Metadatum[] dcvalues = this.getMetadataByMetadataString(value);
        if (dcvalues.length > 0) {
            return dcvalues[0].value;
        }
        return null;
    }

    public List<Metadatum> getMetadata(String mdString, String authority) {
        String[] elements = DSpaceObject.getElements(mdString);
        return this.getMetadata(elements[0], elements[1], elements[2], elements[3], authority);
    }

    public List<Metadatum> getMetadata(String schema, String element, String qualifier, String lang, String authority) {
        Metadatum[] metadata = this.getMetadata(schema, element, qualifier, lang);
        List<Metadatum> dcValues = Arrays.asList(metadata);
        if (!authority.equals("*")) {
            Iterator<Metadatum> iterator = dcValues.iterator();
            while (iterator.hasNext()) {
                Metadatum dcValue = iterator.next();
                if (authority.equals(dcValue.authority)) continue;
                iterator.remove();
            }
        }
        return dcValues;
    }

    public static String[] getElements(String fieldName) {
        Object[] tokens = StringUtils.split((String)fieldName, (String)".");
        int add = 4 - tokens.length;
        if (add > 0) {
            tokens = (String[])ArrayUtils.addAll((Object[])tokens, (Object[])new String[add]);
        }
        return tokens;
    }

    public static String[] getElementsFilled(String fieldName) {
        String[] elements = DSpaceObject.getElements(fieldName);
        for (int i = 0; i < elements.length; ++i) {
            if (!StringUtils.isBlank((String)elements[i])) continue;
            elements[i] = "*";
        }
        return elements;
    }

    public void replaceMetadataValue(Metadatum oldValue, Metadatum newValue) {
        if (oldValue.hasSameFieldAs(newValue)) {
            String schema = oldValue.schema;
            String element = oldValue.element;
            String qualifier = oldValue.qualifier;
            Metadatum[] dcvalues = this.getMetadata(schema, element, qualifier, "*");
            this.clearMetadata(schema, element, qualifier, "*");
            for (Metadatum dcvalue : dcvalues) {
                if (dcvalue.equals(oldValue)) {
                    this.addMetadata(schema, element, qualifier, newValue.language, newValue.value, newValue.authority, newValue.confidence);
                    continue;
                }
                this.addMetadata(schema, element, qualifier, dcvalue.language, dcvalue.value, dcvalue.authority, dcvalue.confidence);
            }
        }
    }

    @Deprecated
    public void addDC(String element, String qualifier, String lang, String[] values) {
        this.addMetadata("dc", element, qualifier, lang, values);
    }

    @Deprecated
    public void addDC(String element, String qualifier, String lang, String value) {
        this.addMetadata("dc", element, qualifier, lang, value);
    }

    public void addMetadata(String schema, String element, String qualifier, String lang, String[] values) {
        String fieldKey;
        MetadataAuthorityManager mam = MetadataAuthorityManager.getManager();
        if (mam.isAuthorityControlled(fieldKey = MetadataAuthorityManager.makeFieldKey(schema, element, qualifier))) {
            String[] authorities = new String[values.length];
            int[] confidences = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.getAuthoritiesAndConfidences(fieldKey, values, authorities, confidences, i);
            }
            this.addMetadata(schema, element, qualifier, lang, values, authorities, confidences);
        } else {
            this.addMetadata(schema, element, qualifier, lang, values, null, null);
        }
    }

    protected void getAuthoritiesAndConfidences(String fieldKey, String[] values, String[] authorities, int[] confidences, int i) {
        Choices c = ChoiceAuthorityManager.getManager().getBestMatch(fieldKey, values[i], -1, null);
        authorities[i] = c.values.length > 0 ? c.values[0].authority : null;
        confidences[i] = c.confidence;
    }

    public void addMetadata(String schema, String element, String qualifier, String lang, String[] values, String[] authorities, int[] confidences) {
        List<Metadatum> dublinCore = this.getMetadata();
        MetadataAuthorityManager mam = MetadataAuthorityManager.getManager();
        boolean authorityControlled = mam.isAuthorityControlled(schema, element, qualifier);
        boolean authorityRequired = mam.isAuthorityRequired(schema, element, qualifier);
        String fieldName = schema + "." + element + (qualifier == null ? "" : "." + qualifier);
        for (int i = 0; i < values.length; ++i) {
            Metadatum dcv = new Metadatum();
            dcv.schema = schema;
            dcv.element = element;
            dcv.qualifier = qualifier;
            String string = dcv.language = lang == null ? null : lang.trim();
            if (authorityControlled) {
                if (authorities != null && authorities[i] != null && authorities[i].length() > 0) {
                    dcv.authority = authorities[i];
                    dcv.confidence = confidences == null ? 0 : confidences[i];
                } else {
                    dcv.authority = null;
                    int n = dcv.confidence = confidences == null ? -1 : confidences[i];
                }
                if (authorityRequired && (dcv.authority == null || dcv.authority.length() == 0)) {
                    throw new IllegalArgumentException("The metadata field \"" + fieldName + "\" requires an authority key but none was provided. Vaue=\"" + dcv.value + "\"");
                }
            }
            if (values[i] != null) {
                String temp = values[i].trim();
                char[] dcvalue = temp.toCharArray();
                for (int charPos = 0; charPos < dcvalue.length; ++charPos) {
                    if (!Character.isISOControl(dcvalue[charPos]) || String.valueOf(dcvalue[charPos]).equals("\t") || String.valueOf(dcvalue[charPos]).equals("\n") || String.valueOf(dcvalue[charPos]).equals("\r")) continue;
                    dcvalue[charPos] = 32;
                }
                dcv.value = String.valueOf(dcvalue);
            } else {
                dcv.value = null;
            }
            dublinCore.add(dcv);
            this.addDetails(fieldName);
        }
        if (values.length > 0) {
            this.modifiedMetadata = true;
        }
    }

    public void addMetadata(String schema, String element, String qualifier, String lang, String value) {
        String[] valArray = new String[]{value};
        this.addMetadata(schema, element, qualifier, lang, valArray);
    }

    public void addMetadata(String schema, String element, String qualifier, String lang, String value, String authority, int confidence) {
        String[] valArray = new String[1];
        String[] authArray = new String[1];
        int[] confArray = new int[1];
        valArray[0] = value;
        authArray[0] = authority;
        confArray[0] = confidence;
        this.addMetadata(schema, element, qualifier, lang, valArray, authArray, confArray);
    }

    @Deprecated
    public void clearDC(String element, String qualifier, String lang) {
        this.clearMetadata("dc", element, qualifier, lang);
    }

    public void clearMetadata(String schema, String element, String qualifier, String lang) {
        ArrayList<Metadatum> values = new ArrayList<Metadatum>();
        for (Metadatum dcv : this.getMetadata()) {
            if (this.match(schema, element, qualifier, lang, dcv)) continue;
            values.add(dcv);
        }
        this.setMetadata(values);
        this.modifiedMetadata = true;
    }

    private boolean match(String schema, String element, String qualifier, String language, Metadatum dcv) {
        if (!element.equals("*") && !element.equals(dcv.element)) {
            return false;
        }
        if (qualifier == null ? dcv.qualifier != null : !qualifier.equals("*") && !qualifier.equals(dcv.qualifier)) {
            return false;
        }
        if (language == null ? dcv.language != null : !language.equals("*") && !language.equals(dcv.language)) {
            return false;
        }
        return schema.equals("*") || dcv.schema == null || dcv.schema.equals(schema);
    }

    protected MetadataField getMetadataField(Metadatum dcv) throws SQLException, AuthorizeException {
        if (this.allMetadataFields == null) {
            this.allMetadataFields = MetadataField.findAll(this.ourContext);
        }
        if (this.allMetadataFields != null) {
            int schemaID = this.getMetadataSchemaID(dcv);
            for (MetadataField field : this.allMetadataFields) {
                if (field.getSchemaID() != schemaID || !StringUtils.equals((String)field.getElement(), (String)dcv.element) || !StringUtils.equals((String)field.getQualifier(), (String)dcv.qualifier)) continue;
                return field;
            }
        }
        return null;
    }

    private int getMetadataSchemaID(Metadatum dcv) throws SQLException {
        MetadataSchema schema = MetadataSchema.find(this.ourContext, dcv.schema);
        int schemaID = schema == null ? 1 : schema.getSchemaID();
        return schemaID;
    }

    protected void removeMetadataFromDatabase() throws SQLException {
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM MetadataValue WHERE resource_id= ? and resource_type_id=?", this.getID(), this.getType());
    }

    private void setMetadata(List<Metadatum> metadata) {
        this.metadataCache.set(metadata);
        this.modifiedMetadata = true;
    }

    protected String[] getMDValueByField(String field) {
        StringTokenizer dcf = new StringTokenizer(field, ".");
        String[] tokens = new String[]{"", "", ""};
        int i = 0;
        while (dcf.hasMoreTokens()) {
            tokens[i] = dcf.nextToken().trim();
            ++i;
        }
        if (i != 0) {
            return tokens;
        }
        return this.getMDValueByLegacyField(field);
    }

    protected String[] getMDValueByLegacyField(String field) {
        switch (field) {
            case "introductory_text": {
                return new String[]{"dc", "description", null};
            }
            case "short_description": {
                return new String[]{"dc", "description", "abstract"};
            }
            case "side_bar_text": {
                return new String[]{"dc", "description", "tableofcontents"};
            }
            case "copyright_text": {
                return new String[]{"dc", "rights", null};
            }
            case "name": {
                return new String[]{"dc", "title", null};
            }
            case "provenance_description": {
                return new String[]{"dc", "provenance", null};
            }
            case "license": {
                return new String[]{"dc", "rights", "license"};
            }
            case "user_format_description": {
                return new String[]{"dc", "format", null};
            }
            case "source": {
                return new String[]{"dc", "source", null};
            }
            case "firstname": {
                return new String[]{"eperson", "firstname", null};
            }
            case "lastname": {
                return new String[]{"eperson", "lastname", null};
            }
            case "phone": {
                return new String[]{"eperson", "phone", null};
            }
            case "language": {
                return new String[]{"eperson", "language", null};
            }
        }
        return new String[]{null, null, null};
    }

    class MetadataCache {
        List<Metadatum> metadata = null;

        MetadataCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<Metadatum> get(Context c, int resourceId, int resourceTypeId, Logger log) throws SQLException {
            if (this.metadata == null) {
                this.metadata = new ArrayList<Metadatum>();
                TableRowIterator tri = this.retrieveMetadata(resourceId, resourceTypeId);
                if (tri != null) {
                    try {
                        while (tri.hasNext()) {
                            TableRow resultRow = tri.next();
                            int fieldID = resultRow.getIntColumn("metadata_field_id");
                            MetadataField field = MetadataField.find(c, fieldID);
                            if (field == null) {
                                log.error((Object)("Loading item - cannot find metadata field " + fieldID + " for resourceType=" + resourceTypeId + " and resourceId=" + resourceId));
                                continue;
                            }
                            MetadataSchema schema = MetadataSchema.find(c, field.getSchemaID());
                            if (schema == null) {
                                log.error((Object)("Loading item - cannot find metadata schema " + field.getSchemaID() + ", field " + fieldID));
                                continue;
                            }
                            Metadatum dcv = new Metadatum();
                            dcv.element = field.getElement();
                            dcv.qualifier = field.getQualifier();
                            dcv.value = resultRow.getStringColumn("text_value");
                            dcv.language = resultRow.getStringColumn("text_lang");
                            dcv.schema = schema.getName();
                            dcv.authority = resultRow.getStringColumn("authority");
                            dcv.confidence = resultRow.getIntColumn("confidence");
                            this.metadata.add(dcv);
                        }
                    }
                    finally {
                        if (tri != null) {
                            tri.close();
                        }
                    }
                }
            }
            return this.metadata;
        }

        void set(List<Metadatum> m) {
            this.metadata = m;
        }

        TableRowIterator retrieveMetadata(int resourceId, int resourceTypeId) throws SQLException {
            return DatabaseManager.queryTable(DSpaceObject.this.ourContext, "MetadataValue", "SELECT * FROM MetadataValue WHERE resource_id= ? and resource_type_id = ? ORDER BY metadata_field_id, place", resourceId, resourceTypeId);
        }
    }
}

