/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;

public abstract class AbstractPackageIngester
implements PackageIngester {
    private static Logger log = Logger.getLogger(AbstractPackageIngester.class);
    private Map<DSpaceObject, List<String>> packageReferences = new HashMap<DSpaceObject, List<String>>();
    private Map<File, String> pkgIngestedMap = new LinkedHashMap<File, String>();

    @Override
    public List<String> ingestAll(Context context, DSpaceObject parent, File pkgFile, PackageParameters params, String license) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        if (!params.recursiveModeEnabled()) {
            params.setRecursiveModeEnabled(true);
        }
        DSpaceObject dso = null;
        if (!this.getIngestedMap().containsKey(pkgFile)) {
            try {
                dso = this.ingest(context, parent, pkgFile, params, license);
            }
            catch (IllegalStateException ie) {
                if (params.keepExistingModeEnabled()) {
                    log.warn((Object)LogManager.getHeader(context, "skip_package_ingest", "Object already exists, package-skipped=" + pkgFile.getName()));
                }
                throw ie;
            }
        } else {
            log.info((Object)LogManager.getHeader(context, "skip_package_ingest", "Object was already ingested, package-skipped=" + pkgFile.getName()));
        }
        if (dso != null) {
            List<String> childPkgRefs;
            this.addToIngestedMap(pkgFile, dso);
            if (dso.getType() != 2 && (childPkgRefs = this.getPackageReferences(dso)) != null && !childPkgRefs.isEmpty()) {
                for (String childPkgRef : childPkgRefs) {
                    String childHandle;
                    File childPkg = new File(pkgFile.getAbsoluteFile().getParent(), childPkgRef);
                    this.ingestAll(context, null, childPkg, params, license);
                    if (3 != dso.getType() || (childHandle = this.getIngestedMap().get(childPkg)) == null) continue;
                    Item childItem = (Item)HandleManager.resolveToObject(context, childHandle);
                    Collection collection = (Collection)dso;
                    if (childItem == null || childItem.isIn(collection)) continue;
                    collection.addItem(childItem);
                }
            }
        }
        return this.getIngestedList();
    }

    @Override
    public List<String> replaceAll(Context context, DSpaceObject dso, File pkgFile, PackageParameters params) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        if (!params.recursiveModeEnabled()) {
            params.setRecursiveModeEnabled(true);
        }
        DSpaceObject replacedDso = null;
        if (!this.getIngestedMap().containsKey(pkgFile)) {
            replacedDso = this.replace(context, dso, pkgFile, params);
        } else {
            log.info((Object)LogManager.getHeader(context, "skip_package_replace", "Object was already replaced, package-skipped=" + pkgFile.getName()));
        }
        if (replacedDso != null) {
            List<String> childPkgRefs;
            this.addToIngestedMap(pkgFile, replacedDso);
            if (replacedDso.getType() != 2 && (childPkgRefs = this.getPackageReferences(replacedDso)) != null && !childPkgRefs.isEmpty()) {
                for (String childPkgRef : childPkgRefs) {
                    String childHandle;
                    File childPkg = new File(pkgFile.getAbsoluteFile().getParent(), childPkgRef);
                    this.replaceAll(context, null, childPkg, params);
                    if (3 != replacedDso.getType() || (childHandle = this.getIngestedMap().get(childPkg)) == null) continue;
                    Item childItem = (Item)HandleManager.resolveToObject(context, childHandle);
                    Collection collection = (Collection)replacedDso;
                    if (childItem == null || childItem.isIn(collection)) continue;
                    collection.addItem(childItem);
                }
            }
        }
        return this.getIngestedList();
    }

    public void addPackageReference(DSpaceObject dso, String packageRef) {
        List<String> packageRefValues = null;
        packageRefValues = this.packageReferences.containsKey(dso) ? this.packageReferences.get(dso) : new ArrayList<String>();
        packageRefValues.add(packageRef);
        this.packageReferences.put(dso, packageRefValues);
    }

    public List<String> getPackageReferences(DSpaceObject dso) {
        return this.packageReferences.get(dso);
    }

    protected void addToIngestedMap(File pkgFile, DSpaceObject dso) {
        if (!this.pkgIngestedMap.containsKey(pkgFile)) {
            this.pkgIngestedMap.put(pkgFile, dso.getHandle());
        }
    }

    protected Map<File, String> getIngestedMap() {
        return this.pkgIngestedMap;
    }

    protected List<String> getIngestedList() {
        java.util.Collection<String> coll = this.pkgIngestedMap.values();
        if (coll instanceof List) {
            return (List)coll;
        }
        return new ArrayList<String>(coll);
    }
}

