/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Supervisor {
    public static final int POLICY_NONE = 0;
    public static final int POLICY_EDITOR = 1;
    public static final int POLICY_OBSERVER = 2;

    private Supervisor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOrder(Context context, int wsItemID, int groupID) throws SQLException {
        String query = "SELECT epersongroup2workspaceitem.* FROM epersongroup2workspaceitem WHERE epersongroup2workspaceitem.eperson_group_id = ? AND epersongroup2workspaceitem.workspace_item_id = ? ";
        try (TableRowIterator tri = DatabaseManager.queryTable(context, "epersongroup2workspaceitem", query, groupID, wsItemID);){
            boolean bl = tri.hasNext();
            return bl;
        }
    }

    public static void remove(Context context, int wsItemID, int groupID) throws SQLException, AuthorizeException {
        WorkspaceItem wsItem = WorkspaceItem.find(context, wsItemID);
        Group group = Group.find(context, groupID);
        String query = "DELETE FROM epersongroup2workspaceitem WHERE workspace_item_id = ? AND eperson_group_id = ? ";
        DatabaseManager.updateQuery(context, query, wsItemID, groupID);
        Item item = wsItem.getItem();
        item.removeGroupPolicies(group);
    }

    public static void removeRedundant(Context context) throws SQLException {
        String query = "DELETE FROM epersongroup2workspaceitem WHERE NOT EXISTS ( SELECT 1 FROM workspaceitem WHERE workspace_item_id = epersongroup2workspaceitem.workspace_item_id ) OR NOT EXISTS ( SELECT 1 FROM epersongroup WHERE eperson_group_id = epersongroup2workspaceitem.eperson_group_id )";
        DatabaseManager.updateQuery(context, query, new Object[0]);
    }

    public static void add(Context context, int groupID, int wsItemID, int policy) throws SQLException, AuthorizeException {
        TableRow row = DatabaseManager.row("epersongroup2workspaceitem");
        row.setColumn("workspace_item_id", wsItemID);
        row.setColumn("eperson_group_id", groupID);
        DatabaseManager.insert(context, row);
        if (policy != 0) {
            WorkspaceItem wsItem = WorkspaceItem.find(context, wsItemID);
            Item item = wsItem.getItem();
            Group group = Group.find(context, groupID);
            if (policy == 1) {
                ResourcePolicy r = ResourcePolicy.create(context);
                r.setResource(item);
                r.setGroup(group);
                r.setAction(0);
                r.update();
                r = ResourcePolicy.create(context);
                r.setResource(item);
                r.setGroup(group);
                r.setAction(1);
                r.update();
                r = ResourcePolicy.create(context);
                r.setResource(item);
                r.setGroup(group);
                r.setAction(3);
                r.update();
            } else if (policy == 2) {
                ResourcePolicy r = ResourcePolicy.create(context);
                r.setResource(item);
                r.setGroup(group);
                r.setAction(0);
                r.update();
            }
        }
    }
}

