/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.doi.DOIIdentifierException;

public class DOI
implements Identifier {
    public static final String SCHEME = "doi:";
    public static final String RESOLVER = "http://dx.doi.org";

    public static String DOIToExternalForm(String identifier) throws IdentifierException {
        if (null == identifier) {
            throw new IllegalArgumentException("Identifier is null.", new NullPointerException());
        }
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Cannot format an empty identifier.");
        }
        if (identifier.startsWith(SCHEME)) {
            return "http://dx.doi.org/" + identifier.substring(SCHEME.length());
        }
        if (identifier.startsWith("10.") && identifier.contains("/")) {
            return "http://dx.doi.org/" + identifier;
        }
        if (identifier.startsWith("http://dx.doi.org/10.")) {
            return identifier;
        }
        throw new IdentifierException(identifier + "does not seem to be a DOI.");
    }

    public static String DOIFromExternalFormat(String identifier) throws DOIIdentifierException {
        Pattern pattern = Pattern.compile("^http://dx.doi.org/+(10\\..*)$");
        Matcher matcher = pattern.matcher(identifier);
        if (matcher.find()) {
            return SCHEME + matcher.group(1);
        }
        throw new DOIIdentifierException("Cannot recognize DOI!", 11);
    }

    public static String formatIdentifier(String identifier) throws DOIIdentifierException {
        if (null == identifier) {
            throw new IllegalArgumentException("Identifier is null.", new NullPointerException());
        }
        if (identifier.startsWith(SCHEME)) {
            return identifier;
        }
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Cannot format an empty identifier.");
        }
        if (identifier.startsWith("10.") && identifier.contains("/")) {
            return SCHEME + identifier;
        }
        if (identifier.startsWith("http://dx.doi.org/10.")) {
            return SCHEME + identifier.substring(18);
        }
        throw new DOIIdentifierException(identifier + "does not seem to be a DOI.", 11);
    }
}

