/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.util.XMLUtils;
import org.dspace.submit.util.SubmissionLookupPublication;
import org.w3c.dom.Element;

public class CiNiiUtils {
    public static Record convertCiNiiDomToRecord(Element xmlRoot) {
        String naid;
        String ncid;
        String issued;
        String issn;
        String pages;
        String epage;
        String spage;
        String issue;
        String publisher;
        List<Value> authorAlternative;
        List<Value> authors;
        String titleAlternative;
        String title;
        SubmissionLookupPublication record = new SubmissionLookupPublication("");
        List<Element> list = XMLUtils.getElementList(xmlRoot, "rdf:Description");
        if (list.size() < 3) {
            return record;
        }
        Element description_ja = list.get(0);
        Element description_en = list.get(1);
        String language = XMLUtils.getElementValue(description_ja, "dc:language");
        language = language != null ? language.toLowerCase() : "ja";
        record.addValue("language", (Value)new StringValue(language));
        if ("ja".equals(language) || "jpn".equals(language)) {
            title = XMLUtils.getElementValue(description_ja, "dc:title");
            if (title != null) {
                record.addValue("title", (Value)new StringValue(title));
            }
            if ((titleAlternative = XMLUtils.getElementValue(description_en, "dc:title")) != null) {
                record.addValue("titleAlternative", (Value)new StringValue(titleAlternative));
            }
            if ((authors = CiNiiUtils.getAuthors(description_ja)).size() > 0) {
                record.addField("authors", authors);
            }
            if ((authorAlternative = CiNiiUtils.getAuthors(description_en)).size() > 0) {
                record.addField("auhtorAlternative", authorAlternative);
            }
            if ((publisher = XMLUtils.getElementValue(description_ja, "dc:publisher")) != null) {
                record.addValue("publisher", (Value)new StringValue(publisher));
            }
        } else {
            title = XMLUtils.getElementValue(description_en, "dc:title");
            if (title != null) {
                record.addValue("title", (Value)new StringValue(title));
            }
            if ((titleAlternative = XMLUtils.getElementValue(description_ja, "dc:title")) != null) {
                record.addValue("titleAlternative", (Value)new StringValue(titleAlternative));
            }
            if ((authors = CiNiiUtils.getAuthors(description_en)).size() > 0) {
                record.addField("authors", authors);
            }
            if ((authorAlternative = CiNiiUtils.getAuthors(description_ja)).size() > 0) {
                record.addField("authorAlternative", authorAlternative);
            }
            if ((publisher = XMLUtils.getElementValue(description_en, "dc:publisher")) != null) {
                record.addValue("publisher", (Value)new StringValue(publisher));
            }
        }
        String abstract_ja = XMLUtils.getElementValue(description_ja, "dc:description");
        String abstract_en = XMLUtils.getElementValue(description_en, "dc:description");
        if (abstract_ja != null && abstract_en != null) {
            LinkedList<StringValue> description = new LinkedList<StringValue>();
            description.add(new StringValue(abstract_ja));
            description.add(new StringValue(abstract_en));
            record.addField("description", description);
        } else if (abstract_ja != null) {
            record.addValue("description", (Value)new StringValue(abstract_ja));
        } else if (abstract_en != null) {
            record.addValue("description", (Value)new StringValue(abstract_en));
        }
        List<Value> subjects = CiNiiUtils.getSubjects(description_ja);
        subjects.addAll(CiNiiUtils.getSubjects(description_en));
        if (subjects.size() > 0) {
            record.addField("subjects", subjects);
        }
        String journal_j = XMLUtils.getElementValue(description_ja, "prism:publicationName");
        String journal_e = XMLUtils.getElementValue(description_en, "prism:publicationName");
        if (journal_j != null && journal_e != null) {
            record.addValue("journal", (Value)new StringValue(journal_j + " = " + journal_e));
        } else if (journal_j != null) {
            record.addValue("journal", (Value)new StringValue(journal_j));
        } else if (journal_e != null) {
            record.addValue("journal", (Value)new StringValue(journal_e));
        }
        String volume = XMLUtils.getElementValue(description_ja, "prism:volume");
        if (volume != null) {
            record.addValue("volume", (Value)new StringValue(volume));
        }
        if ((issue = XMLUtils.getElementValue(description_ja, "prism:number")) != null) {
            record.addValue("issue", (Value)new StringValue(issue));
        }
        if ((spage = XMLUtils.getElementValue(description_ja, "prism:startingPage")) != null) {
            record.addValue("spage", (Value)new StringValue(spage));
        }
        if ((epage = XMLUtils.getElementValue(description_ja, "prism:endingPage")) != null) {
            record.addValue("epage", (Value)new StringValue(epage));
        }
        if ((pages = XMLUtils.getElementValue(description_ja, "prism:pageRange")) != null && spage == null) {
            int pos = pages.indexOf("-");
            if (pos > -1) {
                spage = pages.substring(0, pos);
                epage = pages.substring(pos + 1, pages.length() - pos);
                if (!epage.equals("") && spage.length() > epage.length()) {
                    epage = spage.substring(0, spage.length() - epage.length()) + epage;
                }
            } else {
                spage = pages;
                epage = "";
            }
            record.addValue("spage", (Value)new StringValue(spage));
            if (!epage.equals("") && epage == null) {
                record.addValue("epage", (Value)new StringValue(epage));
            }
        }
        if ((issn = XMLUtils.getElementValue(description_ja, "prism:issn")) != null) {
            record.addValue("issn", (Value)new StringValue(issn));
        }
        if ((issued = XMLUtils.getElementValue(description_ja, "prism:publicationDate")) != null) {
            record.addValue("issued", (Value)new StringValue(issued));
        }
        if ((ncid = XMLUtils.getElementValue(description_ja, "cinii:ncid")) != null) {
            record.addValue("ncid", (Value)new StringValue(ncid));
        }
        if ((naid = XMLUtils.getElementValue(description_ja, "cinii:naid")) != null) {
            record.addValue("naid", (Value)new StringValue(naid));
        }
        return record;
    }

    private static List<Value> getAuthors(Element element) {
        LinkedList<Value> authors = new LinkedList<Value>();
        List<String> authorList = XMLUtils.getElementValueList(element, "dc:creator");
        if (authorList != null && authorList.size() > 0) {
            for (String author : authorList) {
                int pos = author.indexOf(" ");
                if (pos > -1) {
                    author = author.substring(0, pos) + "," + author.substring(pos);
                }
                authors.add((Value)new StringValue(author));
            }
        }
        return authors;
    }

    private static List<Value> getSubjects(Element element) {
        LinkedList<Value> subjects = new LinkedList<Value>();
        List<Element> topicList = XMLUtils.getElementList(element, "foaf:topic");
        String attrValue = null;
        for (Element topic : topicList) {
            attrValue = topic.getAttribute("dc:title");
            if (!StringUtils.isNotBlank((String)attrValue)) continue;
            subjects.add((Value)new StringValue(attrValue.trim()));
        }
        return subjects;
    }
}

