/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionImpl;

public class VersionDAO {
    protected static final String TABLE_NAME = "versionitem";
    protected static final String VERSION_ID = "versionitem_id";
    protected static final String ITEM_ID = "item_id";
    protected static final String VERSION_NUMBER = "version_number";
    protected static final String EPERSON_ID = "eperson_id";
    protected static final String VERSION_DATE = "version_date";
    protected static final String VERSION_SUMMARY = "version_summary";
    protected static final String HISTORY_ID = "versionhistory_id";

    public VersionImpl find(Context context, int id) {
        try {
            TableRow row = DatabaseManager.findByUnique(context, TABLE_NAME, VERSION_ID, id);
            if (row == null) {
                return null;
            }
            return new VersionImpl(context, row);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public VersionImpl findByItem(Context c, Item item) {
        return this.findByItemId(c, item.getID());
    }

    public VersionImpl findByItemId(Context context, int itemId) {
        try {
            if (itemId == 0 || itemId == -1) {
                return null;
            }
            VersionImpl fromCache = (VersionImpl)context.fromCache(VersionImpl.class, itemId);
            if (fromCache != null) {
                return fromCache;
            }
            TableRow row = DatabaseManager.findByUnique(context, TABLE_NAME, ITEM_ID, itemId);
            if (row == null) {
                return null;
            }
            return new VersionImpl(context, row);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public List<Version> findByVersionHistory(Context context, int versionHistoryId) {
        try (TableRowIterator tri = null;){
            tri = DatabaseManager.query(context, "SELECT * FROM versionitem where versionhistory_id=" + versionHistoryId + " order by " + VERSION_NUMBER + " desc", new Object[0]);
            ArrayList<Version> versions = new ArrayList<Version>();
            while (tri.hasNext()) {
                TableRow tr = tri.next();
                VersionImpl fromCache = (VersionImpl)context.fromCache(VersionImpl.class, tr.getIntColumn(VERSION_ID));
                if (fromCache != null) {
                    versions.add(fromCache);
                    continue;
                }
                versions.add(new VersionImpl(context, tr));
            }
            ArrayList<Version> arrayList = versions;
            return arrayList;
        }
    }

    public VersionImpl create(Context context) {
        try {
            TableRow row = DatabaseManager.create(context, TABLE_NAME);
            VersionImpl v = new VersionImpl(context, row);
            return v;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void delete(Context c, int versionID) {
        try {
            VersionImpl version = this.find(c, versionID);
            if (version != null) {
                c.removeCached(version, version.getVersionId());
                DatabaseManager.delete(c, version.getMyRow());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void update(VersionImpl version) {
        try {
            DatabaseManager.update(version.getMyContext(), version.getMyRow());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

