/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.bulkedit.BulkEditChange;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.DSpaceCSVLine;
import org.dspace.app.bulkedit.MetadataImportException;
import org.dspace.app.bulkedit.MetadataImportInvalidHeadingException;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.AuthorityValueFinder;
import org.dspace.authority.AuthorityValueGenerator;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;
import org.dspace.workflow.WorkflowManager;
import org.dspace.xmlworkflow.XmlWorkflowManager;

public class MetadataImport {
    Context c;
    DSpaceCSV csv;
    List<DSpaceCSVLine> toImport;
    private static Set<String> authorityControlled;
    private static final String AC_PREFIX = "authority.controlled.";
    private static final Logger log;
    private AuthorityValueFinder authorityValueFinder = new AuthorityValueFinder();

    public MetadataImport(Context c, DSpaceCSV toImport) {
        this.c = c;
        this.csv = toImport;
        this.toImport = toImport.getCSVLines();
    }

    public List<BulkEditChange> runImport(boolean change, boolean useWorkflow, boolean workflowNotify, boolean useTemplate) throws MetadataImportException {
        ArrayList<BulkEditChange> changes = new ArrayList<BulkEditChange>();
        try {
            for (DSpaceCSVLine line : this.toImport) {
                Collection collection;
                int id = line.getID();
                if (this.csv.hasActions() && !"".equals(line.getAction()) && id == -1) {
                    throw new MetadataImportException("'action' not allowed for new items!");
                }
                if (id != -1) {
                    String action;
                    Item item = Item.find(this.c, id);
                    if (item == null) {
                        throw new MetadataImportException("Unknown item ID " + id);
                    }
                    BulkEditChange whatHasChanged = new BulkEditChange(item);
                    List<String> collections = line.get("collection");
                    if (collections != null) {
                        if (collections.size() == 0) {
                            throw new MetadataImportException("Missing collection from item " + item.getHandle());
                        }
                        Collection[] actualCollections = item.getCollections();
                        this.compare(item, collections, actualCollections, whatHasChanged, change);
                    }
                    for (String md : line.keys()) {
                        if ("id".equals(md)) continue;
                        Object[] fromCSV = line.get(md).toArray(new String[line.get(md).size()]);
                        if (!MetadataImport.isAuthorityControlledField(md)) {
                            for (int i = 0; i < fromCSV.length; ++i) {
                                int pos = ((String)fromCSV[i]).indexOf(DSpaceCSV.authoritySeparator);
                                if (pos <= -1) continue;
                                fromCSV[i] = ((String)fromCSV[i]).substring(0, pos);
                            }
                        }
                        this.compare(item, (String[])fromCSV, change, md, whatHasChanged, line);
                    }
                    if (this.csv.hasActions() && !"".equals(action = line.getAction())) {
                        if ("expunge".equals(action)) {
                            if (!ConfigurationManager.getBooleanProperty("bulkedit", "allowexpunge", false)) {
                                throw new MetadataImportException("'expunge' action denied by configuration");
                            }
                            Collection[] owners = item.getCollections();
                            for (Collection owner : owners) {
                                if (!change) continue;
                                owner.removeItem(item);
                            }
                            whatHasChanged.setDeleted();
                        } else if ("withdraw".equals(action)) {
                            if (!item.isWithdrawn()) {
                                if (change) {
                                    item.withdraw();
                                }
                                whatHasChanged.setWithdrawn();
                            }
                        } else if ("reinstate".equals(action)) {
                            if (item.isWithdrawn()) {
                                if (change) {
                                    item.reinstate();
                                }
                                whatHasChanged.setReinstated();
                            }
                        } else {
                            throw new MetadataImportException("Unknown action: " + action);
                        }
                    }
                    if (!whatHasChanged.hasChanges()) continue;
                    changes.add(whatHasChanged);
                    continue;
                }
                if (this.c.getCurrentUser() == null) {
                    throw new MetadataImportException("When adding new items, a user must be specified with the -e option");
                }
                BulkEditChange whatHasChanged = new BulkEditChange();
                for (String md : line.keys()) {
                    if ("id".equals(md)) continue;
                    String[] fromCSV = line.get(md).toArray(new String[line.get(md).size()]);
                    if (!MetadataImport.isAuthorityControlledField(md)) {
                        for (int i = 0; i < fromCSV.length; ++i) {
                            int pos = fromCSV[i].indexOf(DSpaceCSV.authoritySeparator);
                            if (pos <= -1) continue;
                            fromCSV[i] = fromCSV[i].substring(0, pos);
                        }
                    }
                    this.add(fromCSV, md, whatHasChanged);
                }
                List<String> collections = line.get("collection");
                if (collections == null) {
                    throw new MetadataImportException("New items must have a 'collection' assigned in the form of a handle");
                }
                ArrayList<Collection> check = new ArrayList<Collection>();
                for (String handle : collections) {
                    try {
                        collection = (Collection)HandleManager.resolveToObject(this.c, handle);
                        if (collection == null) {
                            throw new MetadataImportException("'" + handle + "' is not a Collection! You must specify a valid collection for new items");
                        }
                        if (check.contains(collection)) {
                            throw new MetadataImportException("Duplicate collection assignment detected in new item! " + handle);
                        }
                        check.add(collection);
                    }
                    catch (Exception ex) {
                        throw new MetadataImportException("'" + handle + "' is not a Collection! You must specify a valid collection for new items", ex);
                    }
                }
                boolean first = true;
                for (String handle : collections) {
                    Collection extra = (Collection)HandleManager.resolveToObject(this.c, handle);
                    if (first) {
                        whatHasChanged.setOwningCollection(extra);
                    } else {
                        whatHasChanged.registerNewMappedCollection(extra);
                    }
                    first = false;
                }
                if (change) {
                    String collectionHandle = line.get("collection").get(0);
                    collection = (Collection)HandleManager.resolveToObject(this.c, collectionHandle);
                    WorkspaceItem wsItem = WorkspaceItem.create(this.c, collection, useTemplate);
                    Item item = wsItem.getItem();
                    for (Metadatum dcv : whatHasChanged.getAdds()) {
                        item.addMetadata(dcv.schema, dcv.element, dcv.qualifier, dcv.language, dcv.value, dcv.authority, dcv.confidence);
                    }
                    if (useWorkflow) {
                        if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("xmlworkflow")) {
                            if (workflowNotify) {
                                XmlWorkflowManager.start(this.c, wsItem);
                            } else {
                                XmlWorkflowManager.startWithoutNotify(this.c, wsItem);
                            }
                        } else if (workflowNotify) {
                            WorkflowManager.start(this.c, wsItem);
                        } else {
                            WorkflowManager.startWithoutNotify(this.c, wsItem);
                        }
                    } else {
                        InstallItem.installItem(this.c, wsItem);
                    }
                    if (line.get("collection").size() > 0) {
                        for (int i = 1; i < collections.size(); ++i) {
                            String handle = collections.get(i);
                            Collection extra = (Collection)HandleManager.resolveToObject(this.c, handle);
                            extra.addItem(item);
                        }
                    }
                    this.c.commit();
                    whatHasChanged.setItem(item);
                }
                changes.add(whatHasChanged);
            }
        }
        catch (MetadataImportException mie) {
            throw mie;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return changes;
    }

    private void compare(Item item, String[] fromCSV, boolean change, String md, BulkEditChange changes, DSpaceCSVLine line) throws SQLException, AuthorizeException {
        String all = "";
        for (String part : fromCSV) {
            all = all + part + ",";
        }
        all = all.substring(0, all.length());
        log.debug((Object)LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + all));
        if ("collection".equals(md) || "action".equals(md)) {
            return;
        }
        String language = null;
        if (md.contains("[")) {
            String[] bits = md.split("\\[");
            language = bits[1].substring(0, bits[1].length() - 1);
        }
        AuthorityValue fromAuthority = MetadataImport.getAuthorityValueType(md);
        if (md.indexOf(58) > 0) {
            md = md.substring(md.indexOf(58) + 1);
        }
        String[] bits = md.split("\\.");
        String schema = bits[0];
        String element = bits[1];
        if (element.contains("[")) {
            element = element.substring(0, element.indexOf(91));
        }
        String qualifier = null;
        if (bits.length > 2 && (qualifier = bits[2]).contains("[")) {
            qualifier = qualifier.substring(0, qualifier.indexOf(91));
        }
        log.debug((Object)LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + all + ",looking_for_schema=" + schema + ",looking_for_element=" + element + ",looking_for_qualifier=" + qualifier + ",looking_for_language=" + language));
        String[] dcvalues = new String[]{};
        if (fromAuthority == null) {
            Metadatum[] current = item.getMetadata(schema, element, qualifier, language);
            dcvalues = new String[current.length];
            int i = 0;
            for (Metadatum dcv : current) {
                if (dcv.authority == null || !MetadataImport.isAuthorityControlledField(md)) {
                    dcvalues[i] = dcv.value;
                } else {
                    dcvalues[i] = dcv.value + DSpaceCSV.authoritySeparator + dcv.authority;
                    int n = i;
                    dcvalues[n] = dcvalues[n] + DSpaceCSV.authoritySeparator + (dcv.confidence != -1 ? dcv.confidence : 600);
                }
                ++i;
                log.debug((Object)LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + all + ",found=" + dcv.value));
            }
        } else {
            dcvalues = line.get(md).toArray(new String[line.get(md).size()]);
        }
        for (int v = 0; v < fromCSV.length; ++v) {
            String value = fromCSV[v];
            Metadatum dcv = this.getDcValueFromCSV(language, schema, element, qualifier, value, fromAuthority);
            if (fromAuthority != null) {
                fromCSV[v] = value = dcv.value + DSpaceCSV.authoritySeparator + dcv.authority + DSpaceCSV.authoritySeparator + dcv.confidence;
            }
            if (value != null && !"".equals(value) && !this.contains(value, dcvalues)) {
                changes.registerAdd(dcv);
                continue;
            }
            changes.registerConstant(dcv);
        }
        for (String value : dcvalues) {
            Metadatum dcv = new Metadatum();
            dcv.schema = schema;
            dcv.element = element;
            dcv.qualifier = qualifier;
            dcv.language = language;
            if (value == null || value.indexOf(DSpaceCSV.authoritySeparator) < 0) {
                this.simplyCopyValue(value, dcv);
            } else {
                String[] parts = value.split(DSpaceCSV.escapedAuthoritySeparator);
                dcv.value = parts[0];
                dcv.authority = parts[1];
                int n = dcv.confidence = parts.length > 2 ? Integer.valueOf(parts[2]) : 600;
            }
            if (value == null || "".equals(value) || this.contains(value, fromCSV) || fromAuthority != null) continue;
            log.debug((Object)LogManager.getHeader(this.c, "metadata_import", "item_id=" + item.getID() + ",fromCSV=" + all + ",removing_schema=" + schema + ",removing_element=" + element + ",removing_qualifier=" + qualifier + ",removing_language=" + language));
            changes.registerRemove(dcv);
        }
        if (change && (changes.getAdds().size() > 0 || changes.getRemoves().size() > 0)) {
            List<Metadatum> list = changes.getComplete();
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<String> authorities = new ArrayList<String>();
            ArrayList<Integer> confidences = new ArrayList<Integer>();
            for (Metadatum value : list) {
                if (qualifier == null && language == null) {
                    if (!schema.equals(value.schema) || !element.equals(value.element) || value.qualifier != null || value.language != null) continue;
                    values.add(value.value);
                    authorities.add(value.authority);
                    confidences.add(value.confidence);
                    continue;
                }
                if (qualifier == null) {
                    if (!schema.equals(value.schema) || !element.equals(value.element) || !language.equals(value.language) || value.qualifier != null) continue;
                    values.add(value.value);
                    authorities.add(value.authority);
                    confidences.add(value.confidence);
                    continue;
                }
                if (language == null) {
                    if (!schema.equals(value.schema) || !element.equals(value.element) || !qualifier.equals(value.qualifier) || value.language != null) continue;
                    values.add(value.value);
                    authorities.add(value.authority);
                    confidences.add(value.confidence);
                    continue;
                }
                if (!schema.equals(value.schema) || !element.equals(value.element) || !qualifier.equals(value.qualifier) || !language.equals(value.language)) continue;
                values.add(value.value);
                authorities.add(value.authority);
                confidences.add(value.confidence);
            }
            item.clearMetadata(schema, element, qualifier, language);
            String[] theValues = values.toArray(new String[values.size()]);
            String[] theAuthorities = authorities.toArray(new String[authorities.size()]);
            int[] theConfidences = new int[confidences.size()];
            for (int k = 0; k < confidences.size(); ++k) {
                theConfidences[k] = (Integer)confidences.get(k);
            }
            item.addMetadata(schema, element, qualifier, language, theValues, theAuthorities, theConfidences);
            item.update();
        }
    }

    private void compare(Item item, List<String> collections, Collection[] actualCollections, BulkEditChange bechange, boolean change) throws SQLException, AuthorizeException, IOException, MetadataImportException {
        String oldOwner = item.getOwningCollection().getHandle();
        String newOwner = collections.get(0);
        Collection newCollection = (Collection)HandleManager.resolveToObject(this.c, newOwner);
        if (newCollection == null) {
            throw new MetadataImportException("'" + newOwner + "' is not a Collection! You must specify a valid collection ID");
        }
        if (!oldOwner.equals(newOwner)) {
            bechange.changeOwningCollection(item.getOwningCollection(), (Collection)HandleManager.resolveToObject(this.c, newOwner));
        }
        boolean first = true;
        for (String csvcollection : collections) {
            if (!first) {
                boolean found = false;
                for (Collection collection : actualCollections) {
                    if (collection.getID() == item.getOwningCollection().getID() || !csvcollection.equals(collection.getHandle())) continue;
                    found = true;
                }
                DSpaceObject dso = HandleManager.resolveToObject(this.c, csvcollection);
                if (dso == null || dso.getType() != 3) {
                    throw new MetadataImportException("Collection defined for item " + item.getID() + " (" + item.getHandle() + ") is not a collection");
                }
                if (!found) {
                    Collection col = (Collection)dso;
                    bechange.registerNewMappedCollection(col);
                }
            }
            first = false;
        }
        for (Collection collection : actualCollections) {
            boolean found = false;
            first = true;
            for (String csvcollection : collections) {
                if (first && collection.getID() == item.getOwningCollection().getID()) {
                    found = true;
                } else if (!first && collection.getHandle().equals(csvcollection)) {
                    found = true;
                }
                first = false;
            }
            if (found) continue;
            bechange.registerOldMappedCollection(collection);
        }
        if (change) {
            for (Collection c : bechange.getOldMappedCollections()) {
                c.removeItem(item);
            }
            if (bechange.getNewOwningCollection() != null) {
                bechange.getNewOwningCollection().addItem(item);
                item.setOwningCollection(bechange.getNewOwningCollection());
                item.update();
            }
            if (bechange.getOldOwningCollection() != null) {
                boolean found = false;
                for (Collection c : item.getCollections()) {
                    if (c.getID() != bechange.getOldOwningCollection().getID()) continue;
                    found = true;
                }
                if (found) {
                    bechange.getOldOwningCollection().removeItem(item);
                }
            }
            for (Collection c : bechange.getNewMappedCollections()) {
                c.addItem(item);
            }
        }
    }

    private void add(String[] fromCSV, String md, BulkEditChange changes) throws SQLException, AuthorizeException {
        if ("collection".equals(md) || "action".equals(md)) {
            return;
        }
        String language = null;
        if (md.contains("[")) {
            String[] bits = md.split("\\[");
            language = bits[1].substring(0, bits[1].length() - 1);
        }
        AuthorityValue fromAuthority = MetadataImport.getAuthorityValueType(md);
        if (md.indexOf(58) > 0) {
            md = md.substring(md.indexOf(58) + 1);
        }
        String[] bits = md.split("\\.");
        String schema = bits[0];
        String element = bits[1];
        if (element.contains("[")) {
            element = element.substring(0, element.indexOf(91));
        }
        String qualifier = null;
        if (bits.length > 2 && (qualifier = bits[2]).contains("[")) {
            qualifier = qualifier.substring(0, qualifier.indexOf(91));
        }
        for (String value : fromCSV) {
            Metadatum dcv = this.getDcValueFromCSV(language, schema, element, qualifier, value, fromAuthority);
            if (fromAuthority != null) {
                value = dcv.value + DSpaceCSV.authoritySeparator + dcv.authority + DSpaceCSV.authoritySeparator + dcv.confidence;
            }
            if (value == null || "".equals(value)) continue;
            changes.registerAdd(dcv);
        }
    }

    public static AuthorityValue getAuthorityValueType(String md) {
        AuthorityValue fromAuthority = null;
        List<AuthorityValue> types = AuthorityValue.getAuthorityTypes().getTypes();
        for (AuthorityValue type : types) {
            if (!StringUtils.startsWithIgnoreCase((String)md, (String)type.getAuthorityType())) continue;
            fromAuthority = type;
        }
        return fromAuthority;
    }

    private Metadatum getDcValueFromCSV(String language, String schema, String element, String qualifier, String value, AuthorityValue fromAuthority) {
        Metadatum dcv = new Metadatum();
        dcv.schema = schema;
        dcv.element = element;
        dcv.qualifier = qualifier;
        dcv.language = language;
        if (fromAuthority != null) {
            if (value.indexOf(58) > 0) {
                value = value.substring(0, value.indexOf(58));
            }
            AuthorityValue example = fromAuthority.newInstance(value);
            List<AuthorityValue> byValue = this.authorityValueFinder.findByValue(this.c, schema, element, qualifier, example.getValue());
            AuthorityValue authorityValue = null;
            if (byValue.isEmpty()) {
                String toGenerate = fromAuthority.generateString() + value;
                String field = schema + "_" + element + (StringUtils.isNotBlank((String)qualifier) ? "_" + qualifier : "");
                authorityValue = AuthorityValueGenerator.generate(this.c, toGenerate, value, field);
                dcv.authority = toGenerate;
            } else {
                authorityValue = byValue.get(0);
                dcv.authority = authorityValue.getId();
            }
            dcv.value = authorityValue.getValue();
            dcv.confidence = 600;
        } else if (value == null || !value.contains(DSpaceCSV.authoritySeparator)) {
            this.simplyCopyValue(value, dcv);
        } else {
            String[] parts = value.split(DSpaceCSV.escapedAuthoritySeparator);
            dcv.value = parts[0];
            dcv.authority = parts[1];
            dcv.confidence = parts.length > 2 ? Integer.valueOf(parts[2]) : 600;
        }
        return dcv;
    }

    private void simplyCopyValue(String value, Metadatum dcv) {
        dcv.value = value;
        dcv.authority = null;
        dcv.confidence = -1;
    }

    private boolean contains(String needle, String[] haystack) {
        for (String examine : haystack) {
            if (!this.clean(examine).equals(this.clean(needle))) continue;
            return true;
        }
        return false;
    }

    private String clean(String in) {
        if (in == null) {
            return null;
        }
        return in.replaceAll("\r\n", "").replaceAll("\n", "").trim();
    }

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("MetatadataImport\n", options);
        System.out.println("\nmetadataimport: MetadataImport -f filename");
        System.exit(exitCode);
    }

    private static int displayChanges(List<BulkEditChange> changes, boolean changed) {
        int changeCounter = 0;
        for (BulkEditChange change : changes) {
            String md;
            String cName;
            String cHandle;
            List<Metadatum> adds = change.getAdds();
            List<Metadatum> removes = change.getRemoves();
            List<Collection> newCollections = change.getNewMappedCollections();
            List<Collection> oldCollections = change.getOldMappedCollections();
            if (adds.size() > 0 || removes.size() > 0 || newCollections.size() > 0 || oldCollections.size() > 0 || change.getNewOwningCollection() != null || change.getOldOwningCollection() != null || change.isDeleted() || change.isWithdrawn() || change.isReinstated()) {
                Item i = change.getItem();
                System.out.println("-----------------------------------------------------------");
                if (!change.isNewItem()) {
                    System.out.println("Changes for item: " + i.getID() + " (" + i.getHandle() + ")");
                } else {
                    System.out.print("New item: ");
                    if (i != null) {
                        if (i.getHandle() != null) {
                            System.out.print(i.getID() + " (" + i.getHandle() + ")");
                        } else {
                            System.out.print(i.getID() + " (in workflow)");
                        }
                    }
                    System.out.println();
                }
                ++changeCounter;
            }
            if (change.isDeleted()) {
                if (changed) {
                    System.out.println(" - EXPUNGED!");
                } else {
                    System.out.println(" - EXPUNGE!");
                }
            }
            if (change.isWithdrawn()) {
                if (changed) {
                    System.out.println(" - WITHDRAWN!");
                } else {
                    System.out.println(" - WITHDRAW!");
                }
            }
            if (change.isReinstated()) {
                if (changed) {
                    System.out.println(" - REINSTATED!");
                } else {
                    System.out.println(" - REINSTATE!");
                }
            }
            if (change.getNewOwningCollection() != null) {
                String cName2;
                String cHandle2;
                Collection c = change.getNewOwningCollection();
                if (c != null) {
                    cHandle2 = c.getHandle();
                    cName2 = c.getName();
                    if (!changed) {
                        System.out.print(" + New owning collection (" + cHandle2 + "): ");
                    } else {
                        System.out.print(" + New owning collection  (" + cHandle2 + "): ");
                    }
                    System.out.println(cName2);
                }
                if ((c = change.getOldOwningCollection()) != null) {
                    cHandle2 = c.getHandle();
                    cName2 = c.getName();
                    if (!changed) {
                        System.out.print(" + Old owning collection (" + cHandle2 + "): ");
                    } else {
                        System.out.print(" + Old owning collection  (" + cHandle2 + "): ");
                    }
                    System.out.println(cName2);
                }
            }
            for (Collection c : newCollections) {
                cHandle = c.getHandle();
                cName = c.getName();
                if (!changed) {
                    System.out.print(" + Map to collection (" + cHandle + "): ");
                } else {
                    System.out.print(" + Mapped to collection  (" + cHandle + "): ");
                }
                System.out.println(cName);
            }
            for (Collection c : oldCollections) {
                cHandle = c.getHandle();
                cName = c.getName();
                if (!changed) {
                    System.out.print(" + Un-map from collection (" + cHandle + "): ");
                } else {
                    System.out.print(" + Un-mapped from collection  (" + cHandle + "): ");
                }
                System.out.println(cName);
            }
            for (Metadatum dcv : adds) {
                md = dcv.schema + "." + dcv.element;
                if (dcv.qualifier != null) {
                    md = md + "." + dcv.qualifier;
                }
                if (dcv.language != null) {
                    md = md + "[" + dcv.language + "]";
                }
                if (!changed) {
                    System.out.print(" + Add    (" + md + "): ");
                } else {
                    System.out.print(" + Added   (" + md + "): ");
                }
                System.out.print(dcv.value);
                if (MetadataImport.isAuthorityControlledField(md)) {
                    System.out.print(", authority = " + dcv.authority);
                    System.out.print(", confidence = " + dcv.confidence);
                }
                System.out.println("");
            }
            for (Metadatum dcv : removes) {
                md = dcv.schema + "." + dcv.element;
                if (dcv.qualifier != null) {
                    md = md + "." + dcv.qualifier;
                }
                if (dcv.language != null) {
                    md = md + "[" + dcv.language + "]";
                }
                if (!changed) {
                    System.out.print(" - Remove (" + md + "): ");
                } else {
                    System.out.print(" - Removed (" + md + "): ");
                }
                System.out.print(dcv.value);
                if (MetadataImport.isAuthorityControlledField(md)) {
                    System.out.print(", authority = " + dcv.authority);
                    System.out.print(", confidence = " + dcv.confidence);
                }
                System.out.println("");
            }
        }
        return changeCounter;
    }

    private static boolean isAuthorityControlledField(String md) {
        String mdf = StringUtils.substringAfter((String)md, (String)":");
        mdf = StringUtils.substringBefore((String)mdf, (String)"[");
        return authorityControlled.contains(mdf);
    }

    private static void setAuthorizedMetadataFields() {
        authorityControlled = new HashSet<String>();
        Enumeration<?> propertyNames = ConfigurationManager.getProperties().propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = ((String)propertyNames.nextElement()).trim();
            if (!key.startsWith(AC_PREFIX) || !ConfigurationManager.getBooleanProperty(key, false)) continue;
            authorityControlled.add(key.substring(AC_PREFIX.length()));
        }
    }

    public static void main(String[] argv) {
        List<BulkEditChange> changes;
        MetadataImport importer;
        boolean change;
        Context c;
        boolean workflowNotify;
        boolean useWorkflow;
        boolean useTemplate;
        block32: {
            DSpaceCSV csv;
            CommandLine line;
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("f", "file", true, "source file");
            options.addOption("e", "email", true, "email address or user id of user (required if adding new items)");
            options.addOption("s", "silent", false, "silent operation - doesn't request confirmation of changes USE WITH CAUTION");
            options.addOption("w", "workflow", false, "workflow - when adding new items, use collection workflow");
            options.addOption("n", "notify", false, "notify - when adding new items using a workflow, send notification emails");
            options.addOption("t", "template", false, "template - when adding new items, use the collection template (if it exists)");
            options.addOption("h", "help", false, "help");
            try {
                line = parser.parse(options, argv);
            }
            catch (ParseException pe) {
                System.err.println("Error parsing command line arguments: " + pe.getMessage());
                System.exit(1);
                return;
            }
            if (line.hasOption('h')) {
                MetadataImport.printHelp(options, 0);
            }
            if (!line.hasOption('f')) {
                System.err.println("Required parameter -f missing!");
                MetadataImport.printHelp(options, 1);
            }
            String filename = line.getOptionValue('f');
            useTemplate = false;
            if (line.hasOption('t')) {
                useTemplate = true;
            }
            useWorkflow = false;
            workflowNotify = false;
            if (line.hasOption('w')) {
                useWorkflow = true;
                if (line.hasOption('n')) {
                    workflowNotify = true;
                }
            } else if (line.hasOption('n')) {
                System.err.println("Invalid option 'n': (notify) can only be specified with the 'w' (workflow) option.");
                System.exit(1);
            }
            try {
                c = new Context();
                c.turnOffAuthorisationSystem();
            }
            catch (Exception e) {
                System.err.println("Unable to create a new DSpace Context: " + e.getMessage());
                System.exit(1);
                return;
            }
            try {
                if (line.hasOption('e')) {
                    String e = line.getOptionValue('e');
                    EPerson eperson = e.indexOf(64) != -1 ? EPerson.findByEmail(c, e) : EPerson.find(c, Integer.parseInt(e));
                    if (eperson == null) {
                        System.out.println("Error, eperson cannot be found: " + e);
                        System.exit(1);
                    }
                    c.setCurrentUser(eperson);
                }
            }
            catch (Exception e) {
                System.err.println("Unable to find DSpace user: " + e.getMessage());
                System.exit(1);
                return;
            }
            change = false;
            try {
                csv = new DSpaceCSV(new File(filename), c);
            }
            catch (MetadataImportInvalidHeadingException miihe) {
                System.err.println(miihe.getMessage());
                System.exit(1);
                return;
            }
            catch (Exception e) {
                System.err.println("Error reading file: " + e.getMessage());
                System.exit(1);
                return;
            }
            importer = new MetadataImport(c, csv);
            if (!line.hasOption('s')) {
                try {
                    changes = importer.runImport(false, useWorkflow, workflowNotify, useTemplate);
                }
                catch (MetadataImportException mie) {
                    System.err.println("Error: " + mie.getMessage());
                    System.exit(1);
                    return;
                }
                int changeCounter = MetadataImport.displayChanges(changes, false);
                if (changeCounter > 0) {
                    try {
                        System.out.println("\n" + changeCounter + " item(s) will be changed\n");
                        System.out.print("Do you want to make these changes? [y/n] ");
                        String yn = new BufferedReader(new InputStreamReader(System.in)).readLine();
                        if ("y".equalsIgnoreCase(yn)) {
                            change = true;
                            break block32;
                        }
                        System.out.println("No data has been changed.");
                    }
                    catch (IOException ioe) {
                        System.err.println("Error: " + ioe.getMessage());
                        System.err.println("No changes have been made");
                        System.exit(1);
                    }
                } else {
                    System.out.println("There were no changes detected");
                }
            } else {
                change = true;
            }
        }
        try {
            if (change) {
                try {
                    changes = importer.runImport(true, useWorkflow, workflowNotify, useTemplate);
                }
                catch (MetadataImportException mie) {
                    System.err.println("Error: " + mie.getMessage());
                    System.exit(1);
                    return;
                }
                MetadataImport.displayChanges(changes, true);
                c.commit();
            }
            c.restoreAuthSystemState();
            c.complete();
        }
        catch (Exception e) {
            c.abort();
            System.err.println("Error committing changes to database: " + e.getMessage());
            System.err.println("Aborting most recent changes.");
            System.exit(1);
        }
    }

    static {
        MetadataImport.setAuthorizedMetadataFields();
        log = Logger.getLogger(MetadataImport.class);
    }
}

