/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemSubmitterStrategy;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;

public class RequestItemMetadataStrategy
extends RequestItemSubmitterStrategy {
    private String emailMetadata;
    private String fullNameMatadata;

    @Override
    public RequestItemAuthor getRequestItemAuthor(Context context, Item item) throws SQLException {
        Metadatum[] vals;
        if (this.emailMetadata != null && (vals = item.getMetadataByMetadataString(this.emailMetadata)).length > 0) {
            Metadatum[] nameVals;
            String email = vals[0].value;
            String fullname = null;
            if (this.fullNameMatadata != null && (nameVals = item.getMetadataByMetadataString(this.fullNameMatadata)).length > 0) {
                fullname = nameVals[0].value;
            }
            if (StringUtils.isBlank(fullname)) {
                fullname = I18nUtil.getMessage("org.dspace.app.requestitem.RequestItemMetadataStrategy.unnamed", context);
            }
            RequestItemAuthor author = new RequestItemAuthor(fullname, email);
            return author;
        }
        return super.getRequestItemAuthor(context, item);
    }

    public void setEmailMetadata(String emailMetadata) {
        this.emailMetadata = emailMetadata;
    }

    public void setFullNameMatadata(String fullNameMatadata) {
        this.fullNameMatadata = fullNameMatadata;
    }
}

