/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.BrowseItemDAO;
import org.dspace.content.Metadatum;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class BrowseItemDAOPostgres
implements BrowseItemDAO {
    private String findAll = "SELECT item_id, in_archive, withdrawn, discoverable FROM item WHERE in_archive = true OR withdrawn = true";
    private String getByMetadataElement = "SELECT authority, confidence, text_value,text_lang,element,qualifier FROM metadatavalue, metadatafieldregistry, metadataschemaregistry WHERE metadatavalue.resource_id = ?  AND metadatavalue.metadata_field_id = metadatafieldregistry.metadata_field_id  AND metadatafieldregistry.element = ?  AND metadatafieldregistry.qualifier IS NULL  AND metadatafieldregistry.metadata_schema_id=metadataschemaregistry.metadata_schema_id  AND metadataschemaregistry.short_id = ?  AND metadatavalue.resource_type_id = ?  ORDER BY metadatavalue.metadata_field_id, metadatavalue.place";
    private String getByMetadata = "SELECT authority, confidence, text_value,text_lang,element,qualifier FROM metadatavalue, metadatafieldregistry, metadataschemaregistry WHERE metadatavalue.resource_id = ?  AND metadatavalue.metadata_field_id = metadatafieldregistry.metadata_field_id  AND metadatafieldregistry.element = ?  AND metadatafieldregistry.qualifier = ?  AND metadatafieldregistry.metadata_schema_id=metadataschemaregistry.metadata_schema_id  AND metadataschemaregistry.short_id = ?  AND metadatavalue.resource_type_id = ?  ORDER BY metadatavalue.metadata_field_id, metadatavalue.place";
    private String getByMetadataAnyQualifier = "SELECT authority, confidence, text_value,text_lang,element,qualifier FROM metadatavalue, metadatafieldregistry, metadataschemaregistry WHERE metadatavalue.resource_id = ?  AND metadatavalue.metadata_field_id = metadatafieldregistry.metadata_field_id  AND metadatafieldregistry.element = ?  AND metadatafieldregistry.metadata_schema_id=metadataschemaregistry.metadata_schema_id  AND metadataschemaregistry.short_id = ?  AND metadatavalue.resource_type_id = ?  ORDER BY metadatavalue.metadata_field_id, metadatavalue.place";
    private Context context;

    public BrowseItemDAOPostgres(Context context) throws BrowseException {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrowseItem[] findAll() throws SQLException {
        ArrayList<BrowseItem> items = new ArrayList<BrowseItem>();
        try (TableRowIterator tri = null;){
            tri = DatabaseManager.query(this.context, this.findAll, new Object[0]);
            while (tri.hasNext()) {
                TableRow row = tri.next();
                items.add(new BrowseItem(this.context, row.getIntColumn("item_id"), row.getBooleanColumn("in_archive"), row.getBooleanColumn("withdrawn"), row.getBooleanColumn("discoverable")));
            }
        }
        BrowseItem[] bis = new BrowseItem[items.size()];
        return items.toArray(bis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metadatum[] queryMetadata(int itemId, String schema, String element, String qualifier, String lang) throws SQLException {
        ArrayList<Metadatum> values = new ArrayList<Metadatum>();
        try (TableRowIterator tri = null;){
            Object[] params;
            if (qualifier == null) {
                params = new Object[]{itemId, element, schema, 2};
                tri = DatabaseManager.query(this.context, this.getByMetadataElement, params);
            } else if ("*".equals(qualifier)) {
                params = new Object[]{itemId, element, schema, 2};
                tri = DatabaseManager.query(this.context, this.getByMetadataAnyQualifier, params);
            } else {
                params = new Object[]{itemId, element, qualifier, schema, 2};
                tri = DatabaseManager.query(this.context, this.getByMetadata, params);
            }
            if (!tri.hasNext()) {
                params = new Metadatum[]{};
                return params;
            }
            while (tri.hasNext()) {
                TableRow tr = tri.next();
                Metadatum dcv = new Metadatum();
                dcv.schema = schema;
                dcv.element = tr.getStringColumn("element");
                dcv.qualifier = tr.getStringColumn("qualifier");
                dcv.language = tr.getStringColumn("text_lang");
                dcv.value = tr.getStringColumn("text_value");
                dcv.authority = tr.getStringColumn("authority");
                dcv.confidence = tr.getIntColumn("confidence");
                values.add(dcv);
            }
        }
        Metadatum[] dcvs = new Metadatum[values.size()];
        return values.toArray(dcvs);
    }
}

