/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.Context;
import org.dspace.embargo.EmbargoManager;
import org.dspace.event.Event;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierService;
import org.dspace.utils.DSpace;

public class InstallItem {
    public static Item installItem(Context c, InProgressSubmission is) throws SQLException, IOException, AuthorizeException {
        return InstallItem.installItem(c, is, null);
    }

    public static Item installItem(Context c, InProgressSubmission is, String suppliedHandle) throws SQLException, IOException, AuthorizeException {
        Item item = is.getItem();
        Collection collection = is.getCollection();
        IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
        try {
            if (suppliedHandle == null) {
                identifierService.register(c, item);
            } else {
                identifierService.register(c, item, suppliedHandle);
            }
        }
        catch (IdentifierException e) {
            throw new RuntimeException("Can't create an Identifier!", e);
        }
        InstallItem.populateMetadata(c, item);
        item = InstallItem.finishItem(c, item, is);
        item.inheritCollectionDefaultPolicies(collection);
        return item;
    }

    public static Item restoreItem(Context c, InProgressSubmission is, String suppliedHandle) throws SQLException, IOException, AuthorizeException {
        Item item = is.getItem();
        IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
        try {
            if (suppliedHandle == null) {
                identifierService.register(c, item);
            } else {
                identifierService.register(c, item, suppliedHandle);
            }
        }
        catch (IdentifierException e) {
            throw new RuntimeException("Can't create an Identifier!");
        }
        DCDate now = DCDate.getCurrent();
        Metadatum[] dateAccessioned = item.getDC("date", "accessioned", "*");
        if (dateAccessioned.length == 0) {
            item.addDC("date", "accessioned", null, now.toString());
        }
        Metadatum[] currentDateIssued = item.getDC("date", "issued", "*");
        item.clearDC("date", "issued", "*");
        for (Metadatum dcv : currentDateIssued) {
            if (dcv.value != null && dcv.value.equalsIgnoreCase("today")) {
                DCDate issued = new DCDate(now.getYear(), now.getMonth(), now.getDay(), -1, -1, -1);
                item.addDC(dcv.element, dcv.qualifier, dcv.language, issued.toString());
                continue;
            }
            if (dcv.value == null) continue;
            item.addDC(dcv.element, dcv.qualifier, dcv.language, dcv.value);
        }
        String provDescription = "Restored into DSpace on " + now + " (GMT).";
        item.addDC("description", "provenance", "en", provDescription);
        return InstallItem.finishItem(c, item, is);
    }

    private static void populateMetadata(Context c, Item item) throws SQLException, IOException, AuthorizeException {
        String previousDateIssued;
        DCDate now = DCDate.getCurrent();
        item.addDC("date", "accessioned", null, now.toString());
        if (EmbargoManager.getEmbargoTermsAsDate(c, item) == null) {
            item.addDC("date", "available", null, now.toString());
        }
        Metadatum[] currentDateIssued = item.getDC("date", "issued", "*");
        item.clearDC("date", "issued", "*");
        for (Metadatum dcv : currentDateIssued) {
            if (dcv.value != null && dcv.value.equalsIgnoreCase("today")) {
                DCDate issued = new DCDate(now.getYear(), now.getMonth(), now.getDay(), -1, -1, -1);
                item.addDC(dcv.element, dcv.qualifier, dcv.language, issued.toString());
                continue;
            }
            if (dcv.value == null) continue;
            item.addDC(dcv.element, dcv.qualifier, dcv.language, dcv.value);
        }
        String provDescription = "Made available in DSpace on " + now + " (GMT). " + InstallItem.getBitstreamProvenanceMessage(item);
        if (currentDateIssued.length != 0 && (previousDateIssued = currentDateIssued[0].value) != null && !previousDateIssued.equalsIgnoreCase("today")) {
            DCDate d = new DCDate(previousDateIssued);
            provDescription = provDescription + "  Previous issue date: " + d.toString();
        }
        item.addDC("description", "provenance", "en", provDescription);
    }

    private static Item finishItem(Context c, Item item, InProgressSubmission is) throws SQLException, IOException, AuthorizeException {
        is.getCollection().addItem(item);
        item.setOwningCollection(is.getCollection());
        item.setArchived(true);
        item.update();
        c.addEvent(new Event(64, 2, item.getID(), item.getHandle(), item.getIdentifiers(c)));
        is.deleteWrapper();
        EmbargoManager.setEmbargo(c, item);
        return item;
    }

    public static String getBitstreamProvenanceMessage(Item myitem) throws SQLException {
        Bitstream[] bitstreams = myitem.getNonInternalBitstreams();
        StringBuilder myMessage = new StringBuilder();
        myMessage.append("No. of bitstreams: ").append(bitstreams.length).append("\n");
        for (int j = 0; j < bitstreams.length; ++j) {
            myMessage.append(bitstreams[j].getName()).append(": ").append(bitstreams[j].getSize()).append(" bytes, checksum: ").append(bitstreams[j].getChecksum()).append(" (").append(bitstreams[j].getChecksumAlgorithm()).append(")\n");
        }
        return myMessage.toString();
    }
}

