/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.OREDisseminationCrosswalk;
import org.dspace.core.Context;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;

public class OREIngestionCrosswalk
implements IngestionCrosswalk {
    private static Logger log = Logger.getLogger(OREDisseminationCrosswalk.class);
    public static final Namespace ATOM_NS = Namespace.getNamespace((String)"atom", (String)"http://www.w3.org/2005/Atom");
    private static final Namespace ORE_ATOM = Namespace.getNamespace((String)"oreatom", (String)"http://www.openarchives.org/ore/atom/");
    private static final Namespace ORE_NS = Namespace.getNamespace((String)"ore", (String)"http://www.openarchives.org/ore/terms/");
    private static final Namespace RDF_NS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    private static final Namespace DCTERMS_NS = Namespace.getNamespace((String)"dcterms", (String)"http://purl.org/dc/terms/");
    private static final Namespace DS_NS = Namespace.getNamespace((String)"ds", (String)"http://www.dspace.org/objectModel/");

    @Override
    public void ingest(Context context, DSpaceObject dso, List<Element> metadata) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (metadata.size() == 1) {
            this.ingest(context, dso, metadata.get(0));
        } else {
            Element wrapper = new Element("wrap", metadata.get(0).getNamespace());
            wrapper.addContent(metadata);
            this.ingest(context, dso, wrapper);
        }
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, Element root) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        String entryId;
        List aggregatedResources;
        Date timeStart = new Date();
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("OREIngestionCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        if (root == null) {
            System.err.println("The element received by ingest was null");
            return;
        }
        Document doc = new Document();
        doc.addContent(root.detach());
        try {
            XPath xpathLinks = XPath.newInstance((String)("/atom:entry/atom:link[@rel=\"" + ORE_NS.getURI() + "aggregates\"]"));
            xpathLinks.addNamespace(ATOM_NS);
            aggregatedResources = xpathLinks.selectNodes((Object)doc);
            xpathLinks = XPath.newInstance((String)"/atom:entry/atom:link[@rel='alternate']/@href");
            xpathLinks.addNamespace(ATOM_NS);
            entryId = ((Attribute)xpathLinks.selectSingleNode((Object)doc)).getValue();
        }
        catch (JDOMException e) {
            throw new CrosswalkException("JDOM exception occurred while ingesting the ORE", e);
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(4);
        for (Element resource : aggregatedResources) {
            Bundle targetBundle;
            String bundleName;
            String href = resource.getAttributeValue("href");
            log.debug((Object)("ORE processing: " + href));
            Element desc = null;
            try {
                XPath xpathDesc = XPath.newInstance((String)("/atom:entry/oreatom:triples/rdf:Description[@rdf:about=\"" + this.encodeForURL(href) + "\"][1]"));
                xpathDesc.addNamespace(ATOM_NS);
                xpathDesc.addNamespace(ORE_ATOM);
                xpathDesc.addNamespace(RDF_NS);
                desc = (Element)xpathDesc.selectSingleNode((Object)doc);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            if (desc != null && desc.getChild("type", RDF_NS).getAttributeValue("resource", RDF_NS).equals(DS_NS.getURI() + "DSpaceBitstream")) {
                bundleName = desc.getChildText("description", DCTERMS_NS);
                log.debug((Object)("Setting bundle name to: " + bundleName));
            } else {
                log.info((Object)"Could not obtain bundle name; using 'ORIGINAL'");
                bundleName = "ORIGINAL";
            }
            Bundle[] targetBundles = item.getBundles(bundleName);
            if (targetBundles.length == 0) {
                targetBundle = item.createBundle(bundleName);
                item.addBundle(targetBundle);
            } else {
                targetBundle = targetBundles[0];
            }
            URL ARurl = null;
            InputStream in = null;
            if (href != null) {
                try {
                    String processedURL = this.encodeForURL(href);
                    ARurl = new URL(processedURL);
                    in = ARurl.openStream();
                }
                catch (FileNotFoundException fe) {
                    log.error((Object)("The provided URI failed to return a resource: " + href));
                }
                catch (ConnectException fe) {
                    log.error((Object)("The provided URI was invalid: " + href));
                }
            } else {
                throw new CrosswalkException("Entry did not contain link to resource: " + entryId);
            }
            if (in != null) {
                Bitstream newBitstream = targetBundle.createBitstream(in);
                String bsName = resource.getAttributeValue("title");
                newBitstream.setName(bsName);
                String mimeString = resource.getAttributeValue("type");
                BitstreamFormat bsFormat = BitstreamFormat.findByMIMEType(context, mimeString);
                if (bsFormat == null) {
                    bsFormat = FormatIdentifier.guessFormat(context, newBitstream);
                }
                newBitstream.setFormat(bsFormat);
                newBitstream.update();
                targetBundle.addBitstream(newBitstream);
                targetBundle.update();
                continue;
            }
            throw new CrosswalkException("Could not retrieve bitstream: " + entryId);
        }
        log.info((Object)("OREIngest for Item " + item.getID() + " took: " + (new Date().getTime() - timeStart.getTime()) + "ms."));
    }

    private String encodeForURL(String sourceString) {
        Character[] lowalpha = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
        Character[] upalpha = new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')};
        Character[] digit = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')};
        Character[] mark = new Character[]{Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')')};
        Character[] reserved = new Character[]{Character.valueOf(';'), Character.valueOf('/'), Character.valueOf('?'), Character.valueOf(':'), Character.valueOf('@'), Character.valueOf('&'), Character.valueOf('='), Character.valueOf('+'), Character.valueOf('$'), Character.valueOf(','), Character.valueOf('%'), Character.valueOf('#')};
        HashSet<Character> URLcharsSet = new HashSet<Character>();
        URLcharsSet.addAll(Arrays.asList(lowalpha));
        URLcharsSet.addAll(Arrays.asList(upalpha));
        URLcharsSet.addAll(Arrays.asList(digit));
        URLcharsSet.addAll(Arrays.asList(mark));
        URLcharsSet.addAll(Arrays.asList(reserved));
        StringBuilder processedString = new StringBuilder();
        for (int i = 0; i < sourceString.length(); ++i) {
            char ch = sourceString.charAt(i);
            if (URLcharsSet.contains(Character.valueOf(ch))) {
                processedString.append(ch);
                continue;
            }
            processedString.append("%").append(Integer.toHexString(ch));
        }
        return processedString.toString();
    }
}

