/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao;

import java.sql.SQLException;
import org.dspace.content.Bitstream;
import org.dspace.content.MetadataField;
import org.dspace.content.dao.ItemDAO;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class ItemDAOOracle
extends ItemDAO {
    private final String SELECT_PRIMARY_BITSTREAM_ID;
    private final String SELECT_FIRST_BITSTREAM_ID;
    private final String SELECT_NAMED_BITSTREAM_ID;

    ItemDAOOracle(Context ctx) {
        super(ctx);
        int MD_FIELD_ID_NAME = -1;
        try {
            MD_FIELD_ID_NAME = MetadataField.findByElement(ctx, 1, "title", null).getFieldID();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.SELECT_PRIMARY_BITSTREAM_ID = "SELECT bundle.primary_bitstream_id FROM item2bundle  JOIN bundle USING (bundle_id)  JOIN metadatavalue MD1 ON (   MD1.resource_type_id = 1   AND MD1.resource_id = bundle_id   AND MD1.metadata_field_id = " + MD_FIELD_ID_NAME + "  ) WHERE item2bundle.item_id = ?  AND dbms_lob.compare(MD1.text_value, ?) = 0";
        this.SELECT_FIRST_BITSTREAM_ID = "SELECT bundle2bitstream.bitstream_id FROM item2bundle  JOIN bundle USING (bundle_id)  JOIN bundle2bitstream USING (bundle_id)  JOIN metadatavalue MD1 ON (   MD1.resource_type_id = 1   AND MD1.resource_id = bundle_id   AND MD1.metadata_field_id = " + MD_FIELD_ID_NAME + "  ) WHERE item2bundle.item_id = ?  AND dbms_lob.compare(MD1.text_value, ?) = 0";
        this.SELECT_NAMED_BITSTREAM_ID = "SELECT bitstream_id FROM item2bundle  JOIN bundle USING (bundle_id)  JOIN bundle2bitstream USING (bundle_id)  JOIN bitstream USING (bitstream_id)  JOIN metadatavalue MD1 ON (   MD1.resource_type_id = 1   AND MD1.resource_id = bundle_id   AND MD1.metadata_field_id = " + MD_FIELD_ID_NAME + "  )  JOIN metadatavalue MD2 ON (   MD2.resource_type_id = " + 0 + "   AND MD2.resource_id = bitstream_id   AND MD2.metadata_field_id = " + MD_FIELD_ID_NAME + "  ) WHERE item2bundle.item_id = ?  AND dbms_lob.compare(MD1.text_value, ?) = 0   AND dbms_lob.compare(MD2.text_value, ?) = 0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitstream getPrimaryBitstream(int itemId, String bundleName) throws SQLException {
        try (TableRowIterator tri = null;){
            tri = DatabaseManager.query(this.context, this.SELECT_PRIMARY_BITSTREAM_ID, itemId, bundleName);
            if (tri.hasNext()) {
                TableRow row = tri.next();
                int bid = row.getIntColumn("primary_bitstream_id");
                Bitstream bitstream = Bitstream.find(this.context, bid);
                return bitstream;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitstream getFirstBitstream(int itemId, String bundleName) throws SQLException {
        try (TableRowIterator tri = null;){
            tri = DatabaseManager.query(this.context, this.SELECT_FIRST_BITSTREAM_ID, itemId, bundleName);
            if (tri.hasNext()) {
                TableRow row = tri.next();
                int bid = row.getIntColumn("bitstream_id");
                Bitstream bitstream = Bitstream.find(this.context, bid);
                return bitstream;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitstream getNamedBitstream(int itemId, String bundleName, String fileName) throws SQLException {
        try (TableRowIterator tri = null;){
            tri = DatabaseManager.query(this.context, this.SELECT_NAMED_BITSTREAM_ID, itemId, bundleName, fileName);
            if (tri.hasNext()) {
                TableRow row = tri.next();
                int bid = row.getIntColumn("bitstream_id");
                Bitstream bitstream = Bitstream.find(this.context, bid);
                return bitstream;
            }
        }
        return null;
    }
}

