/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.AbstractMETSIngester;
import org.dspace.content.packager.METSManifest;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.jdom.Element;

public class DSpaceMETSIngester
extends AbstractMETSIngester {
    private static final String PROFILE_START = "DSpace METS SIP Profile";

    @Override
    void checkManifest(METSManifest manifest) throws MetadataValidationException {
        String profile = manifest.getProfile();
        if (profile == null) {
            throw new MetadataValidationException("Cannot accept METS with no PROFILE attribute!");
        }
        if (!profile.startsWith(PROFILE_START)) {
            throw new MetadataValidationException("METS has unacceptable PROFILE value, profile=" + profile);
        }
    }

    @Override
    public void crosswalkObjectDmd(Context context, DSpaceObject dso, METSManifest manifest, AbstractMETSIngester.MdrefManager callback, Element[] dmds, PackageParameters params) throws CrosswalkException, PackageValidationException, AuthorizeException, SQLException, IOException {
        int i;
        int found = -1;
        String userDmd = null;
        if (params != null) {
            userDmd = params.getProperty("dmd");
        }
        if (userDmd != null && userDmd.length() > 0) {
            for (i = 0; i < dmds.length; ++i) {
                if (!userDmd.equalsIgnoreCase(manifest.getMdType(dmds[i]))) continue;
                found = i;
            }
        }
        if (found == -1) {
            for (i = 0; i < dmds.length; ++i) {
                if (!"MODS".equalsIgnoreCase(manifest.getMdType(dmds[i]))) continue;
                found = i;
            }
        }
        if (found == -1) {
            for (i = 0; i < dmds.length; ++i) {
                if (!"DC".equalsIgnoreCase(manifest.getMdType(dmds[i]))) continue;
                found = i;
            }
        }
        String groupID = null;
        if (found >= 0) {
            manifest.crosswalkItemDmd(context, params, dso, dmds[found], callback);
            groupID = dmds[found].getAttributeValue("GROUPID");
            if (groupID != null) {
                for (int i2 = 0; i2 < dmds.length; ++i2) {
                    String g = dmds[i2].getAttributeValue("GROUPID");
                    if (g == null || g.equals(groupID)) continue;
                    manifest.crosswalkItemDmd(context, params, dso, dmds[i2], callback);
                }
            }
        } else if (dmds.length > 0) {
            manifest.crosswalkItemDmd(context, params, dso, dmds[0], callback);
        }
    }

    @Override
    public void addLicense(Context context, Item item, String license, Collection collection, PackageParameters params) throws PackageValidationException, AuthorizeException, SQLException, IOException {
        if (PackageUtils.findDepositLicense(context, item) == null) {
            PackageUtils.addDepositLicense(context, license, item, collection);
        }
    }

    @Override
    public void finishObject(Context context, DSpaceObject dso, PackageParameters params) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
    }

    @Override
    public int getObjectType(METSManifest manifest) throws PackageValidationException {
        return 2;
    }

    private String makeDerivedFilename(String bundleName, String origName) {
        String[] mfNames = PluginManager.getAllPluginNames(MediaFilter.class);
        for (int i = 0; i < mfNames.length; ++i) {
            MediaFilter mf = (MediaFilter)PluginManager.getNamedPlugin(MediaFilter.class, mfNames[i]);
            if (!bundleName.equals(mf.getBundleName())) continue;
            return mf.getFilteredName(origName);
        }
        return null;
    }

    @Override
    public void finishBitstream(Context context, Bitstream bs, Element mfile, METSManifest manifest, PackageParameters params) throws MetadataValidationException, SQLException, AuthorizeException, IOException {
        String newName;
        String opath;
        String bundleName = METSManifest.getBundleName(mfile);
        if (!bundleName.equals("ORIGINAL") && (opath = manifest.getOriginalFilePath(mfile)) != null && (newName = this.makeDerivedFilename(bundleName, opath)) != null) {
            bs.setName(newName);
            bs.update();
        }
    }

    @Override
    public String getConfigurationName() {
        return "dspaceSIP";
    }

    public boolean probe(Context context, InputStream in, PackageParameters params) {
        throw new UnsupportedOperationException("PDF package ingester does not implement probe()");
    }

    @Override
    public String getParameterHelp() {
        String parentHelp = super.getParameterHelp();
        return parentHelp + "\n\n* dmd=[dmdSecType]      Type of the METS <dmdSec> which should be used for primary item metadata (defaults to MODS, then DC)";
    }
}

