/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.disseminate;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;

public class CitationDocument {
    private static Logger log;
    private static final Set<String> VALID_TYPES;
    private static final Set<String> PDF_MIMES;
    private static final Set<String> RASTER_MIMES;
    private static final Set<String> SVG_MIMES;
    private static String citationEnabledCollections;
    private static String citationEnabledCommunities;
    private static ArrayList<String> citationEnabledCollectionsList;
    private static File tempDir;
    private static String[] header1;
    private static String[] header2;
    private static String[] fields;
    private static String footer;
    private static Boolean citationEnabledGlobally;
    private static Boolean citationAsFirstPage;

    private static boolean isCitationEnabledGlobally() {
        if (citationEnabledGlobally == null) {
            citationEnabledGlobally = ConfigurationManager.getBooleanProperty("disseminate-citation", "enable_globally", false);
        }
        return citationEnabledGlobally;
    }

    private static boolean isCitationEnabledThroughCollection(Bitstream bitstream) throws SQLException {
        if (citationEnabledCollectionsList.size() == 0) {
            return false;
        }
        DSpaceObject owningDSO = bitstream.getParentObject();
        if (owningDSO instanceof Item) {
            Collection[] collections;
            Item item = (Item)owningDSO;
            for (Collection collection : collections = item.getCollections()) {
                if (!citationEnabledCollectionsList.contains(collection.getHandle())) continue;
                return true;
            }
        }
        return false;
    }

    public static Boolean isCitationEnabledForBitstream(Bitstream bitstream, Context context) throws SQLException {
        boolean adminUser;
        if ((CitationDocument.isCitationEnabledGlobally() || CitationDocument.isCitationEnabledThroughCollection(bitstream)) && !(adminUser = AuthorizeManager.isAdmin(context)) && CitationDocument.canGenerateCitationVersion(bitstream)) {
            return true;
        }
        return false;
    }

    private static Boolean isCitationFirstPage() {
        if (citationAsFirstPage == null) {
            citationAsFirstPage = ConfigurationManager.getBooleanProperty("disseminate-citation", "citation_as_first_page", true);
        }
        return citationAsFirstPage;
    }

    public static boolean canGenerateCitationVersion(Bitstream bitstream) {
        return VALID_TYPES.contains(bitstream.getFormat().getMIMEType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File makeCitedDocument(Bitstream bitstream) throws IOException, SQLException, AuthorizeException, COSVisitorException {
        PDDocument document = new PDDocument();
        PDDocument sourceDocument = new PDDocument();
        try {
            Item item = (Item)bitstream.getParentObject();
            sourceDocument = PDDocument.load((InputStream)bitstream.retrieve());
            PDPage coverPage = new PDPage(PDPage.PAGE_SIZE_LETTER);
            this.generateCoverPage(document, coverPage, item);
            this.addCoverPageToDocument(document, sourceDocument, coverPage);
            document.save(tempDir.getAbsolutePath() + "/bitstream.cover.pdf");
            File file = new File(tempDir.getAbsolutePath() + "/bitstream.cover.pdf");
            return file;
        }
        finally {
            sourceDocument.close();
            document.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCoverPage(PDDocument document, PDPage coverPage, Item item) throws IOException, COSVisitorException {
        try (PDPageContentStream contentStream = new PDPageContentStream(document, coverPage);){
            int ypos = 760;
            int xpos = 30;
            int xwidth = 550;
            int ygap = 20;
            PDType1Font fontHelvetica = PDType1Font.HELVETICA;
            PDType1Font fontHelveticaBold = PDType1Font.HELVETICA_BOLD;
            PDType1Font fontHelveticaOblique = PDType1Font.HELVETICA_OBLIQUE;
            contentStream.setNonStrokingColor(Color.BLACK);
            String[][] content = new String[][]{header1};
            CitationDocument.drawTable(coverPage, contentStream, ypos, xpos, content, (PDFont)fontHelveticaBold, 11, false);
            String[][] content2 = new String[][]{header2};
            CitationDocument.drawTable(coverPage, contentStream, ypos -= ygap, xpos, content2, (PDFont)fontHelveticaBold, 11, false);
            contentStream.fillRect((float)xpos, (float)(ypos -= ygap), (float)xwidth, 1.0f);
            contentStream.closeAndStroke();
            String[][] content3 = new String[][]{{this.getOwningCommunity(item), this.getOwningCollection(item)}};
            CitationDocument.drawTable(coverPage, contentStream, ypos, xpos, content3, (PDFont)fontHelvetica, 9, false);
            contentStream.fillRect((float)xpos, (float)(ypos -= ygap), (float)xwidth, 1.0f);
            contentStream.closeAndStroke();
            ypos -= ygap * 2;
            for (String field : fields) {
                field = field.trim();
                PDType1Font font = fontHelvetica;
                int fontSize = 11;
                if (field.contains("title")) {
                    fontSize = 26;
                    ypos -= ygap;
                } else if (field.contains("creator") || field.contains("contributor")) {
                    fontSize = 16;
                }
                if (field.equals("_line_")) {
                    contentStream.fillRect((float)xpos, (float)ypos, (float)xwidth, 1.0f);
                    contentStream.closeAndStroke();
                    ypos -= ygap;
                } else if (StringUtils.isNotEmpty((String)item.getMetadata(field))) {
                    ypos = this.drawStringWordWrap(coverPage, contentStream, item.getMetadata(field), xpos, ypos, (PDFont)font, fontSize);
                }
                if (!field.contains("title")) continue;
                ypos -= ygap;
            }
            contentStream.beginText();
            contentStream.setFont((PDFont)fontHelveticaOblique, 11.0f);
            contentStream.moveTextPositionByAmount((float)xpos, (float)ypos);
            contentStream.drawString(footer);
            contentStream.endText();
        }
    }

    private void addCoverPageToDocument(PDDocument document, PDDocument sourceDocument, PDPage coverPage) {
        List sourcePageList = sourceDocument.getDocumentCatalog().getAllPages();
        if (CitationDocument.isCitationFirstPage().booleanValue()) {
            document.addPage(coverPage);
            for (PDPage sourcePage : sourcePageList) {
                document.addPage(sourcePage);
            }
        } else {
            for (PDPage sourcePage : sourcePageList) {
                document.addPage(sourcePage);
            }
            document.addPage(coverPage);
        }
        sourcePageList.clear();
    }

    public int drawStringWordWrap(PDPage page, PDPageContentStream contentStream, String text, int startX, int startY, PDFont pdfFont, float fontSize) throws IOException {
        float leading = 1.5f * fontSize;
        PDRectangle mediabox = page.findMediaBox();
        float margin = 72.0f;
        float width = mediabox.getWidth() - 2.0f * margin;
        ArrayList<String> lines = new ArrayList<String>();
        int lastSpace = -1;
        while (text.length() > 0) {
            int spaceIndex = text.indexOf(32, lastSpace + 1);
            if (spaceIndex < 0) {
                lines.add(text);
                text = "";
                continue;
            }
            String subString = text.substring(0, spaceIndex);
            float size = fontSize * pdfFont.getStringWidth(subString) / 1000.0f;
            if (size > width) {
                if (lastSpace < 0) {
                    lastSpace = spaceIndex;
                }
                subString = text.substring(0, lastSpace);
                lines.add(subString);
                text = text.substring(lastSpace).trim();
                lastSpace = -1;
                continue;
            }
            lastSpace = spaceIndex;
        }
        contentStream.beginText();
        contentStream.setFont(pdfFont, fontSize);
        contentStream.moveTextPositionByAmount((float)startX, (float)startY);
        int currentY = startY;
        for (String line : lines) {
            contentStream.drawString(line);
            currentY = (int)((float)currentY - leading);
            contentStream.moveTextPositionByAmount(0.0f, -leading);
        }
        contentStream.endText();
        return currentY;
    }

    public String getOwningCommunity(Item item) {
        try {
            Community[] comms = item.getCommunities();
            if (comms.length > 0) {
                return comms[0].getName();
            }
            return " ";
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            return e.getMessage();
        }
    }

    public String getOwningCollection(Item item) {
        try {
            return item.getOwningCollection().getName();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            return e.getMessage();
        }
    }

    public String getAllMetadataSeparated(Item item, String metadataKey) {
        Metadatum[] dcValues = item.getMetadataByMetadataString(metadataKey);
        ArrayList<String> valueArray = new ArrayList<String>();
        for (Metadatum dcValue : dcValues) {
            if (!StringUtils.isNotBlank((String)dcValue.value)) continue;
            valueArray.add(dcValue.value);
        }
        return StringUtils.join((Object[])valueArray.toArray(), (String)"; ");
    }

    public static void drawTable(PDPage page, PDPageContentStream contentStream, float y, float margin, String[][] content, PDFont font, int fontSize, boolean cellBorders) throws IOException {
        int i;
        int rows = content.length;
        int cols = content[0].length;
        float rowHeight = 20.0f;
        float tableWidth = page.findMediaBox().getWidth() - 2.0f * margin;
        float tableHeight = 20.0f * (float)rows;
        float colWidth = tableWidth / (float)cols;
        float cellMargin = 5.0f;
        if (cellBorders) {
            float nexty = y;
            for (int i2 = 0; i2 <= rows; ++i2) {
                contentStream.drawLine(margin, nexty, margin + tableWidth, nexty);
                nexty -= 20.0f;
            }
            float nextx = margin;
            for (i = 0; i <= cols; ++i) {
                contentStream.drawLine(nextx, y, nextx, y - tableHeight);
                nextx += colWidth;
            }
        }
        contentStream.setFont(font, (float)fontSize);
        float textx = margin + 5.0f;
        float texty = y - 15.0f;
        for (i = 0; i < content.length; ++i) {
            for (int j = 0; j < content[i].length; ++j) {
                String text = content[i][j];
                contentStream.beginText();
                contentStream.moveTextPositionByAmount(textx, texty);
                contentStream.drawString(text);
                contentStream.endText();
                textx += colWidth;
            }
            texty -= 20.0f;
            textx = margin + 5.0f;
        }
    }

    static {
        String header1Config;
        log = Logger.getLogger(CitationDocument.class);
        VALID_TYPES = new HashSet<String>(2);
        PDF_MIMES = new HashSet<String>(2);
        RASTER_MIMES = new HashSet<String>();
        SVG_MIMES = new HashSet<String>();
        citationEnabledCollections = null;
        citationEnabledCommunities = null;
        SVG_MIMES.add("image/jpeg");
        SVG_MIMES.add("image/pjpeg");
        SVG_MIMES.add("image/png");
        SVG_MIMES.add("image/gif");
        SVG_MIMES.add("image/svg");
        SVG_MIMES.add("image/svg+xml");
        PDF_MIMES.add("application/pdf");
        PDF_MIMES.add("application/x-pdf");
        VALID_TYPES.addAll(PDF_MIMES);
        citationEnabledCollections = ConfigurationManager.getProperty("disseminate-citation", "enabled_collections");
        citationEnabledCollectionsList = new ArrayList();
        if (citationEnabledCollections != null && citationEnabledCollections.length() > 0) {
            String[] collectionChunks;
            for (String collectionString : collectionChunks = citationEnabledCollections.split(",")) {
                citationEnabledCollectionsList.add(collectionString.trim());
            }
        }
        citationEnabledCommunities = ConfigurationManager.getProperty("disseminate-citation", "enabled_communities");
        if (citationEnabledCollectionsList == null) {
            citationEnabledCollectionsList = new ArrayList();
        }
        if (citationEnabledCommunities != null && citationEnabledCommunities.length() > 0) {
            try {
                String[] communityChunks;
                String[] stringArray = communityChunks = citationEnabledCommunities.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    Context context = new Context();
                    String communityString = stringArray[i];
                    DSpaceObject dsoCommunity = HandleManager.resolveToObject(context, communityString.trim());
                    if (dsoCommunity instanceof Community) {
                        Collection[] collections;
                        Community community = (Community)dsoCommunity;
                        for (Collection collection : collections = community.getAllCollections()) {
                            citationEnabledCollectionsList.add(collection.getHandle());
                        }
                        continue;
                    }
                    log.error((Object)("Invalid community for citation.enabled_communities, value:" + communityString.trim()));
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
            }
        }
        header1 = StringUtils.isNotBlank((String)(header1Config = ConfigurationManager.getProperty("disseminate-citation", "header1"))) ? header1Config.split(",") : new String[]{"DSpace Institution", ""};
        String header2Config = ConfigurationManager.getProperty("disseminate-citation", "header2");
        header2 = StringUtils.isNotBlank((String)header2Config) ? header2Config.split(",") : new String[]{"DSpace Repository", "http://dspace.org"};
        String fieldsConfig = ConfigurationManager.getProperty("disseminate-citation", "fields");
        fields = StringUtils.isNotBlank((String)fieldsConfig) ? fieldsConfig.split(",") : new String[]{"dc.date.issued", "dc.title", "dc.creator", "dc.contributor.author", "dc.publisher", "_line_", "dc.identifier.citation", "dc.identifier.uri"};
        String footerConfig = ConfigurationManager.getProperty("disseminate-citation", "footer");
        footer = StringUtils.isNotBlank((String)footerConfig) ? footerConfig : "Downloaded from DSpace Repository, DSpace Institution's institutional repository";
        String tempDirString = ConfigurationManager.getProperty("dspace.dir") + "/temp";
        tempDir = new File(tempDirString);
        if (!tempDir.exists()) {
            boolean success = tempDir.mkdir();
            if (success) {
                log.info((Object)("Created temp directory at: " + tempDirString));
            } else {
                log.info((Object)("Unable to create temp directory at: " + tempDirString));
            }
        }
        citationEnabledGlobally = null;
        citationAsFirstPage = null;
    }
}

