/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.core.Constants;
import org.dspace.rdf.conversion.RDFConverter;
import org.dspace.rdf.storage.RDFStorage;
import org.dspace.rdf.storage.URIGenerator;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;

public class RDFConfiguration {
    private static final Logger log = Logger.getLogger(RDFConfiguration.class);
    public static final String SPARQL_ENDPOINT_KEY = "rdf.public.sparql.endpoint";
    public static final String URIGENERATOR_KEY = "rdf.URIGenerator";
    public static final String RDFCONVERTER_KEY = "rdf.converter";
    public static final String CONVERTER_PLUGINS_KEY = "rdf.converter.plugins";
    public static final String CONVERTER_DSOTYPES_KEY = "rdf.converter.DSOtypes";
    public static final String RDFSTORAGE_KEY = "rdf.storage";
    public static final String STORAGE_GRAPHSTORE_ENDPOINT_KEY = "rdf.storage.graphstore.endpoint";
    public static final String STORAGE_GRAPHSTORE_AUTHENTICATION_KEY = "rdf.storage.graphstore.authentication";
    public static final String STORAGE_GRAPHSTORE_LOGIN_KEY = "rdf.storage.graphstore.login";
    public static final String STORAGE_GRAPHSTORE_PASSWORD_KEY = "rdf.storage.graphstore.password";
    public static final String STORAGE_SPARQL_ENDPOINT_KEY = "rdf.storage.sparql.endpoint";
    public static final String STORAGE_SPARQL_AUTHENTICATION_KEY = "rdf.storage.sparql.authentication";
    public static final String STORAGE_SPARQL_LOGIN_KEY = "rdf.storage.sparql.login";
    public static final String STORAGE_SPARQL_PASSWORD_KEY = "rdf.storage.sparql.password";
    public static final String CONTEXT_PATH_KEY = "rdf.contextPath";
    public static final String CONTENT_NEGOTIATION_KEY = "rdf.contentNegotiation.enable";
    private static URIGenerator generator;
    private static RDFStorage storage;
    private static RDFConverter converter;

    public static String[] getConverterPlugins() {
        return RDFConfiguration.loadConfigurationArray(CONVERTER_PLUGINS_KEY);
    }

    public static String[] getDSOTypesToConvert() {
        String dsoTypes = new DSpace().getConfigurationService().getProperty(CONVERTER_DSOTYPES_KEY);
        if (StringUtils.isEmpty((String)dsoTypes)) {
            log.warn((Object)"Property rdf.rdf.converter.DSOtypes was not found or is empty. Will convert all type of DSpace Objects.");
            return Constants.typeText;
        }
        return dsoTypes.split(",\\s*");
    }

    public static boolean isConvertType(int type) {
        for (String typeName : RDFConfiguration.getDSOTypesToConvert()) {
            if (Constants.getTypeID(typeName) != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isConvertType(String type) {
        for (String typeName : RDFConfiguration.getDSOTypesToConvert()) {
            if (!typeName.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContentNegotiationEnabled() {
        ConfigurationService configurationService = new DSpace().getConfigurationService();
        return (Boolean)configurationService.getPropertyAsType(CONTENT_NEGOTIATION_KEY, (Object)false);
    }

    public static String getPublicSparqlEndpointAddress() {
        ConfigurationService configurationService = new DSpace().getConfigurationService();
        return configurationService.getProperty(SPARQL_ENDPOINT_KEY);
    }

    public static String getInternalSparqlEndpointAddress() {
        ConfigurationService configurationService = new DSpace().getConfigurationService();
        String internalSparqlEndpoint = configurationService.getProperty(STORAGE_SPARQL_ENDPOINT_KEY);
        String externalSparqlEndpoint = configurationService.getProperty(SPARQL_ENDPOINT_KEY);
        return StringUtils.isEmpty((String)internalSparqlEndpoint) ? externalSparqlEndpoint : internalSparqlEndpoint;
    }

    public static String getDSpaceRDFModuleURI() {
        ConfigurationService configurationService = new DSpace().getConfigurationService();
        return configurationService.getProperty(CONTEXT_PATH_KEY);
    }

    protected static RDFConverter getRDFConverter() {
        if (converter == null) {
            ConfigurationService configurationService = new DSpace().getConfigurationService();
            converter = (RDFConverter)RDFConfiguration.initializeClass(configurationService, RDFCONVERTER_KEY, "RDFConverter");
        }
        return converter;
    }

    protected static URIGenerator getURIGenerator() {
        if (generator == null) {
            ConfigurationService configurationService = new DSpace().getConfigurationService();
            generator = (URIGenerator)RDFConfiguration.initializeClass(configurationService, URIGENERATOR_KEY, "URIGenerator");
        }
        return generator;
    }

    protected static RDFStorage getRDFStorage() {
        if (storage == null) {
            ConfigurationService configurationService = new DSpace().getConfigurationService();
            storage = (RDFStorage)RDFConfiguration.initializeClass(configurationService, RDFSTORAGE_KEY, "RDFStorage");
        }
        return storage;
    }

    public static String[] loadConfigurationArray(String key) {
        String value = new DSpace().getConfigurationService().getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return value.split(",\\s*");
    }

    private static Object initializeClass(ConfigurationService configurationService, String propertyName, String objectName) {
        String className = configurationService.getProperty(propertyName);
        if (StringUtils.isEmpty((String)className)) {
            log.error((Object)("Cannot load " + objectName + "! Property " + propertyName + " not found or empty!"));
            throw new RuntimeException("Cannot load " + objectName + ", property not found or not configured!");
        }
        Object instantiatedObject = null;
        try {
            Class<?> objectClass = Class.forName(className);
            instantiatedObject = objectClass.newInstance();
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)("Cannot find class '" + className + "' for " + objectName + ". Please check your configuration."), (Throwable)ex);
            throw new RuntimeException("Cannot find class for " + objectName + " (" + className + ").", ex);
        }
        catch (InstantiationException ex) {
            log.error((Object)("Cannot instantiate " + objectName + " (class " + className + ")."), (Throwable)ex);
            throw new RuntimeException("Cannot instantiate " + objectName + " (class " + className + ").", ex);
        }
        catch (IllegalAccessException ex) {
            log.error((Object)("IllegalAccessException thrown while instantiating the " + objectName + " (class " + className + ")."), (Throwable)ex);
            throw new RuntimeException("IllegalAccessException thrown while instantiating the " + objectName + " (class " + className + ").", ex);
        }
        return instantiatedObject;
    }
}

