/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.rdf.ItemNotArchivedException;
import org.dspace.rdf.ItemNotDiscoverableException;
import org.dspace.rdf.ItemWithdrawnException;
import org.dspace.rdf.RDFConfiguration;
import org.dspace.rdf.RDFMissingIdentifierException;
import org.dspace.rdf.RDFUtil;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;

public class RDFizer {
    private static final Logger log = Logger.getLogger(RDFizer.class);
    protected ConfigurationService configurationService = new DSpace().getConfigurationService();
    protected boolean stdout = false;
    protected boolean verbose = false;
    protected boolean dryrun = false;
    protected String lang = "TURTLE";
    protected Context context;
    protected Set<String> processed = new CopyOnWriteArraySet<String>();

    public RDFizer() throws SQLException {
        this.context = new Context(1);
    }

    protected void overrideContext(Context context) {
        this.context = context;
    }

    public boolean isStdout() {
        return this.stdout;
    }

    public void setStdout(boolean stdout) {
        this.stdout = stdout;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isDryrun() {
        return this.dryrun;
    }

    public void setDryrun(boolean dryrun) {
        this.dryrun = dryrun;
    }

    public void deleteAll() {
        this.report("Sending delete command to the triple store.");
        if (!this.dryrun) {
            RDFConfiguration.getRDFStorage().deleteAll();
        }
        this.report("Deleted all data from the triplestore.");
    }

    public void delete(DSpaceObject dso, boolean reset) throws SQLException {
        if (dso.getType() != 5 && dso.getType() != 4 && dso.getType() != 3 && dso.getType() != 2) {
            throw new IllegalArgumentException(dso.getTypeText() + " is currently not supported as independent entity.");
        }
        if (dso.getType() == 5) {
            this.deleteAll();
        }
        Callback callback = new Callback(){

            @Override
            protected void callback(DSpaceObject dso) throws SQLException {
                String identifier = RDFUtil.generateIdentifier(RDFizer.this.context, dso);
                if (StringUtils.isEmpty((CharSequence)identifier)) {
                    System.err.println("Cannot determine RDF URI for " + dso.getTypeText() + " " + dso.getID() + "(handle " + dso.getHandle() + "), skipping. Please delete it specifing the RDF URI.");
                    log.error((Object)("Cannot detgermine RDF URI for " + dso.getTypeText() + " " + dso.getID() + "(handle " + dso.getHandle() + "), skipping deletion."));
                    return;
                }
                RDFizer.this.report("Deleting Named Graph" + identifier);
                if (!RDFizer.this.dryrun) {
                    RDFConfiguration.getRDFStorage().delete(identifier);
                }
            }
        };
        this.dspaceDFS(dso, callback, false, reset);
    }

    public void convertAll() throws SQLException {
        this.report("Starting conversion of all DSpaceItems, this may take a while...");
        this.convert(new Site(), true);
        this.report("Conversion ended.");
    }

    protected void convert(DSpaceObject dso, boolean reset) throws SQLException {
        if (dso.getType() != 5 && dso.getType() != 4 && dso.getType() != 3 && dso.getType() != 2) {
            throw new IllegalArgumentException(dso.getTypeText() + " is currently not supported as independent entity.");
        }
        Callback callback = new Callback(){

            @Override
            protected void callback(DSpaceObject dso) throws SQLException {
                Model converted = null;
                try {
                    converted = RDFizer.this.dryrun ? RDFUtil.convert(RDFizer.this.context, dso) : RDFUtil.convertAndStore(RDFizer.this.context, dso);
                }
                catch (ItemNotArchivedException ex) {
                    if (!(dso instanceof Item)) {
                        throw new IllegalStateException(ex.getMessage(), ex);
                    }
                    RDFizer.this.report("Skipping conversion of Item " + dso.getID() + " (handle " + dso.getHandle() + "): Item is not archived.");
                    return;
                }
                catch (ItemWithdrawnException ex) {
                    if (!(dso instanceof Item)) {
                        throw new IllegalStateException(ex.getMessage(), ex);
                    }
                    RDFizer.this.report("Skipping conversion of Item " + dso.getID() + " (handle " + dso.getHandle() + "): Item is withdrawn.");
                    return;
                }
                catch (ItemNotDiscoverableException ex) {
                    if (!(dso instanceof Item)) {
                        throw new IllegalStateException(ex.getMessage(), ex);
                    }
                    RDFizer.this.report("Skipping conversion of Item " + dso.getID() + " (handle " + dso.getHandle() + "): Item is not discoverable.");
                    return;
                }
                catch (AuthorizeException ex) {
                    RDFizer.this.report("Skipping conversion of " + dso.getTypeText() + " " + dso.getID() + " (handle " + dso.getHandle() + "), not authorized: " + ex.getMessage());
                    return;
                }
                catch (RDFMissingIdentifierException ex) {
                    String errormessage = "Skipping conversion of " + dso.getTypeText() + " " + dso.getID() + " (handle " + dso.getHandle() + ").";
                    log.error((Object)errormessage, (Throwable)ex);
                    System.err.println(errormessage + " Error while converting: " + ex.getMessage());
                    return;
                }
                if (RDFizer.this.stdout) {
                    if (converted == null) {
                        System.err.println("Conversion of " + dso.getTypeText() + " " + dso.getID() + " resulted in no data.");
                    } else {
                        converted.write((OutputStream)System.out, RDFizer.this.lang);
                    }
                }
                if (converted != null) {
                    converted.close();
                }
            }
        };
        this.dspaceDFS(dso, callback, true, reset);
    }

    protected void dspaceDFS(DSpaceObject dso, Callback callback, boolean check, boolean reset) throws SQLException {
        if (dso.getType() != 5 && dso.getType() != 4 && dso.getType() != 3 && dso.getType() != 2) {
            throw new IllegalArgumentException(dso.getTypeText() + " is currently not supported as independent entity.");
        }
        if (reset) {
            this.processed.clear();
        }
        if (this.isProcessed(dso)) {
            log.debug((Object)("Skipping processing of " + dso.getTypeText() + " " + dso.getID() + " (handle " + dso.getHandle() + "), already processed."));
            return;
        }
        this.markProcessed(dso);
        if (check) {
            try {
                RDFUtil.isPublic(this.context, dso);
            }
            catch (ItemNotArchivedException ex) {
                if (!(dso instanceof Item)) {
                    throw new IllegalStateException(ex.getMessage(), ex);
                }
                this.report("Skipping processing of Item " + dso.getID() + " (handle " + dso.getHandle() + "): Item is not archived.");
                return;
            }
            catch (ItemWithdrawnException ex) {
                if (!(dso instanceof Item)) {
                    throw new IllegalStateException(ex.getMessage(), ex);
                }
                this.report("Skipping processing of Item " + dso.getID() + " (handle " + dso.getHandle() + "): Item is withdrawn.");
                return;
            }
            catch (ItemNotDiscoverableException ex) {
                if (!(dso instanceof Item)) {
                    throw new IllegalStateException(ex.getMessage(), ex);
                }
                this.report("Skipping processing of Item " + dso.getID() + " (handle " + dso.getHandle() + "): Item is not discoverable.");
                return;
            }
            catch (AuthorizeException ex) {
                this.report("Skipping processing of " + dso.getTypeText() + " " + dso.getID() + " (handle " + dso.getHandle() + "), not authorized: " + ex.getMessage());
                return;
            }
        }
        if (dso instanceof Site) {
            Community[] communities;
            for (Community community : communities = Community.findAllTop(this.context)) {
                this.dspaceDFS(community, callback, check, false);
            }
        }
        if (dso instanceof Community) {
            Collection[] collections;
            Community[] subcommunities = ((Community)dso).getSubcommunities();
            for (Community sub : subcommunities) {
                this.dspaceDFS(sub, callback, check, false);
            }
            for (Collection collection : collections = ((Community)dso).getCollections()) {
                this.dspaceDFS(collection, callback, check, false);
            }
        }
        if (dso instanceof Collection) {
            ItemIterator items = ((Collection)dso).getAllItems();
            while (items.hasNext()) {
                Item item = items.next();
                this.dspaceDFS(item, callback, check, false);
                item.decache();
            }
        }
        callback.callback(dso);
        this.report("Processed " + dso.getTypeText() + " " + dso.getID() + " (handle " + dso.getHandle() + ").");
    }

    protected boolean isProcessed(DSpaceObject dso) {
        String key = Integer.toString(dso.getType()) + "/" + Integer.toString(dso.getID());
        return this.processed.contains(key);
    }

    protected void markProcessed(DSpaceObject dso) {
        String key = Integer.toString(dso.getType()) + "/" + Integer.toString(dso.getID());
        this.processed.add(key);
    }

    protected void report(String message) {
        if (this.verbose) {
            System.err.println(message);
        }
        log.debug((Object)message);
    }

    protected void runCLI(String[] args) {
        String[] identifiers;
        Options options = this.createOptions();
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException ex) {
            RDFizer.usage(options);
            System.err.println();
            System.err.println(ex.getMessage());
            log.fatal((Object)ex);
            System.exit(1);
        }
        String[] remainingArgs = line.getArgs();
        if (remainingArgs.length > 0) {
            RDFizer.usage(options);
            System.err.println();
            StringBuilder builder = new StringBuilder(100);
            for (String argument : remainingArgs) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(argument);
            }
            String argumentsLine = builder.toString().trim();
            argumentsLine.substring(0, argumentsLine.length() - 1);
            System.err.print("Cannot recognize the following argument");
            if (remainingArgs.length >= 2) {
                System.err.print("s");
            }
            System.err.println(": " + argumentsLine + ".");
            System.exit(1);
        }
        if (line.hasOption("verbose")) {
            this.setVerbose(true);
        }
        if (line.hasOption("dry-run")) {
            this.setDryrun(true);
        }
        if (line.hasOption("stdout")) {
            this.setStdout(true);
        }
        if (line.hasOption("delete") && line.hasOption("delete-all")) {
            RDFizer.usage(options);
            System.err.println("\n\nYou cannot use the options --delete <handle> and --delete-all together.");
            System.exit(1);
        }
        if (line.hasOption("convert-all") && (line.hasOption("delete") || line.hasOption("delete-all"))) {
            RDFizer.usage(options);
            System.err.println("\n\nYou cannot use the option --convert-all together with --delete or --delete-all.");
            System.exit(1);
        }
        if (line.hasOption("identifiers") && (line.hasOption("delete") || line.hasOption("delete-all"))) {
            RDFizer.usage(options);
            System.err.println("\n\nYou cannot use the option --identifiers <handle> together with --delete or --delete-all.");
            System.exit(1);
        }
        if (line.hasOption("stdout") && (line.hasOption("delete") || line.hasOption("delete-all"))) {
            RDFizer.usage(options);
            System.err.println("\n\nYou cannot use the option --stdout together with --delete or --deleta-all.");
            System.exit(1);
        }
        if (line.hasOption('h')) {
            RDFizer.usage(options);
            System.exit(0);
        }
        if (line.hasOption("delete")) {
            identifiers = line.getOptionValues("delete");
            for (String identifier : identifiers) {
                if (!StringUtils.startsWithIgnoreCase((CharSequence)identifier, (CharSequence)"hdl:")) {
                    if (!this.dryrun) {
                        RDFConfiguration.getRDFStorage().delete(identifier);
                    }
                    if (!this.verbose) continue;
                    System.err.println("Deleted " + identifier + ".");
                    continue;
                }
                String handle = identifier.substring(4);
                log.debug((Object)("Trying to resolve identifier " + handle + "."));
                DSpaceObject dso = this.resolveHandle(handle);
                if (dso == null) continue;
                log.debug((Object)("Resolved identifier " + handle + " as " + dso.getTypeText() + " " + dso.getID()));
                try {
                    this.delete(dso, true);
                }
                catch (SQLException ex) {
                    log.error((Object)ex);
                    System.err.println("A problem with the database connection occurred. Canceled pending actions.");
                    System.err.println(ex.getMessage());
                    ex.printStackTrace(System.err);
                    System.exit(1);
                }
            }
            System.exit(0);
        }
        if (line.hasOption("delete-all")) {
            this.deleteAll();
            System.exit(0);
        }
        if (line.hasOption("identifiers")) {
            identifiers = line.getOptionValues("identifiers");
            this.report("Starting conversion of specified DSpaceObjects...");
            this.processed.clear();
            for (String handle : identifiers) {
                log.debug((Object)("Trying to resolve identifier " + handle + "."));
                DSpaceObject dso = this.resolveHandle(handle);
                if (dso == null) continue;
                try {
                    this.convert(dso, false);
                }
                catch (SQLException ex) {
                    log.error((Object)ex);
                    System.err.println("A problem with the database connection occurred. Canceled pending actions.");
                    System.err.println(ex.getMessage());
                    ex.printStackTrace(System.err);
                    System.exit(1);
                }
            }
            this.report("Conversion ended.");
            System.exit(0);
        }
        if (line.hasOption("convert-all")) {
            try {
                this.convertAll();
            }
            catch (SQLException ex) {
                log.error((Object)ex);
                System.err.println("A problem with the database connection occurred. Canceled pending actions.");
                System.err.println(ex.getMessage());
                ex.printStackTrace(System.err);
                System.exit(1);
            }
            System.exit(0);
        }
        RDFizer.usage(options);
        System.exit(0);
    }

    protected DSpaceObject resolveHandle(String handle) {
        DSpaceObject dso = null;
        try {
            dso = HandleManager.resolveToObject(this.context, handle);
        }
        catch (SQLException ex) {
            log.error((Object)ex);
            System.err.println("A problem with the database connection occurred. Canceled pending actions.");
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        catch (IllegalStateException ex) {
            log.error((Object)ex);
            System.err.println("Cannot recognize identifier '" + handle + "', skipping.");
            return null;
        }
        if (dso == null) {
            System.err.println("Cannot resolve identifier '" + handle + "', skipping.");
            log.debug((Object)("Couldn't resolve identifier '" + handle + "', dso was null."));
            return null;
        }
        if (dso.getType() != 5 && dso.getType() != 4 && dso.getType() != 3 && dso.getType() != 2) {
            System.err.println(dso.getTypeText() + " are currently not supported as independent entities. Bundles and Bitstreams should be processed as part of their item.");
            return null;
        }
        return dso;
    }

    protected Options createOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "Print usage information and exit.");
        options.addOption("v", "verbose", false, "Print verbose information to stderr while converting data.");
        options.addOption("n", "dry-run", false, "Don't store the converted data in the triple store, don't delete data from the triplestore. Make a dry run, simulation what would happen.");
        options.addOption("o", "stdout", false, "Print all converted data to stdout using turtle as serialization.");
        options.addOption("n", "dry-run", false, "Don't send any data or commands to the triplestore. Usefull for debugging or in conjunction with --stdout.");
        options.addOption("c", "convert-all", false, "Convert all DSpace Objects that are readable for an anonymous user. This may take a long timedepending on the number of stored communties, collections and items. Existing information in the triple store will be updated.");
        OptionBuilder.withLongOpt((String)"identifiers");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"handle");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withDescription((String)"Only convert these DSpace Objects. If you specify a Community or Collection all of their Items will be converted as well. Separate multiple identifiers with a space.");
        Option optIdentifiers = OptionBuilder.create((char)'i');
        options.addOption(optIdentifiers);
        OptionBuilder.withLongOpt((String)"delete");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"hdl:handle | URI");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withDescription((String)"Delete previously converted data. Specify either the handle of a DSpaceObject in the format 'hdl:<handle>' or the URI used to identify the rdf data in the triplestore. If you specify a Community, Collection or Item by its handle all converted information about attached Subcommunities, Collections, Items, Bundles and Bitstreams will be deleted as well. Separate multiple identifiers with a space.");
        Option optDelete = OptionBuilder.create();
        options.addOption(optDelete);
        OptionBuilder.withLongOpt((String)"delete-all");
        OptionBuilder.withDescription((String)"Delete all converted data from the triplestore.");
        Option optDeleteAll = OptionBuilder.create();
        options.addOption(optDeleteAll);
        return options;
    }

    protected static void usage(Options options) {
        String cliSyntax = "[dspace-bin]/bin/dspace rdfizer [OPTIONS...]";
        String header = "";
        String footer = "\nYou cannot use the options --convert-all, --identifiers or --stdout together with --delete or --delete-all.\nPlease use at least one option out of --convert-all, --delete, --delete-all or --identifiers.\n";
        PrintWriter err = new PrintWriter(System.err);
        HelpFormatter helpformater = new HelpFormatter();
        helpformater.printHelp(err, 79, cliSyntax, header, options, 2, 2, footer);
        err.flush();
    }

    public static void main(String[] args) {
        Context context = null;
        try {
            context = new Context(1);
        }
        catch (SQLException sqle) {
            log.info((Object)"Caught SQLException: ", (Throwable)sqle);
            System.err.println("Can't connect to database: " + sqle.getMessage());
            context.abort();
            System.exit(-1);
        }
        RDFizer myself = null;
        try {
            myself = new RDFizer();
        }
        catch (SQLException ex) {
            System.err.println("A problem with the database occurred: " + ex.getMessage());
            ex.printStackTrace(System.err);
            log.error((Object)ex);
            context.abort();
            System.exit(1);
        }
        myself.overrideContext(context);
        myself.runCLI(args);
        context.abort();
    }

    protected abstract class Callback {
        protected Callback() {
        }

        protected abstract void callback(DSpaceObject var1) throws SQLException;
    }
}

