/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.conversion;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.dspace.rdf.RDFConfiguration;
import org.dspace.rdf.RDFUtil;
import org.dspace.rdf.conversion.ConverterPlugin;
import org.dspace.services.ConfigurationService;

public class SimpleDSORelationsConverterPlugin
implements ConverterPlugin {
    public static final String SIMPLE_RELATIONS_PREFIXES_KEY = "rdf.simplerelations.prefixes";
    public static final String SIMPLE_RELATIONS_SITE2COMMUNITY_KEY = "rdf.simplerelations.site2community";
    public static final String SIMPLE_RELATIONS_COMMUNITY2SITE_KEY = "rdf.simplerelations.community2site";
    public static final String SIMPLE_RELATIONS_COMMUNITY2SUBCOMMUNITY_KEY = "rdf.simplerelations.community2subcommunity";
    public static final String SIMPLE_RELATIONS_SUBCOMMUNITY2COMMUNITY_KEY = "rdf.simplerelations.subcommunity2community";
    public static final String SIMPLE_RELATIONS_COMMUNITY2COLLECTION_KEY = "rdf.simplerelations.community2collection";
    public static final String SIMPLE_RELATIONS_COLLECTION2COMMUNITY_KEY = "rdf.simplerelations.collection2community";
    public static final String SIMPLE_RELATIONS_COLLECTION2ITEM_KEY = "rdf.simplerelations.collection2item";
    public static final String SIMPLE_RELATIONS_ITEM2COLLECTION_KEY = "rdf.simplerelations.item2collection";
    public static final String SIMPLE_RELATIONS_ITEM2BITSTREAM_KEY = "rdf.simplerelations.item2bitstream";
    private static final Logger log = Logger.getLogger(SimpleDSORelationsConverterPlugin.class);
    protected ConfigurationService configurationService;
    protected String[] site2community = RDFConfiguration.loadConfigurationArray("rdf.simplerelations.site2community");
    protected String[] community2site = RDFConfiguration.loadConfigurationArray("rdf.simplerelations.community2site");
    protected String[] community2subcommunity = RDFConfiguration.loadConfigurationArray("rdf.simplerelations.community2subcommunity");
    protected String[] subcommunity2community = RDFConfiguration.loadConfigurationArray("rdf.simplerelations.subcommunity2community");
    protected String[] community2collection = RDFConfiguration.loadConfigurationArray("rdf.simplerelations.community2collection");
    protected String[] collection2community = RDFConfiguration.loadConfigurationArray("rdf.simplerelations.collection2community");
    protected String[] collection2item = RDFConfiguration.loadConfigurationArray("rdf.simplerelations.collection2item");
    protected String[] item2collection = RDFConfiguration.loadConfigurationArray("rdf.simplerelations.item2collection");
    protected String[] item2bitstream = RDFConfiguration.loadConfigurationArray("rdf.simplerelations.item2bitstream");

    public SimpleDSORelationsConverterPlugin() {
        if (this.site2community == null) {
            log.warn((Object)"SimpleDSORelationsConverterPlugin was unable to load configuration to convert relation between the repository the repository (SITE) and the top communities.");
        }
        if (this.community2site == null) {
            log.warn((Object)"SimpleDSORelationsConverterPlugin was unable to load configuration to convert relation between the top communities and the repository (SITE).");
        }
        if (this.community2subcommunity == null) {
            log.warn((Object)"SimpleDSORelationsConverterPlugin was unable to load configuration to convert relation between communities and subcommunities.");
        }
        if (this.subcommunity2community == null) {
            log.warn((Object)"SimpleDSORelationsConverterPlugin was unable to load configuration to convert relation between subcommunities and communities.");
        }
        if (this.community2collection == null) {
            log.warn((Object)"SimpleDSORelationsConverterPlugin was unable to load configuration to convert relation between communities and collections.");
        }
        if (this.collection2community == null) {
            log.warn((Object)"SimpleDSORelationsConverterPlugin was unable to load configuration to convert relation between collections and communities.");
        }
        if (this.collection2item == null) {
            log.warn((Object)"SimpleDSORelationsConverterPlugin was unable to load configuration to convert relation between collections and items");
        }
        if (this.item2collection == null) {
            log.warn((Object)"SimpleDSORelationsConverterPlugin was unable to load configuration to convert relation between items and collections");
        }
        if (this.item2bitstream == null) {
            log.warn((Object)"SimpleDSORelationsConverterPlugin was unable to load configuration to convert relation between items and bitstreams.");
        }
    }

    protected Model getPrefixes() {
        Model m = ModelFactory.createDefaultModel();
        String prefixesPath = this.configurationService.getProperty(SIMPLE_RELATIONS_PREFIXES_KEY);
        if (!StringUtils.isEmpty((String)prefixesPath)) {
            InputStream is = FileManager.get().open(prefixesPath);
            if (is == null) {
                log.warn((Object)("Cannot find file '" + prefixesPath + "', ignoring..."));
            } else {
                m.read(is, null, FileUtils.guessLang((String)prefixesPath));
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            log.warn((Object)"Configuration does not contain path to prefixes file for SimpleDSORelationsConverterPlugin. Will proceed without prefixes.");
        }
        return m;
    }

    @Override
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public Model convert(Context context, DSpaceObject dso) throws SQLException {
        switch (dso.getType()) {
            case 5: {
                return this.convertSite(context, (Site)dso);
            }
            case 4: {
                return this.convertCommunity(context, (Community)dso);
            }
            case 3: {
                return this.convertCollection(context, (Collection)dso);
            }
            case 2: {
                return this.convertItem(context, (Item)dso);
            }
        }
        return null;
    }

    public Model convertSite(Context context, Site site) throws SQLException {
        Community[] topLevelCommies;
        if (this.site2community == null) {
            log.info((Object)"Either there was a problem loading the configuration or linking from the repository (SITE) to the top level communities is disabled. Won't link from the repostitory (SITE) to the top level communities.");
            return null;
        }
        Model m = ModelFactory.createDefaultModel();
        Model prefixes = this.getPrefixes();
        m.setNsPrefixes((PrefixMapping)prefixes);
        prefixes.close();
        String myId = RDFUtil.generateIdentifier(context, site);
        if (myId == null) {
            return null;
        }
        for (Community community : topLevelCommies = Community.findAllTop(context)) {
            String id;
            if (!RDFUtil.isPublicBoolean(context, community) || (id = RDFUtil.generateIdentifier(context, community)) == null) continue;
            for (String link : this.site2community) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        if (m.isEmpty()) {
            log.info((Object)"There were no public sub communities we could link to.");
            m.close();
            return null;
        }
        return m;
    }

    public Model convertCommunity(Context context, Community community) throws SQLException {
        String id;
        if (this.community2site == null) {
            log.info((Object)"Either there was a problem loading the configuration or linking from the top level communities to the repository (SITE) is disabled. Won't link from the top level communities to the repository (SITE).");
        }
        if (this.community2subcommunity == null) {
            log.info((Object)"Either there was a problem loading the configuration or linking from communities to subcommunities was disabled. Won't link from communities to subcommunities.");
        }
        if (this.subcommunity2community == null) {
            log.info((Object)"Either there was a problem loading the configuration or linking from subcommunities to communities was disabled. Won't link from subcommunities to communities.");
        }
        if (this.community2collection == null) {
            log.info((Object)"Either there was a problem loading the configuration or linking from communities to collections was disabled. Won't link from collections to subcommunities.");
        }
        if (this.community2site == null && this.community2subcommunity == null && this.subcommunity2community == null && this.community2collection == null) {
            return null;
        }
        Model m = ModelFactory.createDefaultModel();
        Model prefixes = this.getPrefixes();
        m.setNsPrefixes((PrefixMapping)prefixes);
        prefixes.close();
        String myId = RDFUtil.generateIdentifier(context, community);
        if (myId == null) {
            return null;
        }
        DSpaceObject[] parents = community.getAllParents();
        if (parents.length == 0) {
            parents = new DSpaceObject[]{Site.find(context, 0)};
        }
        for (Community community2 : parents) {
            if (!RDFUtil.isPublicBoolean(context, community2) || (id = RDFUtil.generateIdentifier(context, community2)) == null) continue;
            if (community2 instanceof Site) {
                for (String link : this.community2site) {
                    m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
                }
                continue;
            }
            if (!(community2 instanceof Community)) continue;
            for (String link : this.subcommunity2community) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        for (Community community3 : community.getSubcommunities()) {
            if (!RDFUtil.isPublicBoolean(context, community3) || (id = RDFUtil.generateIdentifier(context, community3)) == null) continue;
            for (String link : this.community2subcommunity) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        for (DSpaceObject dSpaceObject : community.getAllCollections()) {
            if (!RDFUtil.isPublicBoolean(context, dSpaceObject) || (id = RDFUtil.generateIdentifier(context, dSpaceObject)) == null) continue;
            for (String link : this.community2collection) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        if (m.isEmpty()) {
            m.close();
            return null;
        }
        return m;
    }

    public Model convertCollection(Context context, Collection collection) throws SQLException {
        Community[] parents;
        if (this.collection2community == null) {
            log.info((Object)"Either there was a problem loading the configuration or linking from collections to communities was disabled. Won't link from collections to communities.");
        }
        if (this.collection2item == null) {
            log.info((Object)"Either there was a problem loading the configuration or linking from collections to items was disabled. Won't link from collections to items.");
        }
        if (this.collection2community == null && this.collection2item == null) {
            return null;
        }
        Model m = ModelFactory.createDefaultModel();
        Model prefixes = this.getPrefixes();
        m.setNsPrefixes((PrefixMapping)prefixes);
        prefixes.close();
        String myId = RDFUtil.generateIdentifier(context, collection);
        if (myId == null) {
            return null;
        }
        for (Community parent : parents = collection.getCommunities()) {
            String id;
            if (!RDFUtil.isPublicBoolean(context, parent) || (id = RDFUtil.generateIdentifier(context, parent)) == null) continue;
            for (String link : this.collection2community) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        ItemIterator items = collection.getAllItems();
        while (items.hasNext()) {
            String id = RDFUtil.generateIdentifier(context, items.next());
            if (id == null) continue;
            for (String link : this.collection2item) {
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        if (m.isEmpty()) {
            m.close();
            return null;
        }
        return m;
    }

    public Model convertItem(Context context, Item item) throws SQLException {
        if (this.item2collection == null) {
            log.info((Object)"Either there was a problem loading the configuration or linking from items to collections was disabled. Won't link from items to collections.");
        }
        if (this.item2bitstream == null) {
            log.info((Object)"Either there was a problem loading the configuration or linking from items to bitstreams was disabled. Won't link from items to bitstreams.");
        }
        if (this.item2collection == null && this.item2bitstream == null) {
            return null;
        }
        Model m = ModelFactory.createDefaultModel();
        Model prefixes = this.getPrefixes();
        m.setNsPrefixes((PrefixMapping)prefixes);
        prefixes.close();
        String myId = RDFUtil.generateIdentifier(context, item);
        if (myId == null) {
            return null;
        }
        Collection[] collections = item.getCollections();
        for (Collection collection : collections) {
            String id;
            if (!RDFUtil.isPublicBoolean(context, collection) || (id = RDFUtil.generateIdentifier(context, collection)) == null) continue;
            String[] stringArray = this.item2collection;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String link = stringArray[i];
                m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(id));
            }
        }
        for (DSpaceObject dSpaceObject : item.getBundles()) {
            if (!((Bundle)dSpaceObject).getName().equals("ORIGINAL")) continue;
            for (Bitstream bs : ((Bundle)dSpaceObject).getBitstreams()) {
                String url;
                if (!RDFUtil.isPublicBoolean(context, bs) || (url = this.bitstreamURI(bs)) == null) continue;
                for (String link : this.item2bitstream) {
                    m.add(m.createResource(myId), m.createProperty(link), (RDFNode)m.createResource(url));
                }
            }
        }
        if (m.isEmpty()) {
            m.close();
            return null;
        }
        return m;
    }

    public String bitstreamURI(Bitstream bitstream) throws SQLException {
        DSpaceObject parent = bitstream.getParentObject();
        if (!(parent instanceof Item)) {
            return null;
        }
        String dspaceURL = this.configurationService.getProperty("dspace.url");
        String link = "";
        try {
            link = dspaceURL + "/bitstream/" + parent.getHandle() + "/" + bitstream.getSequenceID() + "/" + Util.encodeBitstreamName(bitstream.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("DSpace's default encoding is not supported.", ex);
        }
        return link;
    }

    @Override
    public boolean supports(int type) {
        switch (type) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }
}

