/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.io.File;
import java.sql.Connection;
import org.dspace.administer.MetadataImporter;
import org.dspace.administer.RegistryLoader;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseRegistryUpdater
implements FlywayCallback {
    private static final Logger log = LoggerFactory.getLogger(DatabaseRegistryUpdater.class);
    private boolean freshInstall = false;

    private void updateRegistries() {
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            String base = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "registries" + File.separator;
            log.info("Updating Bitstream Format Registry based on " + base + "bitstream-formats.xml");
            RegistryLoader.loadBitstreamFormats(context, base + "bitstream-formats.xml");
            log.info("Updating Metadata Registries based on metadata type configs in " + base);
            MetadataImporter.loadRegistry(base + "dublin-core-types.xml", true);
            MetadataImporter.loadRegistry(base + "dcterms-types.xml", true);
            MetadataImporter.loadRegistry(base + "eperson-types.xml", true);
            MetadataImporter.loadRegistry(base + "sword-metadata.xml", true);
            if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("xmlworkflow")) {
                MetadataImporter.loadRegistry(base + "workflow-types.xml", true);
            }
            context.restoreAuthSystemState();
            context.complete();
            log.info("All Bitstream Format Regitry and Metadata Registry updates were completed.");
        }
        catch (Exception e) {
            log.error("Error attempting to update Bitstream Format and/or Metadata Registries", (Throwable)e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public void afterClean(Connection connection) {
    }

    public void afterEachMigrate(Connection connection, MigrationInfo info) {
    }

    public void afterInfo(Connection connection) {
    }

    public void afterInit(Connection connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterMigrate(Connection connection) {
        if (this.freshInstall) {
            this.updateRegistries();
            this.freshInstall = false;
        }
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            Group.initDefaultGroupNames(context);
            context.restoreAuthSystemState();
            context.complete();
        }
        catch (Exception e) {
            log.error("Error attempting to add/update default DSpace Groups", (Throwable)e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public void afterRepair(Connection connection) {
    }

    public void afterValidate(Connection connection) {
    }

    public void beforeClean(Connection connection) {
    }

    public void beforeEachMigrate(Connection connection, MigrationInfo info) {
    }

    public void beforeInfo(Connection connection) {
    }

    public void beforeInit(Connection connection) {
    }

    public void beforeMigrate(Connection connection) {
        if (DatabaseUtils.tableExists(connection, "MetadataSchemaRegistry")) {
            this.updateRegistries();
        } else {
            this.freshInstall = true;
        }
    }

    public void beforeRepair(Connection connection) {
    }

    public void beforeValidate(Connection connection) {
    }
}

