/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemSubmitterStrategy;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;

public class RequestItemHelpdeskStrategy
extends RequestItemSubmitterStrategy {
    private static Logger log = Logger.getLogger(RequestItemHelpdeskStrategy.class);

    @Override
    public RequestItemAuthor getRequestItemAuthor(Context context, Item item) throws SQLException {
        boolean helpdeskOverridesSubmitter = ConfigurationManager.getBooleanProperty("request.item.helpdesk.override", false);
        String helpDeskEmail = ConfigurationManager.getProperty("mail.helpdesk");
        if (helpdeskOverridesSubmitter && StringUtils.isNotBlank((String)helpDeskEmail)) {
            return this.getHelpDeskPerson(context, helpDeskEmail);
        }
        return super.getRequestItemAuthor(context, item);
    }

    public RequestItemAuthor getHelpDeskPerson(Context context, String helpDeskEmail) throws SQLException {
        EPerson helpdeskEPerson = null;
        try {
            context.turnOffAuthorisationSystem();
            helpdeskEPerson = EPerson.findByEmail(context, helpDeskEmail);
            context.restoreAuthSystemState();
        }
        catch (AuthorizeException e) {
            log.error((Object)e.getMessage());
        }
        if (helpdeskEPerson != null) {
            return new RequestItemAuthor(helpdeskEPerson);
        }
        String helpdeskName = I18nUtil.getMessage("org.dspace.app.requestitem.RequestItemHelpdeskStrategy.helpdeskname", context);
        return new RequestItemAuthor(helpdeskName, helpDeskEmail);
    }
}

