/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class WorkspaceItem
implements InProgressSubmission {
    private static Logger log = Logger.getLogger(WorkspaceItem.class);
    private Item item;
    private Context ourContext;
    private TableRow wiRow;
    private Collection collection;

    WorkspaceItem(Context context, TableRow row) throws SQLException {
        this.ourContext = context;
        this.wiRow = row;
        this.item = Item.find(context, this.wiRow.getIntColumn("item_id"));
        this.collection = Collection.find(context, this.wiRow.getIntColumn("collection_id"));
        context.cache(this, row.getIntColumn("workspace_item_id"));
    }

    public static WorkspaceItem find(Context context, int id) throws SQLException {
        WorkspaceItem fromCache = (WorkspaceItem)context.fromCache(WorkspaceItem.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "workspaceitem", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_workspace_item", "not_found,workspace_item_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_workspace_item", "workspace_item_id=" + id));
        }
        return new WorkspaceItem(context, row);
    }

    public static WorkspaceItem create(Context c, Collection coll, boolean template) throws AuthorizeException, SQLException, IOException {
        AuthorizeManager.authorizeAction(c, coll, 3);
        Item i = Item.create(c);
        i.setSubmitter(c.getCurrentUser());
        Group step1group = coll.getWorkflowGroup(1);
        Group step2group = coll.getWorkflowGroup(2);
        Group step3group = coll.getWorkflowGroup(3);
        EPerson e = c.getCurrentUser();
        AuthorizeManager.addPolicy(c, (DSpaceObject)i, 0, e, ResourcePolicy.TYPE_SUBMISSION);
        if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("originalworkflow")) {
            if (step1group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 0, step1group, ResourcePolicy.TYPE_WORKFLOW);
            }
            if (step2group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 0, step2group, ResourcePolicy.TYPE_WORKFLOW);
            }
            if (step3group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 0, step3group, ResourcePolicy.TYPE_WORKFLOW);
            }
        }
        AuthorizeManager.addPolicy(c, (DSpaceObject)i, 1, e, ResourcePolicy.TYPE_SUBMISSION);
        if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("originalworkflow")) {
            if (step1group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 1, step1group, ResourcePolicy.TYPE_WORKFLOW);
            }
            if (step2group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 1, step2group, ResourcePolicy.TYPE_WORKFLOW);
            }
            if (step3group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 1, step3group, ResourcePolicy.TYPE_WORKFLOW);
            }
        }
        AuthorizeManager.addPolicy(c, (DSpaceObject)i, 3, e, ResourcePolicy.TYPE_SUBMISSION);
        if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("originalworkflow")) {
            if (step1group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 3, step1group, ResourcePolicy.TYPE_WORKFLOW);
            }
            if (step2group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 3, step2group, ResourcePolicy.TYPE_WORKFLOW);
            }
            if (step3group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 3, step3group, ResourcePolicy.TYPE_WORKFLOW);
            }
        }
        AuthorizeManager.addPolicy(c, (DSpaceObject)i, 4, e, ResourcePolicy.TYPE_SUBMISSION);
        if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("originalworkflow")) {
            if (step1group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 4, step1group, ResourcePolicy.TYPE_WORKFLOW);
            }
            if (step2group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 4, step2group, ResourcePolicy.TYPE_WORKFLOW);
            }
            if (step3group != null) {
                AuthorizeManager.addPolicy(c, (DSpaceObject)i, 4, step3group, ResourcePolicy.TYPE_WORKFLOW);
            }
        }
        Item templateItem = coll.getTemplateItem();
        if (template && templateItem != null) {
            Metadatum[] md = templateItem.getMetadata("*", "*", "*", "*");
            for (int n = 0; n < md.length; ++n) {
                i.addMetadata(md[n].schema, md[n].element, md[n].qualifier, md[n].language, md[n].value);
            }
        }
        i.update();
        TableRow row = DatabaseManager.row("workspaceitem");
        row.setColumn("item_id", i.getID());
        row.setColumn("collection_id", coll.getID());
        log.info((Object)LogManager.getHeader(c, "create_workspace_item", "workspace_item_id=" + row.getIntColumn("workspace_item_id") + "item_id=" + i.getID() + "collection_id=" + coll.getID()));
        DatabaseManager.insert(c, row);
        WorkspaceItem wi = new WorkspaceItem(c, row);
        return wi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkspaceItem[] findByEPerson(Context context, EPerson ep) throws SQLException {
        ArrayList<WorkspaceItem> wsItems = new ArrayList<WorkspaceItem>();
        try (TableRowIterator tri = DatabaseManager.queryTable(context, "workspaceitem", "SELECT workspaceitem.* FROM workspaceitem, item WHERE workspaceitem.item_id=item.item_id AND item.submitter_id= ? ORDER BY workspaceitem.workspace_item_id", ep.getID());){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                WorkspaceItem wi = (WorkspaceItem)context.fromCache(WorkspaceItem.class, row.getIntColumn("workspace_item_id"));
                if (wi == null) {
                    wi = new WorkspaceItem(context, row);
                }
                wsItems.add(wi);
            }
        }
        return wsItems.toArray(new WorkspaceItem[wsItems.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkspaceItem[] findByCollection(Context context, Collection c) throws SQLException {
        ArrayList<WorkspaceItem> wsItems = new ArrayList<WorkspaceItem>();
        try (TableRowIterator tri = DatabaseManager.queryTable(context, "workspaceitem", "SELECT workspaceitem.* FROM workspaceitem WHERE workspaceitem.collection_id= ? ", c.getID());){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                WorkspaceItem wi = (WorkspaceItem)context.fromCache(WorkspaceItem.class, row.getIntColumn("workspace_item_id"));
                if (wi == null) {
                    wi = new WorkspaceItem(context, row);
                }
                wsItems.add(wi);
            }
        }
        return wsItems.toArray(new WorkspaceItem[wsItems.size()]);
    }

    public static WorkspaceItem findByItem(Context context, Item i) throws SQLException {
        TableRow row = DatabaseManager.findByUnique(context, "workspaceitem", "item_id", i.getID());
        if (row == null) {
            return null;
        }
        return new WorkspaceItem(context, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkspaceItem[] findAll(Context context) throws SQLException {
        ArrayList<WorkspaceItem> wsItems = new ArrayList<WorkspaceItem>();
        String query = "SELECT * FROM workspaceitem ORDER BY item_id";
        try (TableRowIterator tri = DatabaseManager.queryTable(context, "workspaceitem", query, new Object[0]);){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                WorkspaceItem wi = (WorkspaceItem)context.fromCache(WorkspaceItem.class, row.getIntColumn("workspace_item_id"));
                if (wi == null) {
                    wi = new WorkspaceItem(context, row);
                }
                wsItems.add(wi);
            }
        }
        return wsItems.toArray(new WorkspaceItem[wsItems.size()]);
    }

    @Override
    public int getID() {
        return this.wiRow.getIntColumn("workspace_item_id");
    }

    public int getStageReached() {
        return this.wiRow.getIntColumn("stage_reached");
    }

    public void setStageReached(int v) {
        this.wiRow.setColumn("stage_reached", v);
    }

    public int getPageReached() {
        return this.wiRow.getIntColumn("page_reached");
    }

    public void setPageReached(int v) {
        this.wiRow.setColumn("page_reached", v);
    }

    @Override
    public void update() throws SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader(this.ourContext, "update_workspace_item", "workspace_item_id=" + this.getID()));
        this.item.update();
        DatabaseManager.update(this.ourContext, this.wiRow);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkspaceItem that = (WorkspaceItem)o;
        return this.getID() == that.getID();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getID()).toHashCode();
    }

    public void deleteAll() throws SQLException, AuthorizeException, IOException {
        if (!(AuthorizeManager.isAdmin(this.ourContext) || this.ourContext.getCurrentUser() != null && this.ourContext.getCurrentUser().getID() == this.item.getSubmitter().getID())) {
            throw new AuthorizeException("Must be an administrator or the original submitter to delete a workspace item");
        }
        log.info((Object)LogManager.getHeader(this.ourContext, "delete_workspace_item", "workspace_item_id=" + this.getID() + "item_id=" + this.item.getID() + "collection_id=" + this.collection.getID()));
        this.ourContext.removeCached(this, this.getID());
        this.deleteEpersonGroup2WorkspaceItem();
        DatabaseManager.delete(this.ourContext, this.wiRow);
        this.item.delete();
    }

    private void deleteEpersonGroup2WorkspaceItem() throws SQLException {
        String removeSQL = "DELETE FROM epersongroup2workspaceitem WHERE workspace_item_id = ?";
        DatabaseManager.updateQuery(this.ourContext, removeSQL, this.getID());
    }

    @Override
    public void deleteWrapper() throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this.item, 1);
        log.info((Object)LogManager.getHeader(this.ourContext, "delete_workspace_item", "workspace_item_id=" + this.getID() + "item_id=" + this.item.getID() + "collection_id=" + this.collection.getID()));
        this.ourContext.removeCached(this, this.getID());
        DatabaseManager.delete(this.ourContext, this.wiRow);
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public Collection getCollection() {
        return this.collection;
    }

    @Override
    public EPerson getSubmitter() throws SQLException {
        return this.item.getSubmitter();
    }

    @Override
    public boolean hasMultipleFiles() {
        return this.wiRow.getBooleanColumn("multiple_files");
    }

    @Override
    public void setMultipleFiles(boolean b) {
        this.wiRow.setColumn("multiple_files", b);
    }

    @Override
    public boolean hasMultipleTitles() {
        return this.wiRow.getBooleanColumn("multiple_titles");
    }

    @Override
    public void setMultipleTitles(boolean b) {
        this.wiRow.setColumn("multiple_titles", b);
    }

    @Override
    public boolean isPublishedBefore() {
        return this.wiRow.getBooleanColumn("published_before");
    }

    @Override
    public void setPublishedBefore(boolean b) {
        this.wiRow.setColumn("published_before", b);
    }
}

