/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.File;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.apache.tools.ant.taskdefs.Get;
import org.dspace.core.ConfigurationManager;
import org.dspace.statistics.SolrLogger;

public class StatisticsClient {
    private static final Logger log = Logger.getLogger(StatisticsClient.class);

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("StatisticsClient\n", options);
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("u", "update-spider-files", false, "Update Spider IP Files from internet into " + ConfigurationManager.getProperty("dspace.dir") + "/config/spiders");
        options.addOption("m", "mark-spiders", false, "Update isBot Flag in Solr");
        options.addOption("f", "delete-spiders-by-flag", false, "Delete Spiders in Solr By isBot Flag");
        options.addOption("i", "delete-spiders-by-ip", false, "Delete Spiders in Solr By IP Address");
        options.addOption("o", "optimize", false, "Run maintenance on the SOLR index");
        options.addOption("b", "reindex-bitstreams", false, "Reindex the bitstreams to ensure we have the bundle name");
        options.addOption("e", "export", false, "Export SOLR view statistics data to usage-statistics-intermediate-format");
        options.addOption("r", "remove-deleted-bitstreams", false, "While indexing the bundle names remove the statistics about deleted bitstreams");
        options.addOption("s", "shard-solr-index", false, "Split the data from the main Solr core into separate Solr cores per year");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, args);
        if (line.hasOption('h')) {
            StatisticsClient.printHelp(options, 0);
        }
        if (line.hasOption("u")) {
            StatisticsClient.updateSpiderFiles();
        } else if (line.hasOption('m')) {
            SolrLogger.markRobotsByIP();
        } else if (line.hasOption('f')) {
            SolrLogger.deleteRobotsByIsBotFlag();
        } else if (line.hasOption('i')) {
            SolrLogger.deleteRobotsByIP();
        } else if (line.hasOption('o')) {
            SolrLogger.optimizeSOLR();
        } else if (line.hasOption('b')) {
            SolrLogger.reindexBitstreamHits(line.hasOption('r'));
        } else if (line.hasOption('e')) {
            SolrLogger.exportHits();
        } else if (line.hasOption('s')) {
            SolrLogger.shardSolrIndex();
        } else {
            StatisticsClient.printHelp(options, 0);
        }
    }

    private static void updateSpiderFiles() {
        try {
            String[] values;
            File spiders;
            System.out.println("Downloading latest spider IP addresses:");
            String urls = ConfigurationManager.getProperty("solr-statistics", "spiderips.urls");
            if (urls == null || "".equals(urls)) {
                System.err.println(" - Missing setting from dspace.cfg: solr.spiderips.urls");
                System.exit(0);
            }
            if (!(spiders = new File(ConfigurationManager.getProperty("dspace.dir"), "config/spiders")).exists() && !spiders.mkdirs()) {
                log.error((Object)"Unable to create spiders directory");
            }
            for (String value : values = urls.split(",")) {
                value = value.trim();
                System.out.println(" Downloading: " + value);
                URL url = new URL(value);
                Get get = new Get();
                get.setDest(new File(spiders, url.getHost() + url.getPath().replace("/", "-")));
                get.setSrc(url);
                get.setUseTimestamp(true);
                get.execute();
            }
        }
        catch (Exception e) {
            System.err.println(" - Error: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

