/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import org.dspace.browse.IndexBrowse;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.search.DSIndexer;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseLegacyReindexer
implements FlywayCallback {
    private static final Logger log = LoggerFactory.getLogger(DatabaseLegacyReindexer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindex() {
        Context context = null;
        try {
            List<String> consumerList;
            context = new Context();
            String consumers = ConfigurationManager.getProperty("event.dispatcher.default.consumers");
            if (consumers == null) {
                consumers = "";
            }
            if ((consumerList = Arrays.asList(consumers.split("\\s*,\\s*"))).contains("discovery")) {
                // empty if block
            }
            if (consumerList.contains("search")) {
                log.info("Reindexing all content in Lucene search engine");
                DSIndexer.cleanIndex(context);
                DSIndexer.updateIndex(context, true);
                log.info("Reindexing is complete");
            }
            if (consumerList.contains("browse")) {
                log.info("Reindexing all content in DBMS Browse tables");
                IndexBrowse indexer = new IndexBrowse(context);
                indexer.setRebuild(true);
                indexer.setExecute(true);
                indexer.initBrowse();
                context.complete();
                log.info("Reindexing is complete");
            }
        }
        catch (Exception e) {
            log.error("Error attempting to reindex all contents for search/browse. You may need to manually reindex Lucene or DBMS", (Throwable)e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public void afterClean(Connection connection) {
    }

    public void afterEachMigrate(Connection connection, MigrationInfo info) {
    }

    public void afterInfo(Connection connection) {
    }

    public void afterInit(Connection connection) {
    }

    public void afterMigrate(Connection connection) {
        this.reindex();
    }

    public void afterRepair(Connection connection) {
        this.reindex();
    }

    public void afterValidate(Connection connection) {
    }

    public void beforeClean(Connection connection) {
    }

    public void beforeEachMigrate(Connection connection, MigrationInfo info) {
    }

    public void beforeInfo(Connection connection) {
    }

    public void beforeInit(Connection connection) {
    }

    public void beforeMigrate(Connection connection) {
    }

    public void beforeRepair(Connection connection) {
    }

    public void beforeValidate(Connection connection) {
    }
}

