/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.storage.rdbms.DatabaseLegacyReindexer;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.DatabaseRegistryUpdater;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.dbsupport.SqlScript;
import org.flywaydb.core.internal.info.MigrationInfoDumper;

public class DatabaseUtils {
    private static final Logger log = Logger.getLogger(DatabaseUtils.class);
    private static Flyway flywaydb;
    private static final String reindexDiscoveryFilePath;

    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.out.println("\nDatabase action argument is missing.");
            System.out.println("Valid actions: 'test', 'info', 'migrate', 'repair' or 'clean'");
            System.out.println("\nOr, type 'database help' for more information.\n");
            System.exit(1);
        }
        try {
            DataSource dataSource = DatabaseManager.initDataSource();
            String url = ConfigurationManager.getProperty("db.url");
            Flyway flyway = DatabaseUtils.setupFlyway(dataSource);
            if (argv[0].equalsIgnoreCase("test")) {
                System.out.println("\nAttempting to connect to database using these configurations: ");
                System.out.println(" - URL: " + url);
                System.out.println(" - Driver: " + ConfigurationManager.getProperty("db.driver"));
                System.out.println(" - Username: " + ConfigurationManager.getProperty("db.username"));
                System.out.println(" - Password: [hidden]");
                System.out.println(" - Schema: " + ConfigurationManager.getProperty("db.schema"));
                System.out.println("\nTesting connection...");
                try {
                    Connection connection = dataSource.getConnection();
                    connection.close();
                }
                catch (SQLException sqle) {
                    System.err.println("\nError: ");
                    System.err.println(" - " + sqle);
                    System.err.println("\nPlease see the DSpace documentation for assistance.\n");
                    System.exit(1);
                }
                System.out.println("Connected successfully!\n");
            } else if (argv[0].equalsIgnoreCase("info")) {
                Connection connection = dataSource.getConnection();
                DatabaseMetaData meta = connection.getMetaData();
                System.out.println("\nDatabase URL: " + url);
                System.out.println("Database Schema: " + DatabaseUtils.getSchemaName(connection));
                System.out.println("Database Software: " + meta.getDatabaseProductName() + " version " + meta.getDatabaseProductVersion());
                System.out.println("Database Driver: " + meta.getDriverName() + " version " + meta.getDriverVersion());
                System.out.println("\n" + MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])flyway.info().all()));
                if (!DatabaseUtils.tableExists(connection, flyway.getTable(), true)) {
                    System.out.println("\nNOTE: This database is NOT yet initialized for auto-migrations (via Flyway).");
                    String dbVersion = DatabaseUtils.determineDBVersion(connection);
                    if (dbVersion != null) {
                        System.out.println("\nYour database looks to be compatible with DSpace version " + dbVersion);
                        System.out.println("All upgrades *after* version " + dbVersion + " will be run during the next migration.");
                        System.out.println("\nIf you'd like to upgrade now, simply run 'dspace database migrate'.");
                    }
                }
                connection.close();
            } else if (argv[0].equalsIgnoreCase("migrate")) {
                System.out.println("\nDatabase URL: " + url);
                if (argv.length == 2) {
                    if (argv[1].equalsIgnoreCase("ignored")) {
                        System.out.println("Migrating database to latest version AND running previously \"Ignored\" migrations... (Check logs for details)");
                        Connection connection = dataSource.getConnection();
                        DatabaseUtils.updateDatabase(dataSource, connection, null, true);
                        connection.close();
                    } else {
                        System.out.println("Migrating database ONLY to version " + argv[1] + " ... (Check logs for details)");
                        System.out.println("\nWARNING: It is highly likely you will see errors in your logs when the Metadata");
                        System.out.println("or Bitstream Format Registry auto-update. This is because you are attempting to");
                        System.out.println("use an OLD version " + argv[1] + " Database with a newer DSpace API. NEVER do this in a");
                        System.out.println("PRODUCTION scenario. The resulting old DB is only useful for migration testing.\n");
                        Connection connection = dataSource.getConnection();
                        DatabaseUtils.updateDatabase(dataSource, connection, argv[1], false);
                        connection.close();
                    }
                } else {
                    System.out.println("Migrating database to latest version... (Check logs for details)");
                    DatabaseManager.getDbName();
                }
                System.out.println("Done.");
            } else if (argv[0].equalsIgnoreCase("repair")) {
                System.out.println("\nDatabase URL: " + url);
                System.out.println("Attempting to repair any previously failed migrations via FlywayDB... (Check logs for details)");
                flyway.repair();
                System.out.println("Done.");
            } else if (argv[0].equalsIgnoreCase("clean")) {
                BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                System.out.println("\nDatabase URL: " + url);
                System.out.println("\nWARNING: ALL DATA AND TABLES IN YOUR DATABASE WILL BE PERMANENTLY DELETED.\n");
                System.out.println("There is NO turning back from this action. Backup your DB before continuing.");
                System.out.println("If you are using Oracle, your RECYCLEBIN will also be PURGED.\n");
                System.out.print("Do you want to PERMANENTLY DELETE everything from your database? [y/n]: ");
                String choiceString = input.readLine();
                input.close();
                if (choiceString.equalsIgnoreCase("y")) {
                    System.out.println("Scrubbing database clean... (Check logs for details)");
                    DatabaseUtils.cleanDatabase(flyway, dataSource);
                    System.out.println("Done.");
                }
            } else {
                System.out.println("\nUsage: database [action]");
                System.out.println("Valid actions: 'test', 'info', 'migrate', 'repair' or 'clean'");
                System.out.println(" - test    = Test database connection is OK");
                System.out.println(" - info    = Describe basic info about database, including migrations run");
                System.out.println(" - migrate = Migrate the Database to the latest version");
                System.out.println("             Optionally, specify \"ignored\" to also run \"Ignored\" migrations");
                System.out.println(" - repair  = Attempt to repair any previously failed database migrations");
                System.out.println(" - clean   = DESTROY all data and tables in Database (WARNING there is no going back!)");
                System.out.println("");
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Caught exception:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static Flyway setupFlyway(DataSource datasource) {
        if (flywaydb == null) {
            try (Connection connection = datasource.getConnection();){
                flywaydb = new Flyway();
                flywaydb.setDataSource(datasource);
                flywaydb.setEncoding("UTF-8");
                DatabaseMetaData meta = connection.getMetaData();
                String dbType = DatabaseManager.findDbKeyword(meta);
                connection.close();
                ArrayList<String> scriptLocations = new ArrayList<String>();
                if (!dbType.equals("h2")) {
                    scriptLocations.add("filesystem:" + ConfigurationManager.getProperty("dspace.dir") + "/etc/" + dbType);
                }
                scriptLocations.add("classpath:org.dspace.storage.rdbms.sqlmigration." + dbType);
                scriptLocations.add("classpath:org.dspace.storage.rdbms.migration");
                if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("xmlworkflow")) {
                    scriptLocations.add("classpath:org.dspace.storage.rdbms.xmlworkflow");
                }
                log.info((Object)("Loading Flyway DB migrations from: " + StringUtils.join(scriptLocations, (String)", ")));
                flywaydb.setLocations(scriptLocations.toArray(new String[scriptLocations.size()]));
                flywaydb.setCallbacks(new FlywayCallback[]{new DatabaseRegistryUpdater(), new DatabaseLegacyReindexer()});
            }
            catch (SQLException e) {
                log.error((Object)"Unable to setup Flyway against DSpace database", (Throwable)e);
            }
        }
        return flywaydb;
    }

    protected static synchronized void updateDatabase(DataSource datasource, Connection connection) throws SQLException {
        DatabaseUtils.updateDatabase(datasource, connection, null, false);
    }

    protected static synchronized void updateDatabase(DataSource datasource, Connection connection, String targetVersion, boolean outOfOrder) throws SQLException {
        try {
            MigrationInfo[] pending;
            Flyway flyway = DatabaseUtils.setupFlyway(datasource);
            flyway.setOutOfOrder(outOfOrder);
            if (!StringUtils.isBlank((String)targetVersion)) {
                flyway.setTarget(targetVersion);
            }
            if (!DatabaseUtils.tableExists(connection, flyway.getTable(), true)) {
                String dbVersion = DatabaseUtils.determineDBVersion(connection);
                if (dbVersion == null) {
                    flyway.init();
                } else {
                    flyway.setInitVersion(dbVersion);
                    flyway.setInitDescription("Initializing from DSpace " + dbVersion + " database schema");
                    flyway.init();
                }
            }
            if ((pending = flyway.info().pending()) != null && pending.length > 0) {
                log.info((Object)"Pending DSpace database schema migrations:");
                for (MigrationInfo info : pending) {
                    log.info((Object)("\t" + info.getVersion() + " " + info.getDescription() + " " + info.getType() + " " + info.getState()));
                }
                flyway.migrate();
                DatabaseUtils.setReindexDiscovery(true);
            } else {
                log.info((Object)"DSpace database schema is up to date");
            }
        }
        catch (FlywayException fe) {
            throw new SQLException("Flyway migration error occurred", fe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void cleanDatabase(Flyway flyway, DataSource dataSource) throws SQLException {
        block10: {
            try {
                flyway.clean();
                Connection connection = null;
                try {
                    connection = dataSource.getConnection();
                    DatabaseMetaData meta = connection.getMetaData();
                    String dbKeyword = DatabaseManager.findDbKeyword(meta);
                    if (!dbKeyword.equals("oracle")) break block10;
                    PreparedStatement statement = null;
                    try {
                        statement = connection.prepareStatement("PURGE RECYCLEBIN");
                        statement.executeQuery();
                    }
                    finally {
                        if (statement != null && !statement.isClosed()) {
                            statement.close();
                        }
                    }
                }
                finally {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
            }
            catch (FlywayException fe) {
                throw new SQLException("Flyway clean error occurred", fe);
            }
        }
    }

    private static String determineDBVersion(Connection connection) throws SQLException {
        if (!DatabaseUtils.tableExists(connection, "Item")) {
            return null;
        }
        if (DatabaseUtils.tableColumnExists(connection, "metadatavalue", "resource_id")) {
            return "5.0.2014.09.26";
        }
        if (DatabaseUtils.tableColumnExists(connection, "requestitem", "request_message")) {
            return "5.0.2014.08.08";
        }
        if (DatabaseUtils.tableExists(connection, "Webapp")) {
            return "4.0";
        }
        if (DatabaseUtils.tableExists(connection, "versionitem")) {
            return "3.0";
        }
        if (DatabaseUtils.tableColumnExists(connection, "bundle2bitstream", "bitstream_order")) {
            return "1.8";
        }
        if (!DatabaseUtils.sequenceExists(connection, "dctyperegistry_seq")) {
            return "1.7";
        }
        if (DatabaseUtils.tableExists(connection, "harvested_collection")) {
            return "1.6";
        }
        if (DatabaseUtils.tableExists(connection, "collection_item_count")) {
            return "1.5";
        }
        if (DatabaseUtils.tableExists(connection, "Group2Group")) {
            return "1.4";
        }
        if (DatabaseUtils.tableExists(connection, "epersongroup2workspaceitem")) {
            return "1.3";
        }
        if (DatabaseUtils.tableExists(connection, "Community2Community")) {
            return "1.2";
        }
        if (DatabaseUtils.tableExists(connection, "Community")) {
            return "1.1";
        }
        throw new SQLException("CANNOT AUTOUPGRADE DSPACE DATABASE, AS IT DOES NOT LOOK TO BE A VALID DSPACE DATABASE.");
    }

    public static boolean tableExists(Connection connection, String tableName) {
        return DatabaseUtils.tableExists(connection, tableName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(Connection connection, String tableName, boolean caseSensitive) {
        boolean exists = false;
        ResultSet results = null;
        try {
            String schema = DatabaseUtils.getSchemaName(connection);
            DatabaseMetaData meta = connection.getMetaData();
            if (!caseSensitive) {
                schema = DatabaseUtils.canonicalize(connection, schema);
                tableName = DatabaseUtils.canonicalize(connection, tableName);
            }
            if ((results = meta.getTables(null, schema, tableName, null)) != null && results.next()) {
                exists = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)("Error attempting to determine if table " + tableName + " exists"), (Throwable)e);
        }
        finally {
            try {
                if (results != null && !results.isClosed()) {
                    results.close();
                }
            }
            catch (SQLException e) {}
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableColumnExists(Connection connection, String tableName, String columnName) {
        boolean exists = false;
        ResultSet results = null;
        try {
            String schema = DatabaseUtils.getSchemaName(connection);
            schema = DatabaseUtils.canonicalize(connection, schema);
            tableName = DatabaseUtils.canonicalize(connection, tableName);
            columnName = DatabaseUtils.canonicalize(connection, columnName);
            DatabaseMetaData meta = connection.getMetaData();
            results = meta.getColumns(null, schema, tableName, columnName);
            if (results != null && results.next()) {
                exists = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)("Error attempting to determine if column " + columnName + " exists"), (Throwable)e);
        }
        finally {
            try {
                if (results != null && !results.isClosed()) {
                    results.close();
                }
            }
            catch (SQLException e) {}
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sequenceExists(Connection connection, String sequenceName) {
        boolean exists = false;
        Statement statement = null;
        ResultSet results = null;
        boolean schemaFilter = false;
        try {
            String schema = DatabaseUtils.getSchemaName(connection);
            schema = DatabaseUtils.canonicalize(connection, schema);
            sequenceName = DatabaseUtils.canonicalize(connection, sequenceName);
            String dbtype = DatabaseManager.findDbKeyword(connection.getMetaData());
            String sequenceSQL = null;
            switch (dbtype) {
                case "postgres": {
                    if (schema == null) {
                        schema = "public";
                    }
                    sequenceSQL = "SELECT COUNT(1) FROM pg_class, pg_namespace WHERE pg_class.relnamespace=pg_namespace.oid AND pg_class.relkind='S' AND pg_class.relname=? AND pg_namespace.nspname=?";
                    schemaFilter = true;
                    break;
                }
                case "oracle": {
                    sequenceSQL = "SELECT COUNT(1) FROM user_sequences WHERE sequence_name=?";
                    break;
                }
                case "h2": {
                    sequenceSQL = "SELECT COUNT(1) FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_NAME = ?";
                    break;
                }
                default: {
                    throw new SQLException("DBMS " + dbtype + " is unsupported.");
                }
            }
            if (sequenceSQL != null) {
                statement = connection.prepareStatement(sequenceSQL);
                statement.setString(1, sequenceName);
                if (schemaFilter) {
                    statement.setString(2, schema);
                }
                if ((results = statement.executeQuery()) != null && results.next() && results.getInt(1) > 0) {
                    exists = true;
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)("Error attempting to determine if sequence " + sequenceName + " exists"), (Throwable)e);
        }
        finally {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
                if (results != null && !results.isClosed()) {
                    results.close();
                }
            }
            catch (SQLException e) {}
        }
        return exists;
    }

    public static void executeSql(Connection connection, String sqlToExecute) throws SQLException {
        try {
            DbSupport dbSupport = DbSupportFactory.createDbSupport((Connection)connection, (boolean)false);
            SqlScript script = new SqlScript(sqlToExecute, dbSupport);
            script.execute(dbSupport.getJdbcTemplate());
        }
        catch (FlywayException fe) {
            throw new SQLException("Flyway executeSql() error occurred", fe);
        }
    }

    public static String getSchemaName(Connection connection) throws SQLException {
        String schema = null;
        DatabaseMetaData meta = connection.getMetaData();
        schema = DatabaseManager.canonicalize(ConfigurationManager.getProperty("db.schema"));
        if (StringUtils.isBlank((String)schema)) {
            String dbType = DatabaseManager.findDbKeyword(meta);
            schema = dbType.equals("postgres") ? "public" : (dbType.equals("oracle") ? meta.getUserName() : null);
        }
        return schema;
    }

    public static String canonicalize(Connection connection, String dbIdentifier) throws SQLException {
        if (dbIdentifier == null) {
            return null;
        }
        DatabaseMetaData meta = connection.getMetaData();
        if (meta.storesLowerCaseIdentifiers()) {
            return StringUtils.lowerCase((String)dbIdentifier);
        }
        if (meta.storesUpperCaseIdentifiers()) {
            return StringUtils.upperCase((String)dbIdentifier);
        }
        return dbIdentifier;
    }

    public static synchronized void setReindexDiscovery(boolean reindex) {
        boolean deleted;
        File reindexFlag = new File(reindexDiscoveryFilePath);
        if (reindex) {
            try {
                if (!reindexFlag.exists()) {
                    reindexFlag.createNewFile();
                    reindexFlag.setWritable(true, false);
                }
            }
            catch (IOException io) {
                log.error((Object)("Unable to create Discovery reindex flag file " + reindexFlag.getAbsolutePath() + ". You may need to reindex manually."), (Throwable)io);
            }
        } else if (reindexFlag.exists() && !(deleted = reindexFlag.delete())) {
            log.error((Object)("Unable to delete Discovery reindex flag file " + reindexFlag.getAbsolutePath() + ". You may need to delete it manually."));
        }
    }

    public static boolean getReindexDiscovery() {
        File reindexFlag = new File(reindexDiscoveryFilePath);
        return reindexFlag.exists();
    }

    public static synchronized void checkReindexDiscovery(IndexingService indexer) {
        if (DatabaseUtils.getReindexDiscovery()) {
            ReindexerThread go = new ReindexerThread(indexer);
            go.start();
        }
    }

    static {
        reindexDiscoveryFilePath = ConfigurationManager.getProperty("dspace.dir") + File.separator + "solr" + File.separator + "search" + File.separator + "conf" + File.separator + "reindex.flag";
    }

    private static class ReindexerThread
    extends Thread {
        private final IndexingService indexer;

        ReindexerThread(IndexingService is) {
            this.indexer = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IndexingService indexingService = this.indexer;
            synchronized (indexingService) {
                if (DatabaseUtils.getReindexDiscovery()) {
                    Context context = null;
                    try {
                        context = new Context();
                        log.info((Object)"Post database migration, reindexing all content in Discovery search and browse engine");
                        this.indexer.cleanIndex(true);
                        this.indexer.createIndex(context);
                        this.indexer.buildSpellCheck();
                        log.info((Object)"Reindexing is complete");
                    }
                    catch (SearchServiceException sse) {
                        log.warn((Object)"Unable to reindex content in Discovery search and browse engine. You may need to reindex manually.", (Throwable)sse);
                    }
                    catch (IOException | SQLException e) {
                        log.error((Object)"Error attempting to reindex all contents for search/browse", (Throwable)e);
                    }
                    finally {
                        DatabaseUtils.setReindexDiscovery(false);
                        if (context != null && context.isValid()) {
                            context.abort();
                        }
                    }
                }
            }
        }
    }
}

