/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.xmlworkflow.WorkflowException;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.storedcomponents.WorkflowItemRole;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class SelectReviewerAction
extends ProcessingAction {
    public static final int MAIN_PAGE = 0;
    public static final int SEARCH_RESULTS_PAGE = 1;
    public static final int RESULTS_PER_PAGE = 5;
    private String roleId;

    @Override
    public void activate(Context c, XmlWorkflowItem wf) throws SQLException, IOException, AuthorizeException, WorkflowException {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException, WorkflowException {
        String submitButton = Util.getSubmitButton(request, "submit_cancel");
        if (submitButton.equals("submit_cancel")) {
            return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
        }
        if (submitButton.equals("submit_search")) {
            String query = request.getParameter("query");
            int page = Util.getIntParameter(request, "result-page");
            if (page == -1) {
                page = 0;
            }
            int resultCount = EPerson.searchResultCount(c, query);
            EPerson[] epeople = EPerson.search(c, query, page * 5, 5);
            request.setAttribute("eperson-result-count", (Object)resultCount);
            request.setAttribute("eperson-results", (Object)epeople);
            request.setAttribute("result-page", (Object)page);
            request.setAttribute("page", (Object)1);
            return new ActionResult(ActionResult.TYPE.TYPE_PAGE, 1);
        }
        if (submitButton.startsWith("submit_select_reviewer_")) {
            int reviewerId = Integer.parseInt(submitButton.substring(submitButton.lastIndexOf("_") + 1));
            EPerson reviewer = EPerson.find(c, reviewerId);
            WorkflowItemRole workflowItemRole = WorkflowItemRole.create(c);
            workflowItemRole.setEPerson(reviewer);
            workflowItemRole.setRoleId(this.getRoleId());
            workflowItemRole.setWorkflowItemId(wfi.getID());
            workflowItemRole.update();
            return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
        }
        return new ActionResult(ActionResult.TYPE.TYPE_ERROR);
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }
}

