/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sfx;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.content.DCPersonName;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SFXFileReader {
    private static Document doc;
    private static final Logger log;

    public static String loadSFXFile(String fileName, Item item) throws IOException {
        if (doc == null) {
            doc = SFXFileReader.parseFile(fileName);
        }
        return SFXFileReader.doNodes(doc, item);
    }

    public static Document parseFile(String fileName) {
        DocumentBuilder docBuilder;
        log.info((Object)("Parsing XML file... " + fileName));
        Document doc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Wrong parser configuration: " + e.getMessage()));
            return null;
        }
        File sourceFile = new File(fileName);
        try {
            doc = docBuilder.parse(sourceFile);
        }
        catch (SAXException e) {
            log.error((Object)("Wrong XML file structure: " + e.getMessage()));
            return null;
        }
        catch (IOException e) {
            log.error((Object)("Could not read source file: " + e.getMessage()));
        }
        log.info((Object)"XML file parsed");
        return doc;
    }

    public static String doNodes(Node node, Item item) throws IOException {
        if (node == null) {
            log.error((Object)" Empty Node ");
            return null;
        }
        Node e = SFXFileReader.getElement(node);
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        String sfxfield = "";
        int i = 0;
        while (i < len && StringUtils.isEmpty((String)sfxfield)) {
            Node nd = nl.item(i);
            if (nd == null || SFXFileReader.isEmptyTextNode(nd)) {
                ++i;
                continue;
            }
            String tagName = nd.getNodeName();
            if (tagName.equals("query-pairs")) {
                sfxfield = SFXFileReader.processFields(nd, item);
            }
            ++i;
        }
        log.info((Object)("Process fields : " + sfxfield));
        return sfxfield;
    }

    private static String processFields(Node e, Item item) throws IOException {
        NodeList cl = e.getChildNodes();
        int lench = cl.getLength();
        String myquery = "";
        for (int j = 0; j < lench; ++j) {
            Node nch = cl.item(j);
            String querystring = "";
            String schema = "";
            String qualifier = "";
            String element = "";
            if (!nch.getNodeName().equals("field")) continue;
            NodeList pl = nch.getChildNodes();
            int plen = pl.getLength();
            int finish = 0;
            for (int k = 0; k < plen; ++k) {
                Node vn = pl.item(k);
                String vName = vn.getNodeName();
                if (vName.equals("querystring")) {
                    querystring = SFXFileReader.getValue(vn);
                    ++finish;
                } else if (vName.equals("dc-schema")) {
                    schema = SFXFileReader.getValue(vn);
                    ++finish;
                } else if (vName.equals("dc-element")) {
                    element = SFXFileReader.getValue(vn);
                    ++finish;
                } else if (vName.equals("dc-qualifier")) {
                    qualifier = SFXFileReader.getValue(vn);
                    ++finish;
                    if (StringUtils.isEmpty((String)qualifier)) {
                        qualifier = null;
                    }
                }
                if (finish != 4) continue;
                Metadatum[] dcvalue = item.getMetadata(schema, element, qualifier, "*");
                if (dcvalue.length > 0) {
                    if (element.equals("date") && qualifier.equals("issued")) {
                        String fullDate = dcvalue[0].value;
                        if (fullDate.length() > 10) {
                            fullDate = fullDate.substring(0, 10);
                        }
                        myquery = myquery.equals("") ? querystring + URLEncoder.encode(fullDate, "UTF-8") : myquery + "&" + querystring + URLEncoder.encode(fullDate, "UTF-8");
                    } else if (element.equals("contributor") && qualifier.equals("author")) {
                        DCPersonName dpn = new DCPersonName(dcvalue[0].value);
                        String dpnName = dcvalue[0].value;
                        if (querystring.endsWith("aulast=")) {
                            dpnName = dpn.getLastName();
                        } else if (querystring.endsWith("aufirst=")) {
                            dpnName = dpn.getFirstNames();
                        }
                        myquery = myquery.equals("") ? querystring + URLEncoder.encode(dpnName, "UTF-8") : myquery + "&" + querystring + URLEncoder.encode(dpnName, "UTF-8");
                    } else {
                        myquery = myquery.equals("") ? querystring + URLEncoder.encode(dcvalue[0].value, "UTF-8") : myquery + "&" + querystring + URLEncoder.encode(dcvalue[0].value, "UTF-8");
                    }
                }
                finish = 0;
                querystring = "";
                schema = "";
                element = "";
                qualifier = "";
            }
        }
        return myquery;
    }

    public static Node getElement(Node node) {
        NodeList child = node.getChildNodes();
        int length = child.getLength();
        for (int i = 0; i < length; ++i) {
            Node kid = child.item(i);
            if (kid.getNodeType() != 1) continue;
            return kid;
        }
        return null;
    }

    public static boolean isEmptyTextNode(Node nd) {
        String text;
        boolean isEmpty = false;
        if (nd.getNodeType() == 3 && (text = nd.getNodeValue().trim()).length() == 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    public static String getAttribute(Node e, String name) {
        NamedNodeMap attrs = e.getAttributes();
        int len = attrs.getLength();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Node attr = attrs.item(i);
                if (!name.equals(attr.getNodeName())) continue;
                return attr.getNodeValue().trim();
            }
        }
        return null;
    }

    public static String getValue(Node node) {
        NodeList child = node.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            Node kid = child.item(i);
            short type = kid.getNodeType();
            if (type != 3) continue;
            return kid.getNodeValue().trim();
        }
        return null;
    }

    static {
        log = Logger.getLogger(SFXFileReader.class);
    }
}

