/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.beans.Introspector;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.dspace.app.util.AbstractDSpaceWebapp;
import org.dspace.core.ConfigurationManager;
import org.dspace.storage.rdbms.DatabaseManager;

public class DSpaceContextListener
implements ServletContextListener {
    private static Logger log = Logger.getLogger(DSpaceContextListener.class);
    public static final String DSPACE_CONFIG_PARAMETER = "dspace-config";
    private AbstractDSpaceWebapp webApp;

    public void contextInitialized(ServletContextEvent event) {
        try {
            String osName = System.getProperty("os.name");
            if (osName != null && osName.toLowerCase().contains("windows")) {
                URL url = new URL("http://localhost/");
                URLConnection urlConn = url.openConnection();
                urlConn.setDefaultUseCaches(false);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        String dspaceConfig = null;
        dspaceConfig = event.getServletContext().getInitParameter(DSPACE_CONFIG_PARAMETER);
        if (dspaceConfig == null || "".equals(dspaceConfig)) {
            throw new IllegalStateException("\n\nDSpace has failed to initialize. This has occurred because it was unable to determine \nwhere the dspace.cfg file is located. The path to the configuration file should be stored \nin a context variable, 'dspace-config', in the global context. \nNo context variable was found in either location.\n\n");
        }
        try {
            ConfigurationManager.loadConfig(dspaceConfig);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("\n\nDSpace has failed to initialize, during stage 2. Error while attempting to read the \nDSpace configuration file (Path: '" + dspaceConfig + "'). \n" + "This has likely occurred because either the file does not exist, or it's permissions \n" + "are set incorrectly, or the path to the configuration file is incorrect. The path to \n" + "the DSpace configuration file is stored in a context variable, 'dspace-config', in \n" + "either the local servlet or global context.\n\n", e);
        }
        try {
            Class<?> webappClass = Class.forName("org.dspace.utils.DSpaceWebapp");
            this.webApp = (AbstractDSpaceWebapp)webappClass.newInstance();
            this.webApp.register();
        }
        catch (ClassNotFoundException ex) {
            event.getServletContext().log("Can't create webapp MBean:  " + ex.getMessage());
        }
        catch (InstantiationException ex) {
            event.getServletContext().log("Can't create webapp MBean:  " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            event.getServletContext().log("Can't create webapp MBean:  " + ex.getMessage());
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.webApp.deregister();
        try {
            DatabaseManager.shutdown();
            Introspector.flushCaches();
            Enumeration<Driver> e = DriverManager.getDrivers();
            while (e.hasMoreElements()) {
                Driver driver = e.nextElement();
                if (driver.getClass().getClassLoader() != this.getClass().getClassLoader()) continue;
                DriverManager.deregisterDriver(driver);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Failed to cleanup ClassLoader for webapp", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Failed to cleanup ClassLoader for webapp", (Throwable)e);
        }
    }
}

