/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.AuthorityValueFinder;
import org.dspace.authority.AuthorityValueGenerator;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.Metadatum;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class UpdateAuthorities {
    private static Logger log = Logger.getLogger(UpdateAuthorities.class);
    protected PrintWriter print = new PrintWriter(System.out);
    private Context context;
    private List<String> selectedIDs;

    public UpdateAuthorities(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ParseException {
        Context c = null;
        try {
            c = new Context();
            UpdateAuthorities UpdateAuthorities2 = new UpdateAuthorities(c);
            if (UpdateAuthorities.processArgs(args, UpdateAuthorities2) == 0) {
                System.exit(0);
            }
            UpdateAuthorities2.run();
        }
        catch (SQLException e) {
            log.error((Object)"Error in UpdateAuthorities", (Throwable)e);
        }
        finally {
            if (c != null) {
                c.abort();
            }
        }
    }

    protected static int processArgs(String[] args, UpdateAuthorities UpdateAuthorities2) throws ParseException {
        PosixParser parser = new PosixParser();
        Options options = UpdateAuthorities.createCommandLineOptions();
        CommandLine line = parser.parse(options, args);
        HelpFormatter helpFormatter = new HelpFormatter();
        if (line.hasOption("h")) {
            helpFormatter.printHelp("dsrun " + UpdateAuthorities.class.getCanonicalName(), options);
            return 0;
        }
        if (line.hasOption("i")) {
            UpdateAuthorities2.setSelectedIDs(line.getOptionValue("i"));
        }
        UpdateAuthorities2.setPrint(new PrintWriter(System.out, true));
        return 1;
    }

    private void setSelectedIDs(String b) {
        String[] orcids;
        this.selectedIDs = new ArrayList<String>();
        for (String orcid : orcids = b.split(",")) {
            this.selectedIDs.add(orcid.trim());
        }
    }

    protected static Options createCommandLineOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "help");
        options.addOption("i", "id", true, "Import and/or update specific solr records with the given ids (comma-separated)");
        return options;
    }

    public void run() {
        List<AuthorityValue> authorities;
        AuthorityValueFinder authorityValueFinder = new AuthorityValueFinder();
        if (this.selectedIDs != null && !this.selectedIDs.isEmpty()) {
            authorities = new ArrayList<AuthorityValue>();
            for (String selectedID : this.selectedIDs) {
                AuthorityValue byUID = authorityValueFinder.findByUID(this.context, selectedID);
                authorities.add(byUID);
            }
        } else {
            authorities = authorityValueFinder.findAll(this.context);
        }
        if (authorities != null) {
            this.print.println(authorities.size() + " authorities found.");
            for (AuthorityValue authority : authorities) {
                AuthorityValue updated = AuthorityValueGenerator.update(authority);
                if (updated.getLastModified().equals(authority.getLastModified())) continue;
                this.followUp(updated);
            }
        }
    }

    protected void followUp(AuthorityValue authority) {
        this.print.println("Updated: " + authority.getValue() + " - " + authority.getId());
        boolean updateItems = ConfigurationManager.getBooleanProperty("solrauthority", "auto-update-items");
        if (updateItems) {
            this.updateItems(authority);
        }
    }

    protected void updateItems(AuthorityValue authority) {
        try {
            ItemIterator itemIterator = Item.findByMetadataFieldAuthority(this.context, authority.getField(), authority.getId());
            while (itemIterator.hasNext()) {
                Item next = itemIterator.next();
                List<Metadatum> metadata = next.getMetadata(authority.getField(), authority.getId());
                authority.updateItem(next, metadata.get(0));
                List<Metadatum> metadataAfter = next.getMetadata(authority.getField(), authority.getId());
                if (metadata.get((int)0).value.equals(metadataAfter.get((int)0).value)) continue;
                this.print.println("Updated item with handle " + next.getHandle());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error updating item", (Throwable)e);
            this.print.println("Error updating item. " + Arrays.toString(e.getStackTrace()));
        }
    }

    public PrintWriter getPrint() {
        return this.print;
    }

    public void setPrint(PrintWriter print) {
        this.print = print;
    }
}

