/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.orcid.xml;

import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.dspace.authority.util.XMLUtils;
import org.w3c.dom.Document;

public class XMLErrors {
    private static Logger log = Logger.getLogger(XMLErrors.class);
    private static final String ERROR_DESC = "/orcid-message/error-desc";

    public static boolean check(Document xml) {
        if (xml == null) {
            return true;
        }
        String textContent = null;
        try {
            textContent = XMLUtils.getTextContent(xml, ERROR_DESC);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error while checking for errors in orcid message", (Throwable)e);
        }
        return textContent == null;
    }

    public static String getErrorMessage(Document xml) {
        if (xml == null) {
            return "Did not receive an XML document.";
        }
        String textContent = null;
        try {
            textContent = XMLUtils.getTextContent(xml, ERROR_DESC);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error while checking for errors in orcid message", (Throwable)e);
        }
        return textContent;
    }
}

