/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.rest;

import java.io.InputStream;
import java.util.Scanner;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;
import org.dspace.authority.util.XMLUtils;
import org.w3c.dom.Document;

public class RESTConnector {
    private static Logger log = Logger.getLogger(RESTConnector.class);
    private String url;

    public RESTConnector(String url) {
        this.url = url;
    }

    public Document get(String path) {
        Document document = null;
        InputStream result = null;
        path = RESTConnector.trimSlashes(path);
        String fullPath = this.url + '/' + path;
        HttpGet httpGet = new HttpGet(fullPath);
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse getResponse = httpClient.execute((HttpUriRequest)httpGet);
            result = getResponse.getEntity().getContent();
            document = XMLUtils.convertStreamToXML(result);
        }
        catch (Exception e) {
            this.getGotError(e, fullPath);
        }
        return document;
    }

    protected void getGotError(Exception e, String fullPath) {
        log.error((Object)("Error in rest connector for path: " + fullPath), (Throwable)e);
    }

    public static String trimSlashes(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

