/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.embargo;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.embargo.EmbargoManager;
import org.dspace.embargo.EmbargoSetter;
import org.dspace.eperson.Group;

public class DefaultEmbargoSetter
implements EmbargoSetter {
    protected String termsOpen = ConfigurationManager.getProperty("embargo.terms.open");

    @Override
    public DCDate parseTerms(Context context, Item item, String terms) throws SQLException, AuthorizeException, IOException {
        if (terms != null && terms.length() > 0) {
            if (this.termsOpen.equals(terms)) {
                return EmbargoManager.FOREVER;
            }
            return new DCDate(terms);
        }
        return null;
    }

    @Override
    public void setEmbargo(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        DCDate liftDate = EmbargoManager.getEmbargoTermsAsDate(context, item);
        for (Bundle bn : item.getBundles()) {
            String bnn = bn.getName();
            if (bnn.equals("LICENSE") || bnn.equals("METADATA") || bnn.equals("CC-LICENSE")) continue;
            this.generatePolicies(context, liftDate.toDate(), null, bn, item.getOwningCollection());
            for (Bitstream bs : bn.getBitstreams()) {
                this.generatePolicies(context, liftDate.toDate(), null, bs, item.getOwningCollection());
            }
        }
    }

    protected void generatePolicies(Context context, Date embargoDate, String reason, DSpaceObject dso, Collection owningCollection) throws SQLException, AuthorizeException {
        if (embargoDate != null) {
            Group[] authorizedGroups = AuthorizeManager.getAuthorizedGroups(context, owningCollection, 10);
            boolean isAnonymousInPlace = false;
            for (Group g : authorizedGroups) {
                if (g.getID() != 0) continue;
                isAnonymousInPlace = true;
            }
            if (!isAnonymousInPlace) {
                for (Group g : authorizedGroups) {
                    ResourcePolicy rp = AuthorizeManager.createOrModifyPolicy(null, context, null, g.getID(), null, embargoDate, 0, reason, dso);
                    if (rp == null) continue;
                    rp.update();
                }
            } else {
                ResourcePolicy rp = AuthorizeManager.createOrModifyPolicy(null, context, null, 0, null, embargoDate, 0, reason, dso);
                if (rp != null) {
                    rp.update();
                }
            }
        }
    }

    @Override
    public void checkEmbargo(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        for (Bundle bn : item.getBundles()) {
            String bnn = bn.getName();
            if (bnn.equals("LICENSE") || bnn.equals("METADATA") || bnn.equals("CC-LICENSE")) continue;
            if (!bnn.equals("TEXT") && !bnn.equals("THUMBNAIL")) {
                for (ResourcePolicy rp : AuthorizeManager.getPoliciesActionFilter(context, bn, 0)) {
                    System.out.println("CHECK WARNING: Item " + item.getHandle() + ", Bundle " + bn.getName() + " allows READ by " + (rp.getEPersonID() < 0 ? "Group " + rp.getGroup().getName() : "EPerson " + rp.getEPerson().getFullName()));
                }
            }
            for (Bitstream bs : bn.getBitstreams()) {
                for (ResourcePolicy rp : AuthorizeManager.getPoliciesActionFilter(context, bs, 0)) {
                    System.out.println("CHECK WARNING: Item " + item.getHandle() + ", Bitstream " + bs.getName() + " (in Bundle " + bn.getName() + ") allows READ by " + (rp.getEPersonID() < 0 ? "Group " + rp.getGroup().getName() : "EPerson " + rp.getEPerson().getFullName()));
                }
            }
        }
    }
}

