/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.conversion;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.rdf.RDFConfiguration;
import org.dspace.rdf.conversion.ConverterPlugin;
import org.dspace.rdf.conversion.RDFConverter;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;

public class RDFConverterImpl
implements RDFConverter {
    protected ConfigurationService configurationService = new DSpace().getConfigurationService();
    protected List<ConverterPlugin> plugins = new ArrayList<ConverterPlugin>();
    private static final Logger log = Logger.getLogger(RDFConverterImpl.class);

    public RDFConverterImpl() {
        String[] pluginNames = RDFConfiguration.getConverterPlugins();
        if (pluginNames == null || pluginNames.length == 0) {
            log.error((Object)"Cannot load RDF converter plugins!");
            throw new RuntimeException("Cannot load rdf converter plugins!");
        }
        for (String plugin : pluginNames) {
            try {
                Class<?> pluginClass = Class.forName(plugin);
                ConverterPlugin pluginInstance = (ConverterPlugin)pluginClass.newInstance();
                pluginInstance.setConfigurationService(this.configurationService);
                this.plugins.add(pluginInstance);
            }
            catch (ClassNotFoundException ex) {
                log.warn((Object)("Cannot load plugin '" + plugin + "': class not found!"), (Throwable)ex);
                throw new RuntimeException(ex.getMessage(), ex);
            }
            catch (IllegalAccessException ex) {
                log.warn((Object)("Cannot load plugin '" + plugin + "': illegal access!"), (Throwable)ex);
                throw new RuntimeException(ex.getMessage(), ex);
            }
            catch (InstantiationException ex) {
                log.warn((Object)("Cannot load plugin '" + plugin + "': cannot instantiate the module!"), (Throwable)ex);
                throw new RuntimeException(ex.getMessage(), ex);
            }
            log.debug((Object)("Successfully loaded RDFConverterPlugin " + plugin + "."));
        }
    }

    public List<ConverterPlugin> getConverterPlugins() {
        return this.plugins;
    }

    @Override
    public Model convert(Context context, DSpaceObject dso) throws SQLException, AuthorizeException {
        if (this.plugins.isEmpty()) {
            log.warn((Object)"No RDFConverterPlugins were loaded, cannot convert any data!");
            return null;
        }
        Model model = ModelFactory.createDefaultModel();
        for (ConverterPlugin plugin : this.plugins) {
            Model convertedData;
            if (!plugin.supports(dso.getType()) || (convertedData = plugin.convert(context, dso)) == null) continue;
            model.setNsPrefixes((PrefixMapping)convertedData);
            model.add(convertedData);
            convertedData.close();
        }
        if (model.isEmpty()) {
            model.close();
            return null;
        }
        return model;
    }
}

