/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.conversion;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.rdf.RDFUtil;
import org.dspace.rdf.conversion.ConverterPlugin;
import org.dspace.services.ConfigurationService;

public class StaticDSOConverterPlugin
implements ConverterPlugin {
    private static final Logger log = Logger.getLogger(StaticDSOConverterPlugin.class);
    public static final String CONSTANT_DATA_FILENAME_KEY_PREFIX = "rdf.constant.data.";
    public static final String CONSTANT_DATA_GENERAL_KEY_SUFFIX = "GENERAL";
    protected ConfigurationService configurationService;

    @Override
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public Model convert(Context context, DSpaceObject dso) throws SQLException {
        Model general = this.readFile(CONSTANT_DATA_GENERAL_KEY_SUFFIX, RDFUtil.generateIdentifier(context, dso));
        Model typeSpecific = this.readFile(dso.getTypeText(), RDFUtil.generateIdentifier(context, dso));
        if (general == null) {
            return typeSpecific;
        }
        if (typeSpecific == null) {
            return general;
        }
        typeSpecific.setNsPrefixes((PrefixMapping)general);
        typeSpecific.add(general);
        general.close();
        return typeSpecific;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Model readFile(String fileSuffix, String base) {
        String path = this.configurationService.getProperty(CONSTANT_DATA_FILENAME_KEY_PREFIX + fileSuffix);
        if (path == null) {
            log.error((Object)("Cannot find dspace-rdf configuration (looking for property rdf.constant.data." + fileSuffix + ")!"));
            throw new RuntimeException("Cannot find dspace-rdf configuration (looking for property rdf.constant.data." + fileSuffix + ")!");
        }
        log.debug((Object)("Going to read static data from file '" + path + "'."));
        InputStream is = null;
        Model staticDataModel = null;
        try {
            is = FileManager.get().open(path);
            if (is == null) {
                log.warn((Object)("StaticDSOConverterPlugin cannot find file '" + path + "', ignoring..."));
                Model model = null;
                return model;
            }
            staticDataModel = ModelFactory.createDefaultModel();
            staticDataModel.read(is, base, FileUtils.guessLang((String)path));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        if (staticDataModel.isEmpty()) {
            staticDataModel.close();
            return null;
        }
        return staticDataModel;
    }

    @Override
    public boolean supports(int type) {
        switch (type) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }
}

