/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.storage;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.rdf.storage.URIGenerator;

public class HandleURIGenerator
implements URIGenerator {
    private static final Logger log = Logger.getLogger(HandleURIGenerator.class);

    @Override
    public String generateIdentifier(Context context, int type, int id, String handle, String[] identifiers) {
        if (type == 5) {
            return HandleManager.getCanonicalForm(Site.getSiteHandle());
        }
        if (type == 4 || type == 3 || type == 2) {
            if (StringUtils.isEmpty((String)handle)) {
                throw new IllegalArgumentException("Handle is null");
            }
            log.debug((Object)("Generated identifier " + HandleManager.getCanonicalForm(handle) + " for " + Constants.typeText[type] + " " + Integer.toString(id) + "."));
            return HandleManager.getCanonicalForm(handle);
        }
        return null;
    }

    @Override
    public String generateIdentifier(Context context, DSpaceObject dso) {
        if (dso.getType() != 5 && dso.getType() != 4 && dso.getType() != 3 && dso.getType() != 2) {
            return null;
        }
        return this.generateIdentifier(context, dso.getType(), dso.getID(), dso.getHandle(), dso.getIdentifiers(context));
    }
}

