/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms.xmlworkflow;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.dspace.core.ConfigurationManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.flywaydb.core.api.migration.MigrationChecksumProvider;
import org.flywaydb.core.api.migration.jdbc.JdbcMigration;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V5_0_2014_11_04__Enable_XMLWorkflow_Migration
implements JdbcMigration,
MigrationChecksumProvider {
    private static final Logger log = LoggerFactory.getLogger(V5_0_2014_11_04__Enable_XMLWorkflow_Migration.class);
    Integer migration_file_size = -1;

    public void migrate(Connection connection) throws IOException, SQLException {
        if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("xmlworkflow") && !DatabaseUtils.tableExists(connection, "cwf_workflowitem")) {
            String packagePath = V5_0_2014_11_04__Enable_XMLWorkflow_Migration.class.getPackage().getName().replace(".", "/");
            String dbMigrateSQL = new ClassPathResource(packagePath + "/" + DatabaseManager.getDbKeyword() + "/xml_workflow_migration.sql", this.getClass().getClassLoader()).loadAsString("UTF-8");
            DatabaseUtils.executeSql(connection, dbMigrateSQL);
            String dataMigrateSQL = new ClassPathResource(packagePath + "/" + DatabaseManager.getDbKeyword() + "/data_workflow_migration.sql", this.getClass().getClassLoader()).loadAsString("UTF-8");
            DatabaseUtils.executeSql(connection, dataMigrateSQL);
            this.migration_file_size = dbMigrateSQL.length() + dataMigrateSQL.length();
        }
    }

    public Integer getChecksum() {
        return this.migration_file_size;
    }
}

