/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.workflow.WorkflowManager;

public class WorkflowItem
implements InProgressSubmission {
    private static Logger log = Logger.getLogger(WorkflowItem.class);
    private Item item;
    private Context ourContext;
    private TableRow wfRow;
    private Collection collection;
    private EPerson owner;

    WorkflowItem(Context context, TableRow row) throws SQLException {
        this.ourContext = context;
        this.wfRow = row;
        this.item = Item.find(context, this.wfRow.getIntColumn("item_id"));
        this.collection = Collection.find(context, this.wfRow.getIntColumn("collection_id"));
        this.owner = this.wfRow.isColumnNull("owner") ? null : EPerson.find(context, this.wfRow.getIntColumn("owner"));
        context.cache(this, row.getIntColumn("workflow_id"));
    }

    public static WorkflowItem find(Context context, int id) throws SQLException {
        WorkflowItem fromCache = (WorkflowItem)context.fromCache(WorkflowItem.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "workflowitem", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_workflow_item", "not_found,workflow_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_workflow_item", "workflow_id=" + id));
        }
        return new WorkflowItem(context, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowItem[] findAll(Context c) throws SQLException {
        ArrayList<WorkflowItem> wfItems = new ArrayList<WorkflowItem>();
        try (TableRowIterator tri = DatabaseManager.queryTable(c, "workflowitem", "SELECT * FROM workflowitem", new Object[0]);){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                WorkflowItem wi = new WorkflowItem(c, row);
                wfItems.add(wi);
            }
        }
        return wfItems.toArray(new WorkflowItem[wfItems.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowItem[] findByEPerson(Context context, EPerson ep) throws SQLException {
        ArrayList<WorkflowItem> wfItems = new ArrayList<WorkflowItem>();
        try (TableRowIterator tri = DatabaseManager.queryTable(context, "workflowitem", "SELECT workflowitem.* FROM workflowitem, item WHERE workflowitem.item_id=item.item_id AND item.submitter_id= ? ORDER BY workflowitem.workflow_id", ep.getID());){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                WorkflowItem wi = (WorkflowItem)context.fromCache(WorkflowItem.class, row.getIntColumn("workflow_id"));
                if (wi == null) {
                    wi = new WorkflowItem(context, row);
                }
                wfItems.add(wi);
            }
        }
        return wfItems.toArray(new WorkflowItem[wfItems.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowItem[] findByCollection(Context context, Collection c) throws SQLException {
        ArrayList<WorkflowItem> wsItems = new ArrayList<WorkflowItem>();
        try (TableRowIterator tri = DatabaseManager.queryTable(context, "workflowitem", "SELECT workflowitem.* FROM workflowitem WHERE workflowitem.collection_id= ? ", c.getID());){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                WorkflowItem wi = (WorkflowItem)context.fromCache(WorkflowItem.class, row.getIntColumn("workflow_id"));
                if (wi == null) {
                    wi = new WorkflowItem(context, row);
                }
                wsItems.add(wi);
            }
        }
        return wsItems.toArray(new WorkflowItem[wsItems.size()]);
    }

    public static WorkflowItem findByItem(Context context, Item i) throws SQLException {
        TableRow row = DatabaseManager.findByUnique(context, "workflowitem", "item_id", i.getID());
        if (row == null) {
            return null;
        }
        return new WorkflowItem(context, row);
    }

    @Override
    public int getID() {
        return this.wfRow.getIntColumn("workflow_id");
    }

    public EPerson getOwner() {
        return this.owner;
    }

    public void setOwner(EPerson ep) {
        this.owner = ep;
        if (ep == null) {
            this.wfRow.setColumnNull("owner");
        } else {
            this.wfRow.setColumn("owner", ep.getID());
        }
    }

    public int getState() {
        return this.wfRow.getIntColumn("state");
    }

    public void setState(int newstate) {
        this.wfRow.setColumn("state", newstate);
    }

    @Override
    public void update() throws SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader(this.ourContext, "update_workflow_item", "workflow_item_id=" + this.getID()));
        this.item.update();
        DatabaseManager.update(this.ourContext, this.wfRow);
    }

    @Override
    public void deleteWrapper() throws SQLException, IOException, AuthorizeException {
        this.ourContext.removeCached(this, this.getID());
        WorkflowManager.deleteTasks(this.ourContext, this);
        DatabaseManager.delete(this.ourContext, this.wfRow);
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public Collection getCollection() {
        return this.collection;
    }

    @Override
    public EPerson getSubmitter() throws SQLException {
        return this.item.getSubmitter();
    }

    @Override
    public boolean hasMultipleFiles() {
        return this.wfRow.getBooleanColumn("multiple_files");
    }

    @Override
    public void setMultipleFiles(boolean b) {
        this.wfRow.setColumn("multiple_files", b);
    }

    @Override
    public boolean hasMultipleTitles() {
        return this.wfRow.getBooleanColumn("multiple_titles");
    }

    @Override
    public void setMultipleTitles(boolean b) {
        this.wfRow.setColumn("multiple_titles", b);
    }

    @Override
    public boolean isPublishedBefore() {
        return this.wfRow.getBooleanColumn("published_before");
    }

    @Override
    public void setPublishedBefore(boolean b) {
        this.wfRow.setColumn("published_before", b);
    }
}

