/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.migration;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;
import org.dspace.xmlworkflow.XmlWorkflowManager;

public class RestartWorkflow {
    private static Logger log = Logger.getLogger(RestartWorkflow.class);
    public static boolean useWorkflowSendEmail = false;

    public static void main(String[] args) {
        try {
            System.out.println("All workflowitems will be sent back to the first workflow step.");
            Context context = new Context();
            context.turnOffAuthorisationSystem();
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("e", "eperson", true, "email of eperson doing importing");
            options.addOption("n", "notify", false, "if sending submissions through the workflow, send notification emails");
            options.addOption("p", "provenance", true, "the provenance description to be added to the item");
            options.addOption("h", "help", false, "help");
            CommandLine line = parser.parse(options, args);
            String eperson = null;
            if (line.hasOption('h')) {
                HelpFormatter myhelp = new HelpFormatter();
                myhelp.printHelp("RestartWorkflow\n", options);
                System.exit(0);
            }
            if (line.hasOption('n')) {
                useWorkflowSendEmail = true;
            }
            if (line.hasOption('e')) {
                eperson = line.getOptionValue('e');
            } else {
                System.out.println("The -e (eperson) option is mandatory !");
                System.exit(1);
            }
            EPerson myEPerson = null;
            myEPerson = eperson.indexOf(64) != -1 ? EPerson.findByEmail(context, eperson) : EPerson.find(context, Integer.parseInt(eperson));
            if (myEPerson == null) {
                System.out.println("Error, eperson cannot be found: " + eperson);
                System.exit(1);
            }
            String provenance = null;
            if (line.hasOption('p')) {
                provenance = line.getOptionValue('p');
            }
            context.setCurrentUser(myEPerson);
            System.out.println("Sending all workflow items back to the workspace");
            WorkflowItem[] workflowItems = WorkflowItem.findAll(context);
            int i = 0;
            for (WorkflowItem workflowItem : workflowItems) {
                System.out.println("Processing workflow item " + i + " of " + workflowItems.length);
                System.out.println("Removing pooled tasks");
                RestartWorkflow.deleteTasks(context, workflowItem);
                Item myitem = workflowItem.getItem();
                if (provenance != null) {
                    myitem.addMetadata("dc", "description", "provenance", "en", provenance);
                }
                myitem.update();
                WorkspaceItem wsi = RestartWorkflow.returnToWorkspace(context, workflowItem);
                log.info((Object)LogManager.getHeader(context, "restart_workflow", "workflow_item_id=" + workflowItem.getID() + "item_id=" + workflowItem.getItem().getID() + "collection_id=" + workflowItem.getCollection().getID()));
                if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("xmlworkflow")) {
                    if (useWorkflowSendEmail) {
                        XmlWorkflowManager.start(context, wsi);
                    } else {
                        XmlWorkflowManager.startWithoutNotify(context, wsi);
                    }
                } else if (useWorkflowSendEmail) {
                    WorkflowManager.start(context, wsi);
                } else {
                    WorkflowManager.startWithoutNotify(context, wsi);
                }
                ++i;
            }
            System.out.println("All done, committing context");
            context.complete();
            System.exit(0);
        }
        catch (Exception e) {
            log.error((Object)"Error while sending all workflow items back to the workspace", (Throwable)e);
            e.printStackTrace();
        }
    }

    static void deleteTasks(Context c, WorkflowItem wi) throws SQLException {
        String myrequest = "DELETE FROM TaskListItem WHERE workflow_id= ? ";
        DatabaseManager.updateQuery(c, myrequest, wi.getID());
    }

    private static WorkspaceItem returnToWorkspace(Context c, WorkflowItem wfi) throws SQLException, IOException, AuthorizeException {
        Item myitem = wfi.getItem();
        Collection mycollection = wfi.getCollection();
        EPerson submitter = wfi.getSubmitter();
        AuthorizeManager.removeAllPolicies(c, myitem);
        AuthorizeManager.addPolicy(c, (DSpaceObject)myitem, 0, submitter);
        TableRow row = DatabaseManager.row("workspaceitem");
        row.setColumn("item_id", myitem.getID());
        row.setColumn("collection_id", mycollection.getID());
        DatabaseManager.insert(c, row);
        int wsi_id = row.getIntColumn("workspace_item_id");
        WorkspaceItem wi = WorkspaceItem.find(c, wsi_id);
        wi.setMultipleFiles(wfi.hasMultipleFiles());
        wi.setMultipleTitles(wfi.hasMultipleTitles());
        wi.setPublishedBefore(wfi.isPublishedBefore());
        wi.update();
        log.info((Object)LogManager.getHeader(c, "return_to_workspace", "workflow_item_id=" + wfi.getID() + "workspace_item_id=" + wi.getID()));
        DatabaseManager.updateQuery(c, "DELETE FROM WorkflowItem WHERE workflow_id=" + wfi.getID(), new Object[0]);
        return wi;
    }
}

