/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.packager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;

public class Packager {
    private String packageType = null;
    private boolean submit = true;
    private boolean userInteractionEnabled = true;

    private static void usageError(String msg) {
        System.out.println(msg);
        System.out.println(" (run with -h flag for details)");
        System.exit(1);
    }

    public static void main(String[] argv) throws Exception {
        PackageIngester sip;
        String[] files;
        Options options = new Options();
        options.addOption("p", "parent", true, "Handle(s) of parent Community or Collection into which to ingest object (repeatable)");
        options.addOption("e", "eperson", true, "email address of eperson doing importing");
        options.addOption("w", "install", false, "disable workflow; install immediately without going through collection's workflow");
        options.addOption("r", "restore", false, "ingest in \"restore\" mode.  Restores a missing object based on the contents in a package.");
        options.addOption("k", "keep-existing", false, "if an object is found to already exist during a restore (-r), then keep the existing object and continue processing.  Can only be used with '-r'.  This avoids object-exists errors which are thrown by -r by default.");
        options.addOption("f", "force-replace", false, "if an object is found to already exist during a restore (-r), then remove it and replace it with the contents of the package.  Can only be used with '-r'.  This REPLACES the object(s) in the repository with the contents from the package(s).");
        options.addOption("t", "type", true, "package type or MIMEtype");
        options.addOption("o", "option", true, "Packager option to pass to plugin, \"name=value\" (repeatable)");
        options.addOption("d", "disseminate", false, "Disseminate package (output); default is to submit.");
        options.addOption("s", "submit", false, "Submission package (Input); this is the default. ");
        options.addOption("i", "identifier", true, "Handle of object to disseminate.");
        options.addOption("a", "all", false, "also recursively ingest/disseminate any child packages, e.g. all Items within a Collection (not all packagers may support this option!)");
        options.addOption("h", "help", false, "help (you may also specify '-h -t [type]' for additional help with a specific type of packager)");
        options.addOption("u", "no-user-interaction", false, "Skips over all user interaction (i.e. [y/n] question prompts) within this script. This flag can be used if you want to save (pipe) a report of all changes to a file, and therefore need to bypass all user interaction.");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, argv);
        String sourceFile = null;
        String eperson = null;
        String[] parents = null;
        String identifier = null;
        PackageParameters pkgParams = new PackageParameters();
        Packager myPackager = new Packager();
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("Packager  [options]  package-file|-\n", options);
            if (line.hasOption('t')) {
                System.out.println("\n--------------------------------------------------------------");
                System.out.println("Additional options for the " + line.getOptionValue('t') + " packager:");
                System.out.println("--------------------------------------------------------------");
                System.out.println("(These options may be specified using --option as described above)");
                PackageIngester sip2 = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, line.getOptionValue('t'));
                if (sip2 != null) {
                    System.out.println("\n\n" + line.getOptionValue('t') + " Submission (SIP) plugin options:\n");
                    System.out.println(sip2.getParameterHelp());
                } else {
                    System.out.println("\nNo valid Submission plugin found for " + line.getOptionValue('t') + " type.");
                }
                PackageDisseminator dip = (PackageDisseminator)PluginManager.getNamedPlugin(PackageDisseminator.class, line.getOptionValue('t'));
                if (dip != null) {
                    System.out.println("\n\n" + line.getOptionValue('t') + " Dissemination (DIP) plugin options:\n");
                    System.out.println(dip.getParameterHelp());
                } else {
                    System.out.println("\nNo valid Dissemination plugin found for " + line.getOptionValue('t') + " type.");
                }
            } else {
                int i;
                System.out.println("\nAvailable Submission Package (SIP) types:");
                String[] pn = PluginManager.getAllPluginNames(PackageIngester.class);
                for (i = 0; i < pn.length; ++i) {
                    System.out.println("  " + pn[i]);
                }
                System.out.println("\nAvailable Dissemination Package (DIP) types:");
                pn = PluginManager.getAllPluginNames(PackageDisseminator.class);
                for (i = 0; i < pn.length; ++i) {
                    System.out.println("  " + pn[i]);
                }
            }
            System.exit(0);
        }
        if (line.hasOption('u')) {
            myPackager.userInteractionEnabled = false;
        }
        if (line.hasOption('w')) {
            pkgParams.setWorkflowEnabled(false);
        }
        if (line.hasOption('r')) {
            pkgParams.setRestoreModeEnabled(true);
        }
        if (line.hasOption('k') && pkgParams.restoreModeEnabled()) {
            pkgParams.setKeepExistingModeEnabled(true);
        }
        if (line.hasOption('f') && pkgParams.restoreModeEnabled()) {
            pkgParams.setReplaceModeEnabled(true);
        }
        if (line.hasOption('e')) {
            eperson = line.getOptionValue('e');
        }
        if (line.hasOption('p')) {
            parents = line.getOptionValues('p');
        }
        if (line.hasOption('t')) {
            myPackager.packageType = line.getOptionValue('t');
        }
        if (line.hasOption('i')) {
            identifier = line.getOptionValue('i');
        }
        if (line.hasOption('a')) {
            pkgParams.setRecursiveModeEnabled(true);
        }
        if ((files = line.getArgs()).length > 0) {
            sourceFile = files[0];
        }
        if (line.hasOption('d')) {
            myPackager.submit = false;
        }
        if (line.hasOption('o')) {
            String[] popt = line.getOptionValues('o');
            for (int i = 0; i < popt.length; ++i) {
                String[] pair = popt[i].split("\\=", 2);
                if (pair.length == 2) {
                    pkgParams.addProperty(pair[0].trim(), pair[1].trim());
                    continue;
                }
                if (pair.length == 1) {
                    pkgParams.addProperty(pair[0].trim(), "");
                    continue;
                }
                System.err.println("Warning: Illegal package option format: \"" + popt[i] + "\"");
            }
        }
        if (sourceFile == null || eperson == null || myPackager.packageType == null) {
            System.err.println("Error - missing a REQUIRED argument or option.\n");
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("PackageManager  [options]  package-file|-\n", options);
            System.exit(0);
        }
        Context context = new Context();
        EPerson myEPerson = null;
        myEPerson = EPerson.findByEmail(context, eperson);
        if (myEPerson == null) {
            Packager.usageError("Error, eperson cannot be found: " + eperson);
        }
        context.setCurrentUser(myEPerson);
        if (pkgParams.replaceModeEnabled()) {
            sip = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, myPackager.packageType);
            if (sip == null) {
                Packager.usageError("Error, Unknown package type: " + myPackager.packageType);
            }
            DSpaceObject objToReplace = null;
            if (identifier != null && identifier.length() > 0 && (objToReplace = HandleManager.resolveToObject(context, identifier)) == null) {
                throw new IllegalArgumentException("Bad identifier/handle -- Cannot resolve handle \"" + identifier + "\"");
            }
            String choiceString = null;
            if (myPackager.userInteractionEnabled) {
                BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                System.out.println("\n\nWARNING -- You are running the packager in REPLACE mode.");
                System.out.println("\nREPLACE mode may be potentially dangerous as it will automatically remove and replace contents within DSpace.");
                System.out.println("We highly recommend backing up all your DSpace contents (files & database) before continuing.");
                System.out.print("\nWould you like to continue? [y/n]: ");
                choiceString = input.readLine();
            } else {
                choiceString = "y";
            }
            if (choiceString.equalsIgnoreCase("y")) {
                System.out.println("Beginning replacement process...");
                try {
                    myPackager.replace(context, sip, pkgParams, sourceFile, objToReplace);
                    context.complete();
                    System.exit(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    context.abort();
                    System.out.println(e);
                    System.exit(1);
                }
            }
        } else if (myPackager.submit || pkgParams.restoreModeEnabled()) {
            sip = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, myPackager.packageType);
            if (sip == null) {
                Packager.usageError("Error, Unknown package type: " + myPackager.packageType);
            }
            DSpaceObject[] parentObjs = null;
            if (parents != null) {
                System.out.println("Destination parents:");
                parentObjs = new DSpaceObject[parents.length];
                for (int i = 0; i < parents.length; ++i) {
                    parentObjs[i] = HandleManager.resolveToObject(context, parents[i]);
                    if (parentObjs[i] == null) {
                        throw new IllegalArgumentException("Bad parent list -- Cannot resolve parent handle \"" + parents[i] + "\"");
                    }
                    System.out.println((i == 0 ? "Owner: " : "Parent: ") + parentObjs[i].getHandle());
                }
            }
            try {
                myPackager.ingest(context, sip, pkgParams, sourceFile, parentObjs);
                context.complete();
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                context.abort();
                System.out.println(e);
                System.exit(1);
            }
        } else {
            DSpaceObject dso;
            PackageDisseminator dip = (PackageDisseminator)PluginManager.getNamedPlugin(PackageDisseminator.class, myPackager.packageType);
            if (dip == null) {
                Packager.usageError("Error, Unknown package type: " + myPackager.packageType);
            }
            if ((dso = HandleManager.resolveToObject(context, identifier)) == null) {
                throw new IllegalArgumentException("Bad identifier/handle -- Cannot resolve handle \"" + identifier + "\"");
            }
            myPackager.disseminate(context, dip, dso, pkgParams, sourceFile);
        }
        System.exit(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void ingest(Context context, PackageIngester sip, PackageParameters pkgParams, String sourceFile, DSpaceObject[] parentObjs) throws IOException, SQLException, FileNotFoundException, AuthorizeException, CrosswalkException, PackageException {
        File pkgFile = new File(sourceFile);
        if (!pkgFile.exists()) {
            System.out.println("\nERROR: Package located at " + sourceFile + " does not exist!");
            System.exit(1);
        }
        System.out.println("\nIngesting package located at " + sourceFile);
        DSpaceObject parent = null;
        if (parentObjs != null && parentObjs.length > 0) {
            parent = parentObjs[0];
        }
        if (pkgParams.recursiveModeEnabled()) {
            System.out.println("\nAlso ingesting all referenced packages (recursive mode)..");
            System.out.println("This may take a while, please check your logs for ongoing status while we process each package.");
            List<String> hdlResults = sip.ingestAll(context, parent, pkgFile, pkgParams, null);
            if (hdlResults == null) return;
            System.out.println("\nCREATED a total of " + hdlResults.size() + " DSpace Objects.");
            String choiceString = null;
            if (this.userInteractionEnabled) {
                BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("\nWould you like to view a list of all objects that were created? [y/n]: ");
                choiceString = input.readLine();
            } else {
                choiceString = "y";
            }
            if (!choiceString.equalsIgnoreCase("y")) return;
            System.out.println("\n\n");
            for (String result : hdlResults) {
                DSpaceObject dso = HandleManager.resolveToObject(context, result);
                if (dso == null) continue;
                if (pkgParams.restoreModeEnabled()) {
                    System.out.println("RESTORED DSpace " + Constants.typeText[dso.getType()] + " [ hdl=" + dso.getHandle() + ", dbID=" + dso.getID() + " ] ");
                    continue;
                }
                System.out.println("CREATED new DSpace " + Constants.typeText[dso.getType()] + " [ hdl=" + dso.getHandle() + ", dbID=" + dso.getID() + " ] ");
            }
            return;
        } else {
            try {
                DSpaceObject dso = sip.ingest(context, parent, pkgFile, pkgParams, null);
                if (dso == null) return;
                if (pkgParams.restoreModeEnabled()) {
                    System.out.println("RESTORED DSpace " + Constants.typeText[dso.getType()] + " [ hdl=" + dso.getHandle() + ", dbID=" + dso.getID() + " ] ");
                    return;
                }
                System.out.println("CREATED new DSpace " + Constants.typeText[dso.getType()] + " [ hdl=" + dso.getHandle() + ", dbID=" + dso.getID() + " ] ");
                return;
            }
            catch (IllegalStateException ie) {
                if (!pkgParams.keepExistingModeEnabled()) throw ie;
                System.out.println("\nSKIPPED processing package '" + pkgFile + "', as an Object already exists with this handle.");
                return;
            }
        }
    }

    protected void disseminate(Context context, PackageDisseminator dip, DSpaceObject dso, PackageParameters pkgParams, String outputFile) throws IOException, SQLException, FileNotFoundException, AuthorizeException, CrosswalkException, PackageException {
        File pkgFile = new File(outputFile);
        System.out.println("\nDisseminating DSpace " + Constants.typeText[dso.getType()] + " [ hdl=" + dso.getHandle() + " ] to " + outputFile);
        if (pkgParams.recursiveModeEnabled()) {
            System.out.println("\nAlso disseminating all child objects (recursive mode)..");
            System.out.println("This may take a while, please check your logs for ongoing status while we process each package.");
            List<File> fileResults = dip.disseminateAll(context, dso, pkgParams, pkgFile);
            if (fileResults != null) {
                System.out.println("\nCREATED a total of " + fileResults.size() + " dissemination package files.");
                String choiceString = null;
                if (this.userInteractionEnabled) {
                    BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                    System.out.print("\nWould you like to view a list of all files that were created? [y/n]: ");
                    choiceString = input.readLine();
                } else {
                    choiceString = "y";
                }
                if (choiceString.equalsIgnoreCase("y")) {
                    System.out.println("\n\n");
                    for (File result : fileResults) {
                        System.out.println("CREATED package file: " + result.getCanonicalPath());
                    }
                }
            }
        } else {
            dip.disseminate(context, dso, pkgParams, pkgFile);
            if (pkgFile != null && pkgFile.exists()) {
                System.out.println("\nCREATED package file: " + pkgFile.getCanonicalPath());
            }
        }
    }

    protected void replace(Context context, PackageIngester sip, PackageParameters pkgParams, String sourceFile, DSpaceObject objToReplace) throws IOException, SQLException, FileNotFoundException, AuthorizeException, CrosswalkException, PackageException {
        File pkgFile = new File(sourceFile);
        if (!pkgFile.exists()) {
            System.out.println("\nPackage located at " + sourceFile + " does not exist!");
            System.exit(1);
        }
        System.out.println("\nReplacing DSpace object(s) with package located at " + sourceFile);
        if (objToReplace != null) {
            System.out.println("Will replace existing DSpace " + Constants.typeText[objToReplace.getType()] + " [ hdl=" + objToReplace.getHandle() + " ]");
        }
        if (pkgParams.recursiveModeEnabled()) {
            List<String> hdlResults = sip.replaceAll(context, objToReplace, pkgFile, pkgParams);
            if (hdlResults != null) {
                System.out.println("\nREPLACED a total of " + hdlResults.size() + " DSpace Objects.");
                String choiceString = null;
                if (this.userInteractionEnabled) {
                    BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                    System.out.print("\nWould you like to view a list of all objects that were replaced? [y/n]: ");
                    choiceString = input.readLine();
                } else {
                    choiceString = "y";
                }
                if (choiceString.equalsIgnoreCase("y")) {
                    System.out.println("\n\n");
                    for (String result : hdlResults) {
                        DSpaceObject dso = HandleManager.resolveToObject(context, result);
                        if (dso == null) continue;
                        System.out.println("REPLACED DSpace " + Constants.typeText[dso.getType()] + " [ hdl=" + dso.getHandle() + " ] ");
                    }
                }
            }
        } else {
            DSpaceObject dso = sip.replace(context, objToReplace, pkgFile, pkgParams);
            if (dso != null) {
                System.out.println("REPLACED DSpace " + Constants.typeText[dso.getType()] + " [ hdl=" + dso.getHandle() + " ] ");
            }
        }
    }
}

