/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.workflow.WorkflowItem;

public class AuthorizeManager {
    public static void authorizeAnyOf(Context c, DSpaceObject o, int[] actions) throws AuthorizeException, SQLException {
        AuthorizeException ex = null;
        for (int i = 0; i < actions.length; ++i) {
            try {
                AuthorizeManager.authorizeAction(c, o, actions[i]);
                return;
            }
            catch (AuthorizeException e) {
                if (ex != null) continue;
                ex = e;
                continue;
            }
        }
        throw ex;
    }

    public static void authorizeAction(Context c, DSpaceObject o, int action) throws AuthorizeException, SQLException {
        AuthorizeManager.authorizeAction(c, o, action, true);
    }

    public static void authorizeAction(Context c, DSpaceObject o, int action, boolean useInheritance) throws AuthorizeException, SQLException {
        if (o == null) {
            String actionText = action == -1 ? "null" : Constants.actionText[action];
            EPerson e = c.getCurrentUser();
            int userid = e == null ? 0 : e.getID();
            throw new AuthorizeException("Authorization attempted on null DSpace object " + actionText + " by user " + userid);
        }
        if (!AuthorizeManager.authorize(c, o, action, c.getCurrentUser(), useInheritance)) {
            int otype = o.getType();
            int oid = o.getID();
            EPerson e = c.getCurrentUser();
            int userid = e == null ? 0 : e.getID();
            String actionText = action == -1 ? "null" : Constants.actionText[action];
            throw new AuthorizeException("Authorization denied for action " + actionText + " on " + Constants.typeText[otype] + ":" + oid + " by user " + userid, o, action);
        }
    }

    public static boolean authorizeActionBoolean(Context c, DSpaceObject o, int a) throws SQLException {
        return AuthorizeManager.authorizeActionBoolean(c, o, a, true);
    }

    public static boolean authorizeActionBoolean(Context c, DSpaceObject o, int a, boolean useInheritance) throws SQLException {
        boolean isAuthorized = true;
        if (o == null) {
            return false;
        }
        try {
            AuthorizeManager.authorizeAction(c, o, a, useInheritance);
        }
        catch (AuthorizeException e) {
            isAuthorized = false;
        }
        return isAuthorized;
    }

    private static boolean authorize(Context c, DSpaceObject o, int action, EPerson e, boolean useInheritance) throws SQLException {
        Bitstream b;
        DSpaceObject parent;
        if (o == null) {
            return false;
        }
        if (c.ignoreAuthorization()) {
            return true;
        }
        int userid = 0;
        if (e != null) {
            DSpaceObject testObject;
            userid = e.getID();
            DSpaceObject dSpaceObject = testObject = useInheritance ? o.getAdminObject(action) : null;
            if (AuthorizeManager.isAdmin(c, testObject)) {
                return true;
            }
        }
        boolean ignoreCustomPolicies = false;
        if (o instanceof Bitstream && !((parent = (b = (Bitstream)o).getParentObject()) instanceof Collection) && !(parent instanceof Community)) {
            boolean bl = ignoreCustomPolicies = !AuthorizeManager.isAnyItemInstalled(c, b.getBundles());
        }
        if (o instanceof Bundle) {
            boolean bl = ignoreCustomPolicies = !AuthorizeManager.isAnyItemInstalled(c, new Bundle[]{(Bundle)o});
        }
        if (o instanceof Item && (WorkspaceItem.findByItem(c, (Item)o) != null || WorkflowItem.findByItem(c, (Item)o) != null)) {
            ignoreCustomPolicies = true;
        }
        for (ResourcePolicy rp : AuthorizeManager.getPoliciesActionFilter(c, o, action)) {
            if (ignoreCustomPolicies && ResourcePolicy.TYPE_CUSTOM.equals(rp.getRpType()) || !rp.isDateValid()) continue;
            if (rp.getEPersonID() != -1 && rp.getEPersonID() == userid) {
                return true;
            }
            if (rp.getGroupID() == -1 || !Group.isMember(c, rp.getGroupID())) continue;
            return true;
        }
        return false;
    }

    protected static boolean isAnyItemInstalled(Context ctx, Bundle[] bundles) throws SQLException {
        for (Bundle bundle : bundles) {
            for (Item item : bundle.getItems()) {
                if (WorkspaceItem.findByItem(ctx, item) != null || WorkflowItem.findByItem(ctx, item) != null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAdmin(Context c, DSpaceObject o) throws SQLException {
        if (AuthorizeManager.isAdmin(c)) {
            return true;
        }
        if (o == null) {
            return false;
        }
        int userid = 0;
        EPerson e = c.getCurrentUser();
        if (e != null) {
            userid = e.getID();
        }
        List<ResourcePolicy> policies = AuthorizeManager.getPoliciesActionFilter(c, o, 11);
        for (ResourcePolicy rp : policies) {
            if (!rp.isDateValid()) continue;
            if (rp.getEPersonID() != -1 && rp.getEPersonID() == userid) {
                return true;
            }
            if (rp.getGroupID() == -1 || !Group.isMember(c, rp.getGroupID())) continue;
            return true;
        }
        DSpaceObject parent = o.getParentObject();
        if (parent != null) {
            return AuthorizeManager.isAdmin(c, parent);
        }
        return false;
    }

    public static boolean isAdmin(Context c) throws SQLException {
        if (c.ignoreAuthorization()) {
            return true;
        }
        EPerson e = c.getCurrentUser();
        if (e == null) {
            return false;
        }
        return Group.isMember(c, 1);
    }

    public static void addPolicy(Context c, DSpaceObject o, int actionID, EPerson e) throws SQLException, AuthorizeException {
        AuthorizeManager.addPolicy(c, o, actionID, e, null);
    }

    public static void addPolicy(Context c, DSpaceObject o, int actionID, EPerson e, String type) throws SQLException, AuthorizeException {
        ResourcePolicy rp = ResourcePolicy.create(c);
        rp.setResource(o);
        rp.setAction(actionID);
        rp.setEPerson(e);
        rp.setRpType(type);
        rp.update();
        o.updateLastModified();
    }

    public static void addPolicy(Context c, DSpaceObject o, int actionID, Group g) throws SQLException, AuthorizeException {
        AuthorizeManager.addPolicy(c, o, actionID, g, null);
    }

    public static void addPolicy(Context c, DSpaceObject o, int actionID, Group g, String type) throws SQLException, AuthorizeException {
        ResourcePolicy rp = ResourcePolicy.create(c);
        rp.setResource(o);
        rp.setAction(actionID);
        rp.setGroup(g);
        rp.setRpType(type);
        rp.update();
        o.updateLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ResourcePolicy> getPolicies(Context c, DSpaceObject o) throws SQLException {
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        try (TableRowIterator tri = DatabaseManager.queryTable(c, "resourcepolicy", "SELECT * FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? ", o.getType(), o.getID());){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                ResourcePolicy cachepolicy = (ResourcePolicy)c.fromCache(ResourcePolicy.class, row.getIntColumn("policy_id"));
                if (cachepolicy != null) {
                    policies.add(cachepolicy);
                    continue;
                }
                policies.add(new ResourcePolicy(c, row));
            }
        }
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ResourcePolicy> findPoliciesByDSOAndType(Context c, DSpaceObject o, String type) throws SQLException {
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        try (TableRowIterator tri = DatabaseManager.queryTable(c, "resourcepolicy", "SELECT * FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND rptype= ? ", o.getType(), o.getID(), type);){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                ResourcePolicy cachepolicy = (ResourcePolicy)c.fromCache(ResourcePolicy.class, row.getIntColumn("policy_id"));
                if (cachepolicy != null) {
                    policies.add(cachepolicy);
                    continue;
                }
                policies.add(new ResourcePolicy(c, row));
            }
        }
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ResourcePolicy> getPoliciesForGroup(Context c, Group g) throws SQLException {
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        try (TableRowIterator tri = DatabaseManager.queryTable(c, "resourcepolicy", "SELECT * FROM resourcepolicy WHERE epersongroup_id= ? ", g.getID());){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                ResourcePolicy cachepolicy = (ResourcePolicy)c.fromCache(ResourcePolicy.class, row.getIntColumn("policy_id"));
                if (cachepolicy != null) {
                    policies.add(cachepolicy);
                    continue;
                }
                policies.add(new ResourcePolicy(c, row));
            }
        }
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ResourcePolicy> getPoliciesActionFilter(Context c, DSpaceObject o, int actionID) throws SQLException {
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        try (TableRowIterator tri = DatabaseManager.queryTable(c, "resourcepolicy", "SELECT * FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND action_id= ? ", o.getType(), o.getID(), actionID);){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                ResourcePolicy cachepolicy = (ResourcePolicy)c.fromCache(ResourcePolicy.class, row.getIntColumn("policy_id"));
                if (cachepolicy != null) {
                    policies.add(cachepolicy);
                    continue;
                }
                policies.add(new ResourcePolicy(c, row));
            }
        }
        return policies;
    }

    public static void inheritPolicies(Context c, DSpaceObject src, DSpaceObject dest) throws SQLException, AuthorizeException {
        List<ResourcePolicy> policies = AuthorizeManager.getPolicies(c, src);
        ArrayList<ResourcePolicy> nonAdminPolicies = new ArrayList<ResourcePolicy>();
        for (ResourcePolicy rp : policies) {
            if (rp.getAction() == 11) continue;
            nonAdminPolicies.add(rp);
        }
        AuthorizeManager.addPolicies(c, nonAdminPolicies, dest);
    }

    public static void addPolicies(Context c, List<ResourcePolicy> policies, DSpaceObject dest) throws SQLException, AuthorizeException {
        for (ResourcePolicy srp : policies) {
            ResourcePolicy drp = ResourcePolicy.create(c);
            drp.setResource(dest);
            drp.setAction(srp.getAction());
            drp.setEPerson(srp.getEPerson());
            drp.setGroup(srp.getGroup());
            drp.setStartDate(srp.getStartDate());
            drp.setEndDate(srp.getEndDate());
            drp.setRpName(srp.getRpName());
            drp.setRpDescription(srp.getRpDescription());
            drp.setRpType(srp.getRpType());
            drp.update();
        }
        dest.updateLastModified();
    }

    public static void removeAllPolicies(Context c, DSpaceObject o) throws SQLException {
        o.updateLastModified();
        DatabaseManager.updateQuery(c, "DELETE FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? ", o.getType(), o.getID());
    }

    public static void removeAllPoliciesByDSOAndTypeNotEqualsTo(Context c, DSpaceObject o, String type) throws SQLException {
        DatabaseManager.updateQuery(c, "DELETE FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND (rptype <> ? OR rptype IS NULL)", o.getType(), o.getID(), type);
    }

    public static void removeAllPoliciesByDSOAndType(Context c, DSpaceObject o, String type) throws SQLException {
        DatabaseManager.updateQuery(c, "DELETE FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND rptype=? ", o.getType(), o.getID(), type);
    }

    public static void removePoliciesActionFilter(Context context, DSpaceObject dso, int actionID) throws SQLException {
        dso.updateLastModified();
        if (actionID == -1) {
            AuthorizeManager.removeAllPolicies(context, dso);
        } else {
            DatabaseManager.updateQuery(context, "DELETE FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND action_id= ? ", dso.getType(), dso.getID(), actionID);
        }
    }

    public static void removeGroupPolicies(Context c, int groupID) throws SQLException {
        DatabaseManager.updateQuery(c, "DELETE FROM resourcepolicy WHERE epersongroup_id= ? ", groupID);
    }

    public static void removeGroupPolicies(Context c, DSpaceObject o, Group g) throws SQLException {
        o.updateLastModified();
        DatabaseManager.updateQuery(c, "DELETE FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND epersongroup_id= ? ", o.getType(), o.getID(), g.getID());
    }

    public static void removeEPersonPolicies(Context c, DSpaceObject o, EPerson e) throws SQLException {
        o.updateLastModified();
        DatabaseManager.updateQuery(c, "DELETE FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND eperson_id= ? ", o.getType(), o.getID(), e.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group[] getAuthorizedGroups(Context c, DSpaceObject o, int actionID) throws SQLException {
        ArrayList<Group> groups = new ArrayList<Group>();
        try (TableRowIterator tri = DatabaseManager.queryTable(c, "resourcepolicy", "SELECT * FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND action_id= ? ", o.getType(), o.getID(), actionID);){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                ResourcePolicy cachepolicy = (ResourcePolicy)c.fromCache(ResourcePolicy.class, row.getIntColumn("policy_id"));
                ResourcePolicy myPolicy = null;
                myPolicy = cachepolicy != null ? cachepolicy : new ResourcePolicy(c, row);
                Group myGroup = myPolicy.getGroup();
                if (myGroup == null) continue;
                groups.add(myGroup);
            }
        }
        Group[] groupArray = new Group[groups.size()];
        groupArray = groups.toArray(groupArray);
        return groupArray;
    }

    public static boolean isAnIdenticalPolicyAlreadyInPlace(Context c, DSpaceObject o, ResourcePolicy rp) throws SQLException {
        return AuthorizeManager.isAnIdenticalPolicyAlreadyInPlace(c, o.getType(), o.getID(), rp.getGroupID(), rp.getAction(), rp.getID());
    }

    public static boolean isAnIdenticalPolicyAlreadyInPlace(Context c, DSpaceObject o, int groupID, int action, int policyID) throws SQLException {
        return AuthorizeManager.isAnIdenticalPolicyAlreadyInPlace(c, o.getType(), o.getID(), groupID, action, policyID);
    }

    public static boolean isAnIdenticalPolicyAlreadyInPlace(Context c, int dsoType, int dsoID, int groupID, int action, int policyID) throws SQLException {
        TableRow tr;
        String select = "SELECT * FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND epersongroup_id=? AND action_id=? ";
        if (policyID != -1) {
            select = select + " AND policy_id <> ? ";
            tr = DatabaseManager.querySingleTable(c, "resourcepolicy", select, dsoType, dsoID, groupID, action, policyID);
        } else {
            tr = DatabaseManager.querySingleTable(c, "resourcepolicy", select, dsoType, dsoID, groupID, action);
        }
        return tr != null;
    }

    public static ResourcePolicy findByTypeIdGroupAction(Context c, int dsoType, int dsoID, int groupID, int action, int policyID) throws SQLException {
        TableRow tr;
        String select = "SELECT * FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND epersongroup_id=? AND action_id=? ";
        if (policyID != -1) {
            select = select + " AND policy_id <> ? ";
            tr = DatabaseManager.querySingleTable(c, "resourcepolicy", select, dsoType, dsoID, groupID, action, policyID);
        } else {
            tr = DatabaseManager.querySingleTable(c, "resourcepolicy", select, dsoType, dsoID, groupID, action);
        }
        if (tr != null) {
            ResourcePolicy rp = (ResourcePolicy)c.fromCache(ResourcePolicy.class, tr.getIntColumn("policy_id"));
            if (rp != null) {
                return rp;
            }
            return new ResourcePolicy(c, tr);
        }
        return null;
    }

    public static void generateAutomaticPolicies(Context context, Date embargoDate, String reason, DSpaceObject dso, Collection owningCollection) throws SQLException, AuthorizeException {
        if (embargoDate != null || embargoDate == null && dso instanceof Bitstream) {
            Group[] authorizedGroups = AuthorizeManager.getAuthorizedGroups(context, owningCollection, 10);
            AuthorizeManager.removeAllPoliciesByDSOAndType(context, dso, ResourcePolicy.TYPE_CUSTOM);
            boolean isAnonymousInPlace = false;
            for (Group g : authorizedGroups) {
                if (g.getID() != 0) continue;
                isAnonymousInPlace = true;
            }
            if (!isAnonymousInPlace) {
                for (Group g : authorizedGroups) {
                    ResourcePolicy rp = AuthorizeManager.createOrModifyPolicy(null, context, null, g.getID(), null, embargoDate, 0, reason, dso);
                    if (rp == null) continue;
                    rp.update();
                }
            } else {
                ResourcePolicy rp = AuthorizeManager.createOrModifyPolicy(null, context, null, 0, null, embargoDate, 0, reason, dso);
                if (rp != null) {
                    rp.update();
                }
            }
        }
    }

    public static ResourcePolicy createOrModifyPolicy(ResourcePolicy policy, Context context, String name, int idGroup, EPerson ePerson, Date embargoDate, int action, String reason, DSpaceObject dso) throws AuthorizeException, SQLException {
        ResourcePolicy policyTemp;
        int policyID = -1;
        if (policy != null) {
            policyID = policy.getID();
        }
        if ((policyTemp = AuthorizeManager.findByTypeIdGroupAction(context, dso.getType(), dso.getID(), idGroup, action, policyID)) != null) {
            policy = policyTemp;
            policy.setRpType(ResourcePolicy.TYPE_CUSTOM);
        }
        if (policy == null) {
            policy = ResourcePolicy.create(context);
            policy.setResourceID(dso.getID());
            int resourceType = 2;
            if (dso instanceof Bitstream) {
                resourceType = 0;
            }
            if (dso instanceof Bundle) {
                resourceType = 1;
            }
            policy.setResourceType(resourceType);
            policy.setAction(action);
            policy.setRpType(ResourcePolicy.TYPE_CUSTOM);
        }
        Group policyGroup = Group.find(context, idGroup);
        policy.setGroup(policyGroup);
        policy.setEPerson(ePerson);
        if (embargoDate != null) {
            policy.setStartDate(embargoDate);
        } else {
            policy.setStartDate(null);
            policy.setEndDate(null);
        }
        policy.setRpName(name);
        policy.setRpDescription(reason);
        return policy;
    }
}

