/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.service.NewsService;
import org.dspace.utils.DSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsManager {
    private static final Logger log = LoggerFactory.getLogger(NewsManager.class);

    private NewsManager() {
    }

    public static String readNewsFile(String newsFile) {
        NewsService newsService = (NewsService)new DSpace().getSingletonService(NewsService.class);
        if (!newsService.validate(newsFile)) {
            throw new IllegalArgumentException("The file " + newsFile + " is not a valid news file");
        }
        String fileName = NewsManager.getNewsFilePath();
        fileName = fileName + newsFile;
        StringBuilder text = new StringBuilder();
        try {
            String lineIn;
            FileInputStream fir = new FileInputStream(fileName);
            InputStreamReader ir = new InputStreamReader((InputStream)fir, "UTF-8");
            BufferedReader br = new BufferedReader(ir);
            while ((lineIn = br.readLine()) != null) {
                text.append(lineIn);
            }
            br.close();
            ir.close();
            fir.close();
        }
        catch (IOException e) {
            log.warn("news_read: " + e.getLocalizedMessage());
        }
        return text.toString();
    }

    public static String writeNewsFile(String newsFile, String news) {
        NewsService newsService = (NewsService)new DSpace().getSingletonService(NewsService.class);
        if (!newsService.validate(newsFile)) {
            throw new IllegalArgumentException("The file " + newsFile + " is not a valid news file");
        }
        String fileName = NewsManager.getNewsFilePath();
        fileName = fileName + newsFile;
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            PrintWriter out = new PrintWriter(osr);
            out.print(news);
            out.close();
        }
        catch (IOException e) {
            log.warn("news_write: " + e.getLocalizedMessage());
        }
        return news;
    }

    public static String getNewsFilePath() {
        String filePath = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator;
        return filePath;
    }
}

