/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InstallItem;
import org.dspace.content.ItemIterator;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.authority.ChoiceAuthorityManager;
import org.dspace.content.authority.Choices;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.event.Event;
import org.dspace.handle.HandleManager;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierService;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersioningService;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class Item
extends DSpaceObject {
    public static final String ANY = "*";
    private static final Logger log = Logger.getLogger(Item.class);
    private final TableRow itemRow;
    private EPerson submitter;
    private List<Bundle> bundles;
    private String handle;
    private boolean modified;

    Item(Context context, TableRow row) throws SQLException {
        super(context);
        if (null == row.getTable()) {
            row.setTable("item");
        }
        this.itemRow = row;
        this.modified = false;
        this.clearDetails();
        this.handle = HandleManager.findHandle(context, this);
        context.cache(this, row.getIntColumn("item_id"));
    }

    public static Item find(Context context, int id) throws SQLException {
        Item fromCache = (Item)context.fromCache(Item.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "item", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_item", "not_found,item_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_item", "item_id=" + id));
        }
        return new Item(context, row);
    }

    static Item create(Context context) throws SQLException, AuthorizeException {
        TableRow row = DatabaseManager.create(context, "item");
        Item i = new Item(context, row);
        i.setDiscoverable(true);
        context.turnOffAuthorisationSystem();
        i.update();
        context.restoreAuthSystemState();
        context.addEvent(new Event(1, 2, i.getID(), null, i.getIdentifiers(context)));
        log.info((Object)LogManager.getHeader(context, "create_item", "item_id=" + row.getIntColumn("item_id")));
        return i;
    }

    public static ItemIterator findAll(Context context) throws SQLException {
        String myQuery = "SELECT * FROM item WHERE in_archive='1'";
        TableRowIterator rows = DatabaseManager.queryTable(context, "item", myQuery, new Object[0]);
        return new ItemIterator(context, rows);
    }

    public static ItemIterator findAllUnfiltered(Context context) throws SQLException {
        String myQuery = "SELECT * FROM item WHERE in_archive='1' or withdrawn='1'";
        TableRowIterator rows = DatabaseManager.queryTable(context, "item", myQuery, new Object[0]);
        return new ItemIterator(context, rows);
    }

    public static ItemIterator findBySubmitter(Context context, EPerson eperson) throws SQLException {
        String myQuery = "SELECT * FROM item WHERE in_archive='1' AND submitter_id=" + eperson.getID();
        TableRowIterator rows = DatabaseManager.queryTable(context, "item", myQuery, new Object[0]);
        return new ItemIterator(context, rows);
    }

    public static ItemIterator findByMetadataFieldAuthority(Context context, String mdString, String authority) throws SQLException, AuthorizeException, IOException {
        String[] elements = Item.getElementsFilled(mdString);
        String schema = elements[0];
        String element = elements[1];
        String qualifier = elements[2];
        MetadataSchema mds = MetadataSchema.find(context, schema);
        if (mds == null) {
            throw new IllegalArgumentException("No such metadata schema: " + schema);
        }
        MetadataField mdf = MetadataField.findByElement(context, mds.getSchemaID(), element, qualifier);
        if (mdf == null) {
            throw new IllegalArgumentException("No such metadata field: schema=" + schema + ", element=" + element + ", qualifier=" + qualifier);
        }
        String query = "SELECT item.* FROM metadatavalue,item WHERE item.in_archive='1' AND item.item_id = metadatavalue.resource_id AND metadatavalue.resource_type_id=2 AND metadata_field_id = ?";
        TableRowIterator rows = null;
        if (ANY.equals(authority)) {
            rows = DatabaseManager.queryTable(context, "item", query, mdf.getFieldID());
        } else {
            query = query + " AND metadatavalue.authority = ?";
            rows = DatabaseManager.queryTable(context, "item", query, mdf.getFieldID(), authority);
        }
        return new ItemIterator(context, rows);
    }

    public static ItemIterator findBySubmitterDateSorted(Context context, EPerson eperson, Integer limit) throws SQLException {
        TableRowIterator rows;
        String querySorted = "SELECT item.item_id, item.submitter_id, item.in_archive, item.withdrawn, item.owning_collection, item.last_modified, metadatavalue.text_value FROM item, metadatafieldregistry, metadatavalue WHERE metadatafieldregistry.metadata_field_id = metadatavalue.metadata_field_id AND   metadatavalue.resource_id = item.item_id AND   metadatavalue.resource_type_id = ? AND   metadatafieldregistry.element = 'date' AND   metadatafieldregistry.qualifier = 'accessioned' AND   item.submitter_id = ? AND ";
        querySorted = DatabaseManager.isOracle() ? querySorted + " item.in_archive = 1 ORDER BY cast(substr(metadatavalue.text_value,1,100) as varchar2(100)) desc" : querySorted + " item.in_archive = true ORDER BY metadatavalue.text_value desc";
        if (limit != null && limit > 0) {
            querySorted = DatabaseManager.isOracle() ? "SELECT * FROM (" + querySorted + ") WHERE ROWNUM <= ?" : querySorted + " limit ?";
            rows = DatabaseManager.query(context, querySorted, 2, eperson.getID(), limit);
        } else {
            rows = DatabaseManager.query(context, querySorted, 2, eperson.getID());
        }
        return new ItemIterator(context, rows);
    }

    @Override
    public int getID() {
        return this.itemRow.getIntColumn("item_id");
    }

    @Override
    public String getHandle() {
        if (this.handle == null) {
            try {
                this.handle = HandleManager.findHandle(this.ourContext, this);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.handle;
    }

    public boolean isArchived() {
        return this.itemRow.getBooleanColumn("in_archive");
    }

    public boolean isWithdrawn() {
        return this.itemRow.getBooleanColumn("withdrawn");
    }

    public boolean isDiscoverable() {
        return this.itemRow.getBooleanColumn("discoverable");
    }

    public Date getLastModified() {
        Date myDate = this.itemRow.getDateColumn("last_modified");
        if (myDate == null) {
            myDate = new Date();
        }
        return myDate;
    }

    @Override
    public void updateLastModified() {
        try {
            Timestamp lastModified = new Timestamp(new Date().getTime());
            this.itemRow.setColumn("last_modified", lastModified);
            DatabaseManager.updateQuery(this.ourContext, "UPDATE item SET last_modified = ? WHERE item_id= ? ", lastModified, this.getID());
            this.ourContext.addEvent(new Event(2, 2, this.getID(), null, this.getIdentifiers(this.ourContext)));
        }
        catch (SQLException e) {
            log.error((Object)LogManager.getHeader(this.ourContext, "Error while updating last modified timestamp", "Item: " + this.getID()));
        }
    }

    public void setArchived(boolean isArchived) {
        this.itemRow.setColumn("in_archive", isArchived);
        this.modified = true;
    }

    public void setDiscoverable(boolean discoverable) {
        this.itemRow.setColumn("discoverable", discoverable);
        this.modified = true;
    }

    public void setOwningCollection(Collection c) {
        this.itemRow.setColumn("owning_collection", c.getID());
        this.modified = true;
    }

    public Collection getOwningCollection() throws SQLException {
        Collection myCollection = null;
        int cid = this.itemRow.getIntColumn("owning_collection");
        myCollection = Collection.find(this.ourContext, cid);
        return myCollection;
    }

    private int getOwningCollectionID() {
        return this.itemRow.getIntColumn("owning_collection");
    }

    public EPerson getSubmitter() throws SQLException {
        if (this.submitter == null && !this.itemRow.isColumnNull("submitter_id")) {
            this.submitter = EPerson.find(this.ourContext, this.itemRow.getIntColumn("submitter_id"));
        }
        return this.submitter;
    }

    public void setSubmitter(EPerson sub) {
        this.submitter = sub;
        if (this.submitter != null) {
            this.itemRow.setColumn("submitter_id", this.submitter.getID());
        } else {
            this.itemRow.setColumnNull("submitter_id");
        }
        this.modified = true;
    }

    public boolean isIn(Collection collection) throws SQLException {
        TableRow tr = DatabaseManager.querySingle(this.ourContext, "SELECT COUNT(*) AS count FROM collection2item WHERE collection_id = ? AND item_id = ?", collection.getID(), this.itemRow.getIntColumn("item_id"));
        return tr.getLongColumn("count") > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection[] getCollections() throws SQLException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        try (TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "collection", "SELECT collection.* FROM collection, collection2item WHERE collection2item.collection_id=collection.collection_id AND collection2item.item_id= ? ", this.itemRow.getIntColumn("item_id"));){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                Collection fromCache = (Collection)this.ourContext.fromCache(Collection.class, row.getIntColumn("collection_id"));
                if (fromCache != null) {
                    collections.add(fromCache);
                    continue;
                }
                collections.add(new Collection(this.ourContext, row));
            }
        }
        Collection[] collectionArray = new Collection[collections.size()];
        collectionArray = collections.toArray(collectionArray);
        return collectionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Community[] getCommunities() throws SQLException {
        ArrayList<Community> communities = new ArrayList<Community>();
        try (TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community", "SELECT community.* FROM community, community2item WHERE community2item.community_id=community.community_id AND community2item.item_id= ? ", this.itemRow.getIntColumn("item_id"));){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                Community owner = (Community)this.ourContext.fromCache(Community.class, row.getIntColumn("community_id"));
                if (owner == null) {
                    owner = new Community(this.ourContext, row);
                }
                communities.add(owner);
                Community[] parents = owner.getAllParents();
                communities.addAll(Arrays.asList(parents));
            }
        }
        Community[] communityArray = new Community[communities.size()];
        communityArray = communities.toArray(communityArray);
        return communityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() throws SQLException {
        if (this.bundles == null) {
            this.bundles = new ArrayList<Bundle>();
            try (TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "bundle", "SELECT bundle.* FROM bundle, item2bundle WHERE item2bundle.bundle_id=bundle.bundle_id AND item2bundle.item_id= ? ", this.itemRow.getIntColumn("item_id"));){
                while (tri.hasNext()) {
                    TableRow r = tri.next();
                    Bundle fromCache = (Bundle)this.ourContext.fromCache(Bundle.class, r.getIntColumn("bundle_id"));
                    if (fromCache != null) {
                        this.bundles.add(fromCache);
                        continue;
                    }
                    this.bundles.add(new Bundle(this.ourContext, r));
                }
            }
        }
        Bundle[] bundleArray = new Bundle[this.bundles.size()];
        bundleArray = this.bundles.toArray(bundleArray);
        return bundleArray;
    }

    public Bundle[] getBundles(String name) throws SQLException {
        ArrayList<Bundle> matchingBundles = new ArrayList<Bundle>();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            if (!name.equals(bunds[i].getName())) continue;
            matchingBundles.add(bunds[i]);
        }
        Bundle[] bundleArray = new Bundle[matchingBundles.size()];
        bundleArray = matchingBundles.toArray(bundleArray);
        return bundleArray;
    }

    public Bundle createBundle(String name) throws SQLException, AuthorizeException {
        if (name == null || "".equals(name)) {
            throw new SQLException("Bundle must be created with non-null name");
        }
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        Bundle b = Bundle.create(this.ourContext);
        b.setName(name);
        b.update();
        this.addBundle(b);
        return b;
    }

    public void addBundle(Bundle b) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        log.info((Object)LogManager.getHeader(this.ourContext, "add_bundle", "item_id=" + this.getID() + ",bundle_id=" + b.getID()));
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            if (b.getID() != bunds[i].getID()) continue;
            return;
        }
        AuthorizeManager.inheritPolicies(this.ourContext, this, b);
        this.bundles.add(b);
        TableRow mappingRow = DatabaseManager.row("item2bundle");
        mappingRow.setColumn("item_id", this.getID());
        mappingRow.setColumn("bundle_id", b.getID());
        DatabaseManager.insert(this.ourContext, mappingRow);
        this.ourContext.addEvent(new Event(8, 2, this.getID(), 1, b.getID(), b.getName(), this.getIdentifiers(this.ourContext)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundle(Bundle b) throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        log.info((Object)LogManager.getHeader(this.ourContext, "remove_bundle", "item_id=" + this.getID() + ",bundle_id=" + b.getID()));
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            if (b.getID() != bunds[i].getID()) continue;
            this.bundles.remove(bunds[i]);
            break;
        }
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM item2bundle WHERE item_id= ? AND bundle_id= ? ", this.getID(), b.getID());
        this.ourContext.addEvent(new Event(16, 2, this.getID(), 1, b.getID(), b.getName(), this.getIdentifiers(this.ourContext)));
        try (TableRowIterator tri = DatabaseManager.query(this.ourContext, "SELECT * FROM item2bundle WHERE bundle_id= ? ", b.getID());){
            if (!tri.hasNext()) {
                AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)b, 2, this.ourContext.getCurrentUser());
                AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)b, 4, this.ourContext.getCurrentUser());
                b.delete();
            }
        }
    }

    public Bitstream createSingleBitstream(InputStream is, String name) throws AuthorizeException, IOException, SQLException {
        Bundle bnd = this.createBundle(name);
        Bitstream bitstream = bnd.createBitstream(is);
        this.addBundle(bnd);
        return bitstream;
    }

    public Bitstream createSingleBitstream(InputStream is) throws AuthorizeException, IOException, SQLException {
        return this.createSingleBitstream(is, "ORIGINAL");
    }

    public Bitstream[] getNonInternalBitstreams() throws SQLException {
        ArrayList<Bitstream> bitstreamList = new ArrayList<Bitstream>();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            Bitstream[] bitstreams = bunds[i].getBitstreams();
            for (int j = 0; j < bitstreams.length; ++j) {
                if (bitstreams[j].getFormat().isInternal()) continue;
                bitstreamList.add(bitstreams[j]);
            }
        }
        return bitstreamList.toArray(new Bitstream[bitstreamList.size()]);
    }

    public void removeDSpaceLicense() throws SQLException, AuthorizeException, IOException {
        Bundle[] bunds = this.getBundles("LICENSE");
        for (int i = 0; i < bunds.length; ++i) {
            this.removeBundle(bunds[i]);
        }
    }

    public void removeLicenses() throws SQLException, AuthorizeException, IOException {
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(this.ourContext, "License");
        int licensetype = bf.getID();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            boolean removethisbundle = false;
            Bitstream[] bits = bunds[i].getBitstreams();
            for (int j = 0; j < bits.length; ++j) {
                BitstreamFormat bft = bits[j].getFormat();
                if (bft.getID() != licensetype) continue;
                removethisbundle = true;
            }
            if (!removethisbundle) continue;
            this.removeBundle(bunds[i]);
        }
    }

    @Override
    public void update() throws SQLException, AuthorizeException {
        int k;
        Bitstream[] streams;
        int i;
        if (!this.canEdit()) {
            AuthorizeManager.authorizeAction(this.ourContext, this, 1);
        }
        log.info((Object)LogManager.getHeader(this.ourContext, "update_item", "item_id=" + this.getID()));
        int sequence = 0;
        Bundle[] bunds = this.getBundles();
        for (i = 0; i < bunds.length; ++i) {
            streams = bunds[i].getBitstreams();
            for (k = 0; k < streams.length; ++k) {
                if (streams[k].getSequenceID() <= sequence) continue;
                sequence = streams[k].getSequenceID();
            }
        }
        ++sequence;
        for (i = 0; i < bunds.length; ++i) {
            streams = bunds[i].getBitstreams();
            for (k = 0; k < streams.length; ++k) {
                if (streams[k].getSequenceID() >= 0) continue;
                streams[k].setSequenceID(sequence);
                ++sequence;
                streams[k].update();
                this.modified = true;
            }
        }
        if (this.modifiedMetadata || this.modified) {
            this.itemRow.setColumn("last_modified", new Date());
            if (this.itemRow.isColumnNull("in_archive")) {
                this.itemRow.setColumn("in_archive", false);
            }
            if (this.itemRow.isColumnNull("withdrawn")) {
                this.itemRow.setColumn("withdrawn", false);
            }
            if (this.itemRow.isColumnNull("discoverable")) {
                this.itemRow.setColumn("discoverable", false);
            }
            DatabaseManager.update(this.ourContext, this.itemRow);
            if (this.modifiedMetadata) {
                this.updateMetadata();
                this.clearDetails();
            }
            this.ourContext.addEvent(new Event(2, 2, this.getID(), null, this.getIdentifiers(this.ourContext)));
            this.modified = false;
        }
    }

    public void withdraw() throws SQLException, AuthorizeException, IOException {
        AuthorizeUtil.authorizeWithdrawItem(this.ourContext, this);
        String timestamp = DCDate.getCurrent().toString();
        EPerson e = this.ourContext.getCurrentUser();
        StringBuilder prov = new StringBuilder();
        prov.append("Item withdrawn by ").append(e.getFullName()).append(" (").append(e.getEmail()).append(") on ").append(timestamp).append("\n").append("Item was in collections:\n");
        Collection[] colls = this.getCollections();
        for (int i = 0; i < colls.length; ++i) {
            prov.append(colls[i].getMetadata("name")).append(" (ID: ").append(colls[i].getID()).append(")\n");
        }
        this.itemRow.setColumn("withdrawn", true);
        this.itemRow.setColumn("in_archive", false);
        prov.append(InstallItem.getBitstreamProvenanceMessage(this));
        this.addDC("description", "provenance", "en", prov.toString());
        this.update();
        this.ourContext.addEvent(new Event(2, 2, this.getID(), "WITHDRAW", this.getIdentifiers(this.ourContext)));
        AuthorizeManager.switchPoliciesAction(this.ourContext, this, 0, 12);
        for (Bundle bnd : this.getBundles()) {
            AuthorizeManager.switchPoliciesAction(this.ourContext, bnd, 0, 12);
            for (Bitstream bs : bnd.getBitstreams()) {
                AuthorizeManager.switchPoliciesAction(this.ourContext, bs, 0, 12);
            }
        }
        log.info((Object)LogManager.getHeader(this.ourContext, "withdraw_item", "user=" + e.getEmail() + ",item_id=" + this.getID()));
    }

    public void reinstate() throws SQLException, AuthorizeException, IOException {
        AuthorizeUtil.authorizeReinstateItem(this.ourContext, this);
        String timestamp = DCDate.getCurrent().toString();
        Collection[] colls = this.getCollections();
        EPerson e = this.ourContext.getCurrentUser();
        StringBuilder prov = new StringBuilder();
        prov.append("Item reinstated by ").append(e.getFullName()).append(" (").append(e.getEmail()).append(") on ").append(timestamp).append("\n").append("Item was in collections:\n");
        for (int i = 0; i < colls.length; ++i) {
            prov.append(colls[i].getMetadata("name")).append(" (ID: ").append(colls[i].getID()).append(")\n");
        }
        this.itemRow.setColumn("withdrawn", false);
        this.itemRow.setColumn("in_archive", true);
        prov.append(InstallItem.getBitstreamProvenanceMessage(this));
        this.addDC("description", "provenance", "en", prov.toString());
        this.update();
        this.ourContext.addEvent(new Event(2, 2, this.getID(), "REINSTATE", this.getIdentifiers(this.ourContext)));
        for (Bundle bnd : this.getBundles()) {
            AuthorizeManager.switchPoliciesAction(this.ourContext, bnd, 12, 0);
            for (Bitstream bs : bnd.getBitstreams()) {
                AuthorizeManager.switchPoliciesAction(this.ourContext, bs, 12, 0);
            }
        }
        if (AuthorizeManager.getPoliciesActionFilter(this.ourContext, this, 12).size() != 0) {
            AuthorizeManager.switchPoliciesAction(this.ourContext, this, 12, 0);
        } else if (colls.length > 0) {
            this.adjustItemPolicies(this.getOwningCollection());
        }
        log.info((Object)LogManager.getHeader(this.ourContext, "reinstate_item", "user=" + e.getEmail() + ",item_id=" + this.getID()));
    }

    void delete() throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        this.ourContext.addEvent(new Event(32, 2, this.getID(), this.getHandle(), this.getIdentifiers(this.ourContext)));
        log.info((Object)LogManager.getHeader(this.ourContext, "delete_item", "item_id=" + this.getID()));
        this.ourContext.removeCached(this, this.getID());
        try {
            IndexBrowse ib = new IndexBrowse(this.ourContext);
            ib.itemRemoved(this);
        }
        catch (BrowseException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SQLException(e.getMessage(), e);
        }
        this.removeMetadataFromDatabase();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            this.removeBundle(bunds[i]);
        }
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        HandleManager.unbindHandle(this.ourContext, this);
        this.removeVersion();
        DatabaseManager.delete(this.ourContext, this.itemRow);
    }

    private void removeVersion() throws AuthorizeException, SQLException {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (versioningService.getVersion(this.ourContext, this) != null) {
            versioningService.removeVersion(this.ourContext, this);
        } else {
            IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
            try {
                identifierService.delete(this.ourContext, this);
            }
            catch (IdentifierException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void decache() throws SQLException {
        this.ourContext.removeCached(this, this.getID());
        if (this.submitter != null) {
            this.ourContext.removeCached(this.submitter, this.submitter.getID());
        }
        if (this.bundles != null) {
            Bundle[] bunds = this.getBundles();
            for (int i = 0; i < bunds.length; ++i) {
                this.ourContext.removeCached(bunds[i], bunds[i].getID());
                Bitstream[] bitstreams = bunds[i].getBitstreams();
                for (int j = 0; j < bitstreams.length; ++j) {
                    this.ourContext.removeCached(bitstreams[j], bitstreams[j].getID());
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        return this.getID() == other.getID();
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.itemRow != null ? this.itemRow.hashCode() : 0);
        return hash;
    }

    public boolean isOwningCollection(Collection c) {
        int owner_id = this.itemRow.getIntColumn("owning_collection");
        return c.getID() == owner_id;
    }

    @Override
    public int getType() {
        return 2;
    }

    public void replaceAllItemPolicies(List<ResourcePolicy> newpolicies) throws SQLException, AuthorizeException {
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        AuthorizeManager.addPolicies(this.ourContext, newpolicies, this);
    }

    public void replaceAllBitstreamPolicies(List<ResourcePolicy> newpolicies) throws SQLException, AuthorizeException {
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            Bundle mybundle = bunds[i];
            mybundle.replaceAllBitstreamPolicies(newpolicies);
        }
    }

    public void removeGroupPolicies(Group g) throws SQLException {
        AuthorizeManager.removeGroupPolicies(this.ourContext, this, g);
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            Bundle mybundle = bunds[i];
            Bitstream[] bs = mybundle.getBitstreams();
            for (int j = 0; j < bs.length; ++j) {
                AuthorizeManager.removeGroupPolicies(this.ourContext, bs[j], g);
            }
            AuthorizeManager.removeGroupPolicies(this.ourContext, mybundle, g);
        }
    }

    public void inheritCollectionDefaultPolicies(Collection c) throws SQLException, AuthorizeException {
        this.adjustItemPolicies(c);
        this.adjustBundleBitstreamPolicies(c);
        log.debug((Object)LogManager.getHeader(this.ourContext, "item_inheritCollectionDefaultPolicies", "item_id=" + this.getID()));
    }

    public void adjustBundleBitstreamPolicies(Collection c) throws SQLException, AuthorizeException {
        List<ResourcePolicy> defaultCollectionPolicies = AuthorizeManager.getPoliciesActionFilter(this.ourContext, c, 9);
        if (defaultCollectionPolicies.size() < 1) {
            throw new SQLException("Collection " + c.getID() + " (" + c.getHandle() + ")" + " has no default bitstream READ policies");
        }
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            Bundle mybundle = bunds[i];
            AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, mybundle, ResourcePolicy.TYPE_SUBMISSION);
            AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, mybundle, ResourcePolicy.TYPE_WORKFLOW);
            List<ResourcePolicy> policiesBundleToAdd = this.filterPoliciesToAdd(defaultCollectionPolicies, mybundle);
            AuthorizeManager.addPolicies(this.ourContext, policiesBundleToAdd, mybundle);
            for (Bitstream bitstream : mybundle.getBitstreams()) {
                AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, bitstream, ResourcePolicy.TYPE_SUBMISSION);
                AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, bitstream, ResourcePolicy.TYPE_WORKFLOW);
                List<ResourcePolicy> policiesBitstreamToAdd = this.filterPoliciesToAdd(defaultCollectionPolicies, bitstream);
                AuthorizeManager.addPolicies(this.ourContext, policiesBitstreamToAdd, bitstream);
            }
        }
    }

    public void adjustItemPolicies(Collection c) throws SQLException, AuthorizeException {
        List<ResourcePolicy> defaultCollectionPolicies = AuthorizeManager.getPoliciesActionFilter(this.ourContext, c, 10);
        if (defaultCollectionPolicies.size() < 1) {
            throw new SQLException("Collection " + c.getID() + " (" + c.getHandle() + ")" + " has no default item READ policies");
        }
        AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, this, ResourcePolicy.TYPE_SUBMISSION);
        AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, this, ResourcePolicy.TYPE_WORKFLOW);
        List<ResourcePolicy> policiesToAdd = this.filterPoliciesToAdd(defaultCollectionPolicies, this);
        AuthorizeManager.addPolicies(this.ourContext, policiesToAdd, this);
    }

    private List<ResourcePolicy> filterPoliciesToAdd(List<ResourcePolicy> defaultCollectionPolicies, DSpaceObject dso) throws SQLException {
        ArrayList<ResourcePolicy> policiesToAdd = new ArrayList<ResourcePolicy>();
        for (ResourcePolicy rp : defaultCollectionPolicies) {
            rp.setAction(0);
            if (AuthorizeManager.isAnIdenticalPolicyAlreadyInPlace(this.ourContext, dso, rp)) continue;
            rp.setRpType(ResourcePolicy.TYPE_INHERITED);
            policiesToAdd.add(rp);
        }
        return policiesToAdd;
    }

    public void move(Collection from, Collection to) throws SQLException, AuthorizeException, IOException {
        this.move(from, to, false);
    }

    public void move(Collection from, Collection to, boolean inheritDefaultPolicies) throws SQLException, AuthorizeException, IOException {
        if (!this.canEdit()) {
            AuthorizeManager.authorizeAction(this.ourContext, this, 1);
        }
        to.addItem(this);
        from.removeItem(this);
        if (this.isOwningCollection(from)) {
            log.info((Object)LogManager.getHeader(this.ourContext, "move_item", "item_id=" + this.getID() + ", from " + "collection_id=" + from.getID() + " to " + "collection_id=" + to.getID()));
            this.setOwningCollection(to);
            if (inheritDefaultPolicies) {
                log.info((Object)LogManager.getHeader(this.ourContext, "move_item", "Updating item with inherited policies"));
                this.inheritCollectionDefaultPolicies(to);
            }
            this.ourContext.turnOffAuthorisationSystem();
            this.update();
            this.ourContext.restoreAuthSystemState();
        } else {
            this.ourContext.addEvent(new Event(2, 2, this.getID(), null, this.getIdentifiers(this.ourContext)));
        }
    }

    public boolean hasUploadedFiles() throws SQLException {
        Bundle[] bundles = this.getBundles("ORIGINAL");
        if (bundles.length == 0) {
            return false;
        }
        Bitstream[] bitstreams = bundles[0].getBitstreams();
        return bitstreams.length != 0;
    }

    public Collection[] getCollectionsNotLinked() throws SQLException {
        Collection[] allCollections = Collection.findAll(this.ourContext);
        Collection[] linkedCollections = this.getCollections();
        Collection[] notLinkedCollections = new Collection[allCollections.length - linkedCollections.length];
        if (allCollections.length - linkedCollections.length == 0) {
            return notLinkedCollections;
        }
        int i = 0;
        for (Collection collection : allCollections) {
            boolean alreadyLinked = false;
            for (Collection linkedCommunity : linkedCollections) {
                if (collection.getID() != linkedCommunity.getID()) continue;
                alreadyLinked = true;
                break;
            }
            if (alreadyLinked) continue;
            notLinkedCollections[i++] = collection;
        }
        return notLinkedCollections;
    }

    public boolean canEdit() throws SQLException {
        if (AuthorizeManager.authorizeActionBoolean(this.ourContext, this, 1)) {
            return true;
        }
        if (this.getOwningCollection() == null) {
            return !this.isInProgressSubmission();
        }
        return this.getOwningCollection().canEditBoolean(false);
    }

    public boolean isInProgressSubmission() throws SQLException {
        return WorkspaceItem.findByItem(this.ourContext, this) != null || ConfigurationManager.getProperty("workflow", "workflow.framework").equals("xmlworkflow") && XmlWorkflowItem.findByItem(this.ourContext, this) != null || WorkflowItem.findByItem(this.ourContext, this) != null;
    }

    @Override
    public String getName() {
        return this.getMetadataFirstValue("dc", "title", null, ANY);
    }

    public static ItemIterator findByMetadataField(Context context, String schema, String element, String qualifier, String value) throws SQLException, AuthorizeException, IOException {
        MetadataSchema mds = MetadataSchema.find(context, schema);
        if (mds == null) {
            throw new IllegalArgumentException("No such metadata schema: " + schema);
        }
        MetadataField mdf = MetadataField.findByElement(context, mds.getSchemaID(), element, qualifier);
        if (mdf == null) {
            throw new IllegalArgumentException("No such metadata field: schema=" + schema + ", element=" + element + ", qualifier=" + qualifier);
        }
        String query = "SELECT item.* FROM metadatavalue,item WHERE item.in_archive='1' AND item.item_id = metadatavalue.resource_id AND metadata_field_id = ? AND resource_type_id = ?";
        TableRowIterator rows = null;
        if (ANY.equals(value)) {
            rows = DatabaseManager.queryTable(context, "item", query, mdf.getFieldID(), 2);
        } else {
            query = query + " AND metadatavalue.text_value = ?";
            rows = DatabaseManager.queryTable(context, "item", query, mdf.getFieldID(), 2, value);
        }
        return new ItemIterator(context, rows);
    }

    @Override
    public DSpaceObject getAdminObject(int action) throws SQLException {
        DSpaceObject adminObject = null;
        Collection collection = this.getOwningCollection();
        Community community = null;
        if (collection != null) {
            Community[] communities = collection.getCommunities();
            if (communities != null && communities.length > 0) {
                community = communities[0];
            }
        } else {
            Community[] communities;
            TableRow qResult = DatabaseManager.querySingle(this.ourContext, "SELECT collection_id FROM collection WHERE template_item_id = ?", this.getID());
            if (qResult != null && (communities = (collection = Collection.find(this.ourContext, qResult.getIntColumn("collection_id"))).getCommunities()) != null && communities.length > 0) {
                community = communities[0];
            }
        }
        switch (action) {
            case 3: {
                if (AuthorizeConfiguration.canItemAdminPerformBitstreamCreation()) {
                    adminObject = this;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminPerformBitstreamCreation()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformBitstreamCreation()) break;
                adminObject = community;
                break;
            }
            case 4: {
                if (AuthorizeConfiguration.canItemAdminPerformBitstreamDeletion()) {
                    adminObject = this;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminPerformBitstreamDeletion()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformBitstreamDeletion()) break;
                adminObject = community;
                break;
            }
            case 2: {
                if (this.getOwningCollection() != null) {
                    if (AuthorizeConfiguration.canCollectionAdminPerformItemDeletion()) {
                        adminObject = collection;
                        break;
                    }
                    if (!AuthorizeConfiguration.canCommunityAdminPerformItemDeletion()) break;
                    adminObject = community;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminManageTemplateItem()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminManageCollectionTemplateItem()) break;
                adminObject = community;
                break;
            }
            case 1: {
                if (this.getOwningCollection() == null) {
                    if (AuthorizeConfiguration.canCollectionAdminManageTemplateItem()) {
                        adminObject = collection;
                        break;
                    }
                    if (!AuthorizeConfiguration.canCommunityAdminManageCollectionTemplateItem()) break;
                    adminObject = community;
                    break;
                }
                adminObject = this;
                break;
            }
            default: {
                adminObject = this;
            }
        }
        return adminObject;
    }

    @Override
    public DSpaceObject getParentObject() throws SQLException {
        Collection ownCollection = this.getOwningCollection();
        if (ownCollection != null) {
            return ownCollection;
        }
        TableRow qResult = DatabaseManager.querySingle(this.ourContext, "SELECT collection_id FROM collection WHERE template_item_id = ?", this.getID());
        if (qResult != null) {
            return Collection.find(this.ourContext, qResult.getIntColumn("collection_id"));
        }
        return null;
    }

    public static ItemIterator findByAuthorityValue(Context context, String schema, String element, String qualifier, String value) throws SQLException, AuthorizeException, IOException {
        MetadataSchema mds = MetadataSchema.find(context, schema);
        if (mds == null) {
            throw new IllegalArgumentException("No such metadata schema: " + schema);
        }
        MetadataField mdf = MetadataField.findByElement(context, mds.getSchemaID(), element, qualifier);
        if (mdf == null) {
            throw new IllegalArgumentException("No such metadata field: schema=" + schema + ", element=" + element + ", qualifier=" + qualifier);
        }
        TableRowIterator rows = DatabaseManager.queryTable(context, "item", "SELECT item.* FROM metadatavalue,item WHERE item.in_archive='1' AND item.item_id = metadatavalue.resource_id AND metadata_field_id = ? AND authority = ? AND resource_type_id = ?", mdf.getFieldID(), value, 2);
        return new ItemIterator(context, rows);
    }

    @Override
    protected void getAuthoritiesAndConfidences(String fieldKey, String[] values, String[] authorities, int[] confidences, int i) {
        Choices c = ChoiceAuthorityManager.getManager().getBestMatch(fieldKey, values[i], this.getOwningCollectionID(), null);
        authorities[i] = c.values.length > 0 ? c.values[0].authority : null;
        confidences[i] = c.confidence;
    }
}

