/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemmarking;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.dspace.app.itemmarking.ItemMarkingExtractor;
import org.dspace.app.itemmarking.ItemMarkingInfo;
import org.dspace.app.util.Util;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.Context;

public class ItemMarkingAvailabilityBitstreamStrategy
implements ItemMarkingExtractor {
    private String availableImageName;
    private String nonAvailableImageName;

    @Override
    public ItemMarkingInfo getItemMarkingInfo(Context context, Item item) throws SQLException {
        Bundle[] bundles = item.getBundles("ORIGINAL");
        if (bundles.length == 0) {
            ItemMarkingInfo markInfo = new ItemMarkingInfo();
            markInfo.setImageName(this.nonAvailableImageName);
            return markInfo;
        }
        Bundle originalBundle = bundles[0];
        if (originalBundle.getBitstreams().length == 0) {
            ItemMarkingInfo markInfo = new ItemMarkingInfo();
            markInfo.setImageName(this.nonAvailableImageName);
            return markInfo;
        }
        Bitstream bitstream = originalBundle.getBitstreams()[0];
        ItemMarkingInfo signInfo = new ItemMarkingInfo();
        signInfo.setImageName(this.availableImageName);
        signInfo.setTooltip(bitstream.getName());
        String bsLink = "";
        bsLink = bsLink + "bitstream/" + item.getHandle() + "/" + bitstream.getSequenceID() + "/";
        try {
            bsLink = bsLink + Util.encodeBitstreamName(bitstream.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        signInfo.setLink(bsLink);
        return signInfo;
    }

    public void setAvailableImageName(String availableImageName) {
        this.availableImageName = availableImageName;
    }

    public void setNonAvailableImageName(String nonAvailableImageName) {
        this.nonAvailableImageName = nonAvailableImageName;
    }
}

