/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.Metadatum;
import org.dspace.core.Context;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DataCiteXMLCreator;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.identifier.ezid.EZIDRequest;
import org.dspace.identifier.ezid.EZIDRequestFactory;
import org.dspace.identifier.ezid.EZIDResponse;
import org.dspace.identifier.ezid.Transform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class EZIDIdentifierProvider
extends IdentifierProvider {
    private static final Logger log = LoggerFactory.getLogger(EZIDIdentifierProvider.class);
    static final String CFG_SHOULDER = "identifier.doi.ezid.shoulder";
    static final String CFG_USER = "identifier.doi.ezid.user";
    static final String CFG_PASSWORD = "identifier.doi.ezid.password";
    static final String CFG_PUBLISHER = "identifier.doi.ezid.publisher";
    static final String DATACITE_PUBLISHER = "datacite.publisher";
    static final String DATACITE_PUBLICATION_YEAR = "datacite.publicationyear";
    public static final String MD_SCHEMA = "dc";
    public static final String DOI_ELEMENT = "identifier";
    public static final String DOI_QUALIFIER = null;
    private static final String DOI_SCHEME = "doi:";
    protected boolean GENERATE_DATACITE_XML = false;
    protected String DATACITE_XML_CROSSWALK = "DataCite";
    private static Map<String, String> crosswalk = new HashMap<String, String>();
    private static Map<String, Transform> transforms = new HashMap<String, Transform>();
    private static EZIDRequestFactory requestFactory;

    @Override
    public boolean supports(Class<? extends Identifier> identifier) {
        return DOI.class.isAssignableFrom(identifier);
    }

    @Override
    public boolean supports(String identifier) {
        if (null == identifier) {
            return false;
        }
        return identifier.startsWith(DOI_SCHEME);
    }

    @Override
    public String register(Context context, DSpaceObject dso) throws IdentifierException {
        Metadatum[] identifiers;
        log.debug("register {}", (Object)dso);
        for (Metadatum identifier : identifiers = dso.getMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null)) {
            if (null == identifier.value || !identifier.value.startsWith(DOI_SCHEME)) continue;
            return identifier.value;
        }
        String id = this.mint(context, dso);
        dso.addMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null, id);
        try {
            dso.update();
            context.commit();
        }
        catch (SQLException | AuthorizeException ex) {
            throw new IdentifierException("New identifier not stored", ex);
        }
        log.info("Registered {}", (Object)id);
        return id;
    }

    @Override
    public void register(Context context, DSpaceObject object, String identifier) {
        EZIDResponse response;
        log.debug("register {} as {}", (Object)object, (Object)identifier);
        try {
            EZIDRequest request = requestFactory.getInstance(this.loadAuthority(), this.loadUser(), this.loadPassword());
            response = request.create(identifier, this.crosswalkMetadata(object));
        }
        catch (IOException | URISyntaxException | IdentifierException e) {
            log.error("Identifier '{}' not registered:  {}", (Object)identifier, (Object)e.getMessage());
            return;
        }
        if (response.isSuccess()) {
            try {
                object.addMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null, this.idToDOI(identifier));
                object.update();
                context.commit();
                log.info("registered {}", (Object)identifier);
            }
            catch (SQLException | AuthorizeException | IdentifierException ex) {
                log.error("New identifier not stored", (Throwable)ex);
            }
        } else {
            log.error("Identifier '{}' not registered -- EZID returned: {}", (Object)identifier, (Object)response.getEZIDStatusValue());
        }
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        EZIDResponse response;
        log.debug("reserve {}", (Object)identifier);
        try {
            EZIDRequest request = requestFactory.getInstance(this.loadAuthority(), this.loadUser(), this.loadPassword());
            Map<String, String> metadata = this.crosswalkMetadata(dso);
            metadata.put("_status", "reserved");
            response = request.create(identifier, metadata);
        }
        catch (IOException | URISyntaxException e) {
            log.error("Identifier '{}' not registered:  {}", (Object)identifier, (Object)e.getMessage());
            return;
        }
        if (response.isSuccess()) {
            dso.addMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null, this.idToDOI(identifier));
            try {
                dso.update();
                context.commit();
                log.info("reserved {}", (Object)identifier);
            }
            catch (SQLException | AuthorizeException ex) {
                throw new IdentifierException("New identifier not stored", ex);
            }
        } else {
            log.error("Identifier '{}' not registered -- EZID returned: {}", (Object)identifier, (Object)response.getEZIDStatusValue());
        }
    }

    @Override
    public String mint(Context context, DSpaceObject dso) throws IdentifierException {
        EZIDResponse response;
        EZIDRequest request;
        log.debug("mint for {}", (Object)dso);
        try {
            request = requestFactory.getInstance(this.loadAuthority(), this.loadUser(), this.loadPassword());
        }
        catch (URISyntaxException ex) {
            log.error(ex.getMessage());
            throw new IdentifierException("DOI request not sent:  " + ex.getMessage());
        }
        try {
            response = request.mint(this.crosswalkMetadata(dso));
        }
        catch (IOException | URISyntaxException ex) {
            log.error("Failed to send EZID request:  {}", (Object)ex.getMessage());
            throw new IdentifierException("DOI request not sent:  " + ex.getMessage());
        }
        if (201 != response.getHttpStatusCode()) {
            log.error("EZID server responded:  {} {}: {}", (Object[])new String[]{String.valueOf(response.getHttpStatusCode()), response.getHttpReasonPhrase(), response.getEZIDStatusValue()});
            throw new IdentifierException("DOI not created:  " + response.getHttpReasonPhrase() + ":  " + response.getEZIDStatusValue());
        }
        if (response.isSuccess()) {
            String value = response.getEZIDStatusValue();
            int end = value.indexOf(124);
            if (end < 0) {
                end = value.length();
            }
            String doi = value.substring(0, end).trim();
            log.info("Created {}", (Object)doi);
            return doi;
        }
        log.error("EZID responded:  {}", (Object)response.getEZIDStatusValue());
        throw new IdentifierException("No DOI returned");
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier, String ... attributes) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        ItemIterator found;
        log.debug("resolve {}", (Object)identifier);
        try {
            found = Item.findByMetadataField(context, MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, this.idToDOI(identifier));
        }
        catch (IOException | SQLException | AuthorizeException | IdentifierException ex) {
            log.error(ex.getMessage());
            throw new IdentifierNotResolvableException(ex);
        }
        try {
            if (!found.hasNext()) {
                throw new IdentifierNotFoundException("No object bound to " + identifier);
            }
            Item found1 = found.next();
            if (found.hasNext()) {
                log.error("More than one object bound to {}!", (Object)identifier);
            }
            log.debug("Resolved to {}", (Object)found1);
            return found1;
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
            throw new IdentifierNotResolvableException(ex);
        }
    }

    @Override
    public String lookup(Context context, DSpaceObject object) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        log.debug("lookup {}", (Object)object);
        Metadatum found = null;
        for (Metadatum candidate : object.getMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null)) {
            if (!candidate.value.startsWith(DOI_SCHEME)) continue;
            found = candidate;
            break;
        }
        if (null != found) {
            log.debug("Found {}", (Object)found.value);
            return found.value;
        }
        throw new IdentifierNotFoundException(object.getTypeText() + " " + object.getID() + " has no DOI");
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws IdentifierException {
        log.debug("delete {}", (Object)dso);
        Metadatum[] metadata = dso.getMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null);
        ArrayList<String> remainder = new ArrayList<String>();
        int skipped = 0;
        for (Metadatum id : metadata) {
            EZIDResponse response;
            if (!id.value.startsWith(DOI_SCHEME)) {
                remainder.add(id.value);
                continue;
            }
            try {
                EZIDRequest request = requestFactory.getInstance(this.loadAuthority(), this.loadUser(), this.loadPassword());
                response = request.delete(this.DOIToId(id.value));
            }
            catch (URISyntaxException e) {
                log.error("Bad URI in metadata value:  {}", (Object)e.getMessage());
                remainder.add(id.value);
                ++skipped;
                continue;
            }
            catch (IOException e) {
                log.error("Failed request to EZID:  {}", (Object)e.getMessage());
                remainder.add(id.value);
                ++skipped;
                continue;
            }
            if (!response.isSuccess()) {
                log.error("Unable to delete {} from DataCite:  {}", (Object)id.value, (Object)response.getEZIDStatusValue());
                remainder.add(id.value);
                ++skipped;
                continue;
            }
            log.info("Deleted {}", (Object)id.value);
        }
        dso.clearMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null);
        dso.addMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null, remainder.toArray(new String[remainder.size()]));
        try {
            dso.update();
            context.commit();
        }
        catch (SQLException | AuthorizeException e) {
            log.error("Failed to re-add identifiers:  {}", (Object)e.getMessage());
        }
        if (skipped > 0) {
            throw new IdentifierException(skipped + " identifiers could not be deleted.");
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        log.debug("delete {} from {}", (Object)identifier, (Object)dso);
        Metadatum[] metadata = dso.getMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null);
        ArrayList<String> remainder = new ArrayList<String>();
        int skipped = 0;
        for (Metadatum id : metadata) {
            EZIDResponse response;
            if (!id.value.equals(this.idToDOI(identifier))) {
                remainder.add(id.value);
                continue;
            }
            try {
                EZIDRequest request = requestFactory.getInstance(this.loadAuthority(), this.loadUser(), this.loadPassword());
                response = request.delete(this.DOIToId(id.value));
            }
            catch (URISyntaxException e) {
                log.error("Bad URI in metadata value {}:  {}", (Object)id.value, (Object)e.getMessage());
                remainder.add(id.value);
                ++skipped;
                continue;
            }
            catch (IOException e) {
                log.error("Failed request to EZID:  {}", (Object)e.getMessage());
                remainder.add(id.value);
                ++skipped;
                continue;
            }
            if (!response.isSuccess()) {
                log.error("Unable to delete {} from DataCite:  {}", (Object)id.value, (Object)response.getEZIDStatusValue());
                remainder.add(id.value);
                ++skipped;
                continue;
            }
            log.info("Deleted {}", (Object)id.value);
        }
        dso.clearMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null);
        dso.addMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null, remainder.toArray(new String[remainder.size()]));
        try {
            dso.update();
            context.commit();
        }
        catch (SQLException | AuthorizeException e) {
            log.error("Failed to re-add identifiers:  {}", (Object)e.getMessage());
        }
        if (skipped > 0) {
            throw new IdentifierException(identifier + " could not be deleted.");
        }
    }

    String idToDOI(String id) throws IdentifierException {
        return DOI_SCHEME + this.loadAuthority() + id;
    }

    String DOIToId(String DOI2) throws IdentifierException {
        String prefix = DOI_SCHEME + this.loadAuthority();
        if (DOI2.startsWith(prefix)) {
            return DOI2.substring(prefix.length());
        }
        return DOI2;
    }

    private String loadUser() throws IdentifierException {
        String user = this.configurationService.getProperty(CFG_USER);
        if (null != user) {
            return user;
        }
        throw new IdentifierException("Unconfigured:  define identifier.doi.ezid.user");
    }

    private String loadPassword() throws IdentifierException {
        String password = this.configurationService.getProperty(CFG_PASSWORD);
        if (null != password) {
            return password;
        }
        throw new IdentifierException("Unconfigured:  define identifier.doi.ezid.password");
    }

    private String loadAuthority() throws IdentifierException {
        String shoulder = this.configurationService.getProperty(CFG_SHOULDER);
        if (null != shoulder) {
            return shoulder;
        }
        throw new IdentifierException("Unconfigured:  define identifier.doi.ezid.shoulder");
    }

    Map<String, String> crosswalkMetadata(DSpaceObject dso) {
        String handle;
        if (null == dso || !(dso instanceof Item)) {
            throw new IllegalArgumentException("Must be an Item");
        }
        Item item = (Item)dso;
        HashMap<String, String> mapped = new HashMap<String, String>();
        for (Map.Entry<String, String> datum : crosswalk.entrySet()) {
            Metadatum[] values = item.getMetadataByMetadataString(datum.getValue());
            if (null == values) continue;
            for (Metadatum value : values) {
                String mappedValue;
                String key;
                block11: {
                    key = datum.getKey();
                    Transform xfrm = transforms.get(key);
                    if (null != xfrm) {
                        try {
                            mappedValue = xfrm.transform(value.value);
                            break block11;
                        }
                        catch (Exception ex) {
                            log.error("Unable to transform '{}' from {} to {}:  {}", (Object[])new String[]{value.value, value.toString(), key, ex.getMessage()});
                            continue;
                        }
                    }
                    mappedValue = value.value;
                }
                mapped.put(key, mappedValue);
            }
        }
        if (this.GENERATE_DATACITE_XML) {
            DataCiteXMLCreator xmlGen = new DataCiteXMLCreator();
            xmlGen.setDisseminationCrosswalkName(this.DATACITE_XML_CROSSWALK);
            String xmlString = xmlGen.getXMLString(dso);
            log.debug("Generated DataCite XML:  {}", (Object)xmlString);
            mapped.put("datacite", xmlString);
        }
        if (!mapped.containsKey(DATACITE_PUBLISHER) && !mapped.containsKey("datacite")) {
            String publisher = (String)this.configurationService.getPropertyAsType(CFG_PUBLISHER, (Object)"unknown");
            log.info("Supplying default publisher:  {}", (Object)publisher);
            mapped.put(DATACITE_PUBLISHER, publisher);
        }
        if (!mapped.containsKey(DATACITE_PUBLICATION_YEAR) && !mapped.containsKey("datacite")) {
            String year = String.valueOf(Calendar.getInstance().get(1));
            log.info("Supplying default publication year:  {}", (Object)year);
            mapped.put(DATACITE_PUBLICATION_YEAR, year);
        }
        if (null == (handle = dso.getHandle())) {
            log.warn("{} #{} has no handle -- location not set.", (Object)dso.getTypeText(), (Object)dso.getID());
        } else {
            String url = this.configurationService.getProperty("dspace.url") + "/handle/" + item.getHandle();
            log.info("Supplying location:  {}", (Object)url);
            mapped.put("_target", url);
        }
        return mapped;
    }

    @Required
    public void setCrosswalk(Map<String, String> aCrosswalk) {
        crosswalk = aCrosswalk;
    }

    public void setCrosswalkTransform(Map<String, Transform> transformMap) {
        transforms = transformMap;
    }

    public void setGenerateDataciteXML(boolean GENERATE_DATACITE_XML) {
        this.GENERATE_DATACITE_XML = GENERATE_DATACITE_XML;
    }

    public void setDisseminationCrosswalkName(String DATACITE_XML_CROSSWALK) {
        this.DATACITE_XML_CROSSWALK = DATACITE_XML_CROSSWALK;
    }

    @Required
    public static void setRequestFactory(EZIDRequestFactory aRequestFactory) {
        requestFactory = aRequestFactory;
    }
}

